/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.SharedCodeSourceFactory;
import oracle.ide.boot.IdeSharedJar;
import oracle.ide.boot.SharedDirectoryByPackage;
import oracle.ide.boot.SharedJarByPackage;
import oracle.ideimpl.boot.CachingSharedDirectory;

final class IdeSharedCodeSourceFactory
extends SharedCodeSourceFactory {
    private static final boolean LIMIT_JAR_HANDLES;

    IdeSharedCodeSourceFactory() {
    }

    @Override
    protected SharedCodeSource createCodeSource(URL location, File existingCanonicalFile) throws IOException {
        if (existingCanonicalFile != null) {
            if (!existingCanonicalFile.exists()) {
                throw new IOException("File does not exist: " + location);
            }
            if (existingCanonicalFile.isFile()) {
                return LIMIT_JAR_HANDLES ? new IdeSharedJar(existingCanonicalFile, location) : new SharedJarByPackage(existingCanonicalFile, location);
            }
            if (existingCanonicalFile.isDirectory()) {
                File packagesTxt = new File(existingCanonicalFile, "packages.txt");
                if (packagesTxt.isFile()) {
                    return new SharedDirectoryByPackage(existingCanonicalFile, location);
                }
                return new CachingSharedDirectory(existingCanonicalFile, location);
            }
        }
        return null;
    }

    static {
        String property = System.getProperty("ide.limit.jar.handles");
        LIMIT_JAR_HANDLES = property == null || Boolean.parseBoolean(property);
    }
}

