/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSourceFactory;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.InitialLoadersConfiguration;
import oracle.classloader.util.InitialLoadersFactory;
import oracle.classloader.util.MainClass;
import oracle.classloader.util.XMLConfiguration;
import oracle.ide.boot.IdeSharedCodeSourceFactory;
import oracle.ide.boot.Launcher;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;

public class IdeLauncher {
    public static void main(String[] args) {
        IdeLauncher launcher = new IdeLauncher();
        launcher.launch(args);
    }

    public final void launch(String[] args) {
        try {
            this.launchImpl(args);
        }
        catch (Throwable t) {
            System.err.println("IDE boot startup failed.");
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected void launchImpl(String[] args) throws Exception {
        this.initSystemProperties();
        this.initURLStreamHandlerFactory();
        this.initPackagesTxtOptimization();
        this.bootClassLoadersAndMain(args);
    }

    protected void initSystemProperties() {
        Properties systemProperties = System.getProperties();
        if (systemProperties.getProperty("ide.product") == null) {
            System.out.println("*****");
            System.out.println("***** WARNING: The ide.product is not specified.  This is likely to result in a failed startup.");
            System.out.println("*****");
        }
        if (!systemProperties.containsKey("class.load.environment")) {
            systemProperties.setProperty("class.load.environment", "oracle.ide.boot.IdeClassLoadEnvironment");
        }
        System.setProperty("class.transfer", "delegate");
        if (!systemProperties.containsKey("java.library.path")) {
            String path = System.getenv("PATH");
            systemProperties.setProperty("java.library.path", path);
        }
    }

    protected void initURLStreamHandlerFactory() {
        URLStreamHandlerFactoryQueue.addHandler("code-source", SharedCodeSourceURL.HANDLER);
    }

    protected void initPackagesTxtOptimization() {
        SharedCodeSourceFactory.register("file", new IdeSharedCodeSourceFactory());
    }

    protected void bootClassLoadersAndMain(String[] args) throws Exception {
        InitialLoadersConfiguration config = this.getLoaderConfig(args);
        InitialLoadersFactory.configureMainAsSystemLoader();
        MainClass main = InitialLoadersFactory.create(config);
        main.invoke();
    }

    protected InitialLoadersConfiguration getLoaderConfig(String[] args) throws Exception {
        InputStream bootXml = Launcher.class.getClassLoader().getResourceAsStream("META-INF/ide-boot.xml");
        XMLConfiguration config = new XMLConfiguration(args, bootXml, new File("."), "META-INF/ide-boot.xml in ide-boot.jar", true, new Class[0], new String[0]){

            @Override
            public String getApiExtensionProperty() {
                String apiExtDirs = super.getApiExtensionProperty();
                return apiExtDirs != null ? apiExtDirs : ClassLoadEnvironment.getDefaultApiExtensionKey();
            }

            @Override
            public String getDefaultApiExtensionDirectory() {
                String libApiExt = super.getDefaultApiExtensionDirectory();
                return libApiExt != null ? libApiExt : ClassLoadEnvironment.getDefaultApiExtensionDirectory();
            }

            @Override
            public MainClass configureLoaders() throws Exception {
                MainClass mainClass = super.configureLoaders();
                PolicyClassLoader mainLoader = mainClass.getLoader();
                this.setSharedAndNoAutoCommit(mainLoader);
                return mainClass;
            }

            private void setSharedAndNoAutoCommit(PolicyClassLoader pcl) {
                ConfigurationPolicy origConfigPolicy = pcl.getConfigurationPolicy();
                ConfigurationPolicy newConfigPolicy = new ConfigurationPolicy(origConfigPolicy.getTypes(), 1, origConfigPolicy.shouldInheritImports(), 1, true, origConfigPolicy.getCategory());
                pcl.resetConfiguration(pcl.getName(), pcl.getVersionNumber(), newConfigPolicy);
            }
        };
        return config;
    }

    private static boolean isDebugBuild() {
        return Boolean.getBoolean("ide.debugbuild");
    }
}

