/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.jdevimpl.audit.swing.CheckBoxTreeCellEditor;
import oracle.jdevimpl.audit.swing.CheckBoxTreeCellRenderer;
import oracle.jdevimpl.audit.swing.CheckBoxTreeModel;

public class CheckBoxTree
extends JTree
implements FocusListener {
    private Dimension preferredScrollableViewportSize;

    public CheckBoxTree(CheckBoxTreeModel model) {
        this(model, new DefaultTreeCellRenderer(), new DefaultTreeCellRenderer());
    }

    public CheckBoxTree(CheckBoxTreeModel model, TreeCellRenderer renderer, TreeCellRenderer editorRenderer) {
        super(model);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new CheckBoxTreeCellRenderer(renderer));
        this.setCellEditor(new CheckBoxTreeCellEditor(new CheckBoxTreeCellRenderer(editorRenderer)));
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
        this.addFocusListener(this);
    }

    public void setPreferredScrollableViewportSize(Dimension size) {
        this.preferredScrollableViewportSize = size;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.preferredScrollableViewportSize != null) {
            return this.preferredScrollableViewportSize;
        }
        return super.getPreferredScrollableViewportSize();
    }

    public void toggleRow(int row) {
        if (this.isCollapsed(row)) {
            this.expandRow(row);
        } else {
            this.collapseRow(row);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAll() {
        int i = this.getRowCount();
        while (i-- > 0) {
            this.collapseRow(i);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            if (!this.isEditing()) {
                TreePath path = this.getSelectionPath();
                if (path == null) {
                    super.processKeyEvent(e);
                    return;
                }
                this.startEditingAtPath(path);
            }
            if (this.isEditing()) {
                ((CheckBoxTreeCellEditor)this.getCellEditor()).forwardKeyEvent(e);
            }
        } else if (e.getKeyCode() == 27) {
            if (this.isEditing()) {
                ((CheckBoxTreeCellEditor)this.getCellEditor()).forwardKeyEvent(e);
            } else {
                super.processKeyEvent(e);
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    public void controlActionPerformed(TreePath path) {
        if (path.getPathCount() > 1) {
            CheckBoxTreeModel model = (CheckBoxTreeModel)this.getModel();
            Object target = path.getLastPathComponent();
            Boolean value = model.getState(target);
            assert (value != null);
            if (value == null) {
                return;
            }
            TreePath parentPath = path.getParentPath();
            Object parent = parentPath.getLastPathComponent();
            int count = model.getChildCount(parent);
            for (int i = 0; i < count; ++i) {
                Object child = model.getChild(parent, i);
                if (child == target || value.equals(model.getState(child))) continue;
                TreePath childPath = parentPath.pathByAddingChild(child);
                model.stateForPathChanged(childPath, value);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getLeadSelectionRow() < 0) {
            this.setSelectionInterval(0, 0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

