/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.report.XMLProfileReporter;
import oracle.jdevimpl.audit.report.XSLTAuditReporter;

public class XSLTProfileReporter
extends XSLTAuditReporter {
    private static final Logger LOG = Logger.getLogger(XSLTProfileReporter.class.getName());

    @Override
    public void report(Profile profile) throws InvocationTargetException {
        URL temporary;
        try {
            temporary = URLFileSystem.createTempFile((String)"audit", (String)".tmp", null);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
        XMLProfileReporter reporter = new XMLProfileReporter();
        reporter.setTitle(this.title);
        reporter.setFile(temporary);
        reporter.setEncoding(this.encoding);
        reporter.report(profile);
        BufferedInputStream input = null;
        OutputStream output = null;
        InputStream transform = null;
        try {
            input = new BufferedInputStream(URLFileSystem.openInputStream((URL)temporary));
            transform = new BufferedInputStream(URLFileSystem.openInputStream((URL)this.stylesheet.getUrl()));
            output = this.file != null ? new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.file)) : new BufferedOutputStream(new XSLTAuditReporter.StandardOutputStream());
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource xsl = new StreamSource(transform);
            Transformer transformer = factory.newTransformer(xsl);
            transformer.setErrorListener(new XSLTAuditReporter.ThrowingErrorListener());
            StreamSource source = new StreamSource(input);
            source.setSystemId(temporary.toString());
            StreamResult result = new StreamResult(output);
            if (this.file != null) {
                result.setSystemId(this.file.toString());
            }
            transformer.setOutputProperty("encoding", this.encoding);
            transformer.setParameter("newline", XSLTProfileReporter.getLineBreakSequence());
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            LOG.severe("unexpected exception creating report " + this.file + ": " + e);
            throw new InvocationTargetException(e);
        }
        finally {
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                if (transform != null) {
                    transform.close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            URLFileSystem.delete((URL)temporary);
            Node node = NodeFactory.find((URL)this.file);
            if (node != null) {
                try {
                    node.revert();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }
}

