/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Logger;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.audit.analyzer.Assist;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.report.XMLAuditReporter;

public class XMLProfileReporter
extends XMLAuditReporter {
    private Profile profile;
    private Profile.Instances instances;
    private static final Logger LOG = Logger.getLogger(XMLProfileReporter.class.getName());
    private static final String DOCUMENT_ROOT = "profile-report";

    @Override
    public void report(Profile profile) throws InvocationTargetException {
        LOG.info("reporting - " + profile);
        this.profile = profile;
        try {
            LOG.info("creating output stream - " + this.file);
            BufferedOutputStream output = this.file == null ? new BufferedOutputStream(new XMLAuditReporter.StandardOutputStream()) : new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.file));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)output, this.encoding)));
            this.lineBreakSequence = XMLProfileReporter.getLineBreakSequence();
            this.writeLine("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>");
            this.newline();
            this.instances = profile.createInstances();
            this.writeBeginTag(DOCUMENT_ROOT, new String[]{"xmlns", "http://xmlns.oracle.com/jdeveloper/1013/audit"}, false, true);
            this.writeTextElement("title", this.title);
            this.writeProfile();
            this.writeRules();
            this.writeAssists();
            this.writeMetrics();
            this.writeEndTag(DOCUMENT_ROOT);
        }
        catch (Throwable e) {
            LOG.severe("unexpected exception creating report  - " + this.file + " : " + e);
            LOG.severe(e.getMessage());
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        Node node = NodeFactory.find((URL)this.file);
        if (node != null) {
            try {
                node.revert();
            }
            catch (IOException e) {
                LOG.severe("unexpected exception reverting report " + this.file + ": " + e);
                LOG.severe(e.getMessage());
                e.printStackTrace();
                throw new InvocationTargetException(e);
            }
        }
    }

    private void writeProfile() {
        this.writeBeginTag("profile");
        this.writeTextElement("default", this.profile.isDefault());
        this.writeTextElement("name", this.profile.getName());
        this.writeTextElement("key", this.profile.getKey());
        this.writeTextElement("url", this.profile.getURL());
        this.writeEndTag("profile");
    }

    public void writeRules() {
        this.writeBeginTag("rules");
        for (ExtensionBean bean : this.instances.getBeans()) {
            Rule rule;
            if (!(bean instanceof Rule) || bean instanceof Assist || !(rule = (Rule)bean).isEnabled()) continue;
            this.writeRule(rule);
        }
        this.writeEndTag("rules");
    }

    public void writeAssist(Assist a) {
        this.writeBeginTag("assist", new String[]{"id", a.id(), "enabled", Boolean.toString(a.isEnabled())}, false, true);
        this.writeBaseExtensionBean(a);
        this.writeEndTag("assist");
    }

    public void writeRule(Rule r) {
        this.writeBeginTag("rule", new String[]{"id", r.id(), "enabled", Boolean.toString(r.isEnabled())}, false, true);
        this.writeBaseExtensionBean(r);
        this.writeEndTag("rule");
    }

    public void writeBaseExtensionBean(Rule r) {
        this.writeExtensionBean(r);
        this.writeTextElement("severity", r.getSeverity());
        this.writeTextElement("style", r.getStyle());
        if (r.getDefaultTransform() != null) {
            this.writeBeginTag("defaultTransform");
            this.writeTransform(r.getDefaultTransform());
            this.writeEndTag("defaultTransform");
        }
        if (r.parameters() != null && r.parameters().length > 0) {
            this.writeParameters(r.parameters());
        }
        this.writeCategory(r.category());
        if (r.getTransforms() != null && r.getTransforms().length > 0) {
            this.writeTransforms(r.getTransforms());
        }
    }

    public void writeParameters(Rule.Parameter[] params) {
        this.writeBeginTag("rule-params");
        for (Rule.Parameter p : params) {
            this.writeBeginTag("rule-param");
            this.writeTextElement("param-name", p.getName());
            this.writeTextElement("param-type", p.getType());
            this.writeTextElement("param-required", p.isRequired());
            this.writeEndTag("rule-param");
        }
        this.writeEndTag("rule-params");
    }

    public void writeCategory(Category c) {
        this.writeTextElement("category", c.labelOrId());
    }

    public void writeTransforms(Transform[] transforms) {
        this.writeBeginTag("transforms");
        for (Transform t : transforms) {
            this.writeTransform(t);
        }
        this.writeEndTag("transforms");
    }

    public void writeExtensionBean(ExtensionBean eb) {
        this.writeTextElement("name", eb.labelOrId());
        this.writeTextElement("description", eb.description());
        this.writeTextElement("tip", eb.tip());
    }

    public void writeMetric(Metric m) {
        this.writeBeginTag("metric");
        this.writeExtensionBean(m);
        this.writeTextElement("threshhold", m.getThreshold());
        this.writeTextElement("type", m.getType());
        this.writeCategory(m.getCategory());
        this.writeEndTag("metric");
    }

    private void writeAssists() {
        this.writeBeginTag("assists");
        for (ExtensionBean bean : this.instances.getBeans()) {
            Assist assist;
            if (!(bean instanceof Assist) || !(assist = (Assist)bean).isEnabled()) continue;
            this.writeAssist(assist);
        }
        this.writeEndTag("assists");
    }

    private void writeMetrics() {
        this.writeBeginTag("metrics");
        for (ExtensionBean bean : this.instances.getBeans()) {
            Metric metric;
            if (!(bean instanceof Metric) || !(metric = (Metric)bean).isEnabled()) continue;
            this.writeMetric(metric);
        }
        this.writeEndTag("metrics");
    }

    private void writeTransform(Transform t) {
        if (t.isEnabled()) {
            this.writeBeginTag("transform", new String[]{"id", t.id(), "enabled", "true"}, false, true);
        } else {
            this.writeBeginTag("transform", new String[]{"id", t.id(), "enabled", "false"}, false, true);
        }
        this.writeTextElement("name", t.labelOrId());
        this.writeTextElement("description", t.description());
        if (t.condition() != null) {
            this.writeTextElement("condition", t.condition().getText());
        }
        this.writeEndTag("transform");
    }
}

