/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StyleSheet {
    private final URL url;
    private static final Log LOG = new Log("stylesheet");

    public StyleSheet(URL url) {
        this.url = url;
    }

    public String getName() {
        return URLFileSystem.getName((URL)this.url);
    }

    public String getOutputSuffix() {
        return new SuffixScanner(this.url).getSuffix();
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    private static class SuffixScanner
    extends DefaultHandler {
        private String suffix = ".txt";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SuffixScanner(URL url) {
            InputStream stream = null;
            try {
                SAXParser parser = new SAXParser();
                parser.setPreserveWhitespace(false);
                parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
                parser.setPreserveWhitespace(false);
                parser.setContentHandler((ContentHandler)this);
                stream = URLFileSystem.openInputStream((URL)url);
                parser.parse(stream);
            }
            catch (SAXException e) {
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {}
            }
        }

        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            LOG.trace("starting element {0}, {1}, {2}", (Object)localName, (Object)qualifiedName, (Object)attributes);
            if ("xsl:output".equals(qualifiedName)) {
                String method = attributes.getValue("", "method");
                this.suffix = "text".equals(method) ? ".txt" : ("html".equals(method) ? ".html" : ".xml");
                throw new SAXException("done");
            }
        }
    }
}

