/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import oracle.jdevimpl.audit.report.XMLAuditReporter;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AuditValidator {
    public static void main(String[] arguments) throws Exception {
        DOMParser parser = new DOMParser();
        parser.parseDTD(XMLAuditReporter.class.getResource("audit.dtd"), "audit");
        DTD dtd = parser.getDoctype();
        EntityAndErrorHandler handler = new EntityAndErrorHandler();
        parser.setEntityResolver((EntityResolver)handler);
        parser.setErrorHandler((ErrorHandler)handler);
        parser.showWarnings(true);
        parser.setPreserveWhitespace(false);
        parser.setDebugMode(true);
        parser.setErrorStream((OutputStream)System.err);
        System.out.println("starting DTD validation");
        parser.setValidationMode(2);
        parser.setDoctype(dtd);
        BufferedReader reader = new BufferedReader(new FileReader(arguments[0]));
        parser.parse((Reader)reader);
        ((Reader)reader).close();
        System.out.println("starting schema validation");
        parser.setDoctype(new DTD());
        parser.setXMLSchema((Object)AuditValidator.getSchema());
        parser.setValidationMode(3);
        reader = new BufferedReader(new FileReader(arguments[0]));
        parser.parse((Reader)reader);
        ((Reader)reader).close();
    }

    private static XMLSchema getSchema() throws Exception {
        XSDBuilder builder = new XSDBuilder();
        URL schemaURL = XMLAuditReporter.class.getResource("audit.xsd");
        return builder.build(schemaURL);
    }

    private static class EntityAndErrorHandler
    implements EntityResolver,
    ErrorHandler {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException {
            System.out.println("resolving public " + publicId + ", system " + systemId);
            return null;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.err.println(exception.getLocalizedMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.err.println(exception.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.err.println(exception.getLocalizedMessage());
            throw exception;
        }
    }
}

