/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreePath;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.bean.BeanPanel;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.profile.ProfileTreeModel;
import oracle.jdevimpl.audit.swing.CheckBoxTree;
import oracle.jdevimpl.audit.swing.FocusBorder;
import oracle.jdevimpl.audit.swing.HtmlTreeCellRenderer;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.swing.NullablePanel;

class AuditProfileSubpanel
implements TreeSelectionListener {
    private String reservedMnemonics;
    private int width;
    private CheckBoxTree tree;
    private BeanPanel inspector;
    private NullablePanel inspectorPanel;
    private JEditorPane textArea;
    private NullablePanel textAreaPanel;
    private JComponent component;
    private ProfileTreeModel model;
    private static final Log LOG = new Log("profile");
    private static final Rectangle RECTANGLE_TOP_LEFT = new Rectangle(16, 16);
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);

    public AuditProfileSubpanel(ProfileModel model, Class type, String reservedMnemonics, int width) {
        this.width = width;
        this.reservedMnemonics = reservedMnemonics;
        this.model = new ProfileTreeModel(model, type);
    }

    public void setProfile(Profile profile) {
        LOG.trace("setting profile {0} on subpanel", (Object)profile);
        if (this.tree != null) {
            this.tree.repaint();
            TreePath path = this.tree.getSelectionPath();
            Object selection = path != null ? path.getLastPathComponent() : null;
            this.processSelection(selection);
        }
    }

    public Object getSelectionState() {
        return null;
    }

    public void setSelectionState(Object state) {
    }

    public boolean flush() {
        return this.inspector.flush();
    }

    public Component getFocusComponent() {
        return this.tree;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
        return this.component;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        Object newSelection = path != null ? path.getLastPathComponent() : null;
        LOG.trace("tree selection changed to {0}", newSelection);
        this.processSelection(newSelection);
    }

    private void processSelection(Object newSelection) {
        LOG.trace("changing tree selection to {0}", newSelection);
        if (newSelection != null) {
            ExtensionBean bean = this.model.getBean(newSelection);
            this.inspector.setBean(bean);
            if (bean != null) {
                this.inspectorPanel.showContent();
            } else {
                this.inspectorPanel.hideContent();
            }
            String text = this.model.getDescription(newSelection);
            this.textArea.setText(text);
            this.textAreaPanel.showContent();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AuditProfileSubpanel.this.textArea.scrollRectToVisible(RECTANGLE_TOP_LEFT);
                }
            });
        } else {
            this.textArea.setText(" ");
            this.textAreaPanel.hideContent();
            this.inspector.setBean(null);
            this.inspectorPanel.hideContent();
        }
    }

    private JComponent createComponent() {
        StringBuffer reservedMnemonics = new StringBuffer(this.reservedMnemonics);
        this.tree = new CheckBoxTree(this.model, new HtmlTreeCellRenderer(), new HtmlTreeCellRenderer());
        JScrollPane treeScrollPane = new JScrollPane(this.tree, 20, 31);
        NullablePanel treePanel = new NullablePanel(null, null, null, treeScrollPane);
        this.inspector = new BeanPanel(AuditManager.getAuditManager().getBeanCustomizers());
        this.inspector.setMnemonicAssignmentEnabled(true);
        JScrollPane inspectorScrollPane = new JScrollPane(this.inspector, 20, 31);
        this.inspectorPanel = new NullablePanel(null, null, BUNDLE.get("profile.audit.null.inspector.label"), inspectorScrollPane);
        this.textArea = new JEditorPane("text/html", "");
        this.textArea.setEditable(false);
        Font font = this.textArea.getFont();
        StyleSheet stylesheet = ((HTMLDocument)this.textArea.getDocument()).getStyleSheet();
        stylesheet.addRule("body {font-size: " + font.getSize() + "pt;" + "font-family: " + font.getFamily() + ";" + "font-weight: " + (font.isBold() ? "bold" : "normal") + ";" + "font-style: " + (font.isItalic() ? "italic" : "normal") + ";" + "color: #" + Integer.toHexString(this.textArea.getForeground().getRGB() & 0xFFFFFF) + "}");
        this.textArea.addFocusListener(new UneditableTextComponentFocusListener());
        this.textArea.addHyperlinkListener(new DescriptionHyperlinkListener());
        JScrollPane textAreaScrollPane = new JScrollPane(this.textArea, 20, 31);
        textAreaScrollPane.setViewportBorder(new FocusBorder(1, 1, (Component)this.textArea));
        textAreaScrollPane.setBackground(this.textArea.getBackground());
        String mnemonicString = BUNDLE.get("profile.audit.description.mnemonic");
        char descriptionMnemonic = mnemonicString.charAt(0);
        reservedMnemonics.append(descriptionMnemonic);
        this.textAreaPanel = new NullablePanel(BUNDLE.get("profile.audit.description.label"), mnemonicString, BUNDLE.get("profile.audit.null.description.label"), textAreaScrollPane);
        this.inspector.setReservedMnemonics(reservedMnemonics.toString());
        int height = this.width / 8;
        treePanel.setMargin(0, 0, 3, 3);
        DockLayoutPanel compositePanel = new DockLayoutPanel();
        compositePanel.add((Component)treePanel, (Object)new DockLayoutConstraint(0, new Dimension(this.width / 3, 3 * height)));
        this.inspectorPanel.setMargin(0, 3, 3, 0);
        compositePanel.add((Component)this.inspectorPanel, (Object)new DockLayoutConstraint((Component)treePanel, 1, 1, new Dimension(2 * this.width / 3, 3 * height)));
        this.textAreaPanel.setMargin(3, 0, 0, 0);
        compositePanel.add((Component)this.textAreaPanel, (Object)new DockLayoutConstraint((Component)treePanel, 3, 2, new Dimension(this.width + 10, height)));
        this.tree.addTreeSelectionListener(this);
        return compositePanel;
    }

    public static class DescriptionHyperlinkListener
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                try {
                    BrowserRunner.getBrowserRunner().runBrowserOnURLV2(e.getURL(), null, writer);
                }
                catch (Exception e1) {
                    MessageDialog dialog = new MessageDialog(MessageDialog.Type.ERROR);
                    dialog.setTitle(BUNDLE.get("profile.audit.hyperlink.exception.title"));
                    dialog.setContent(BUNDLE.get("profile.audit.hyperlink.exception.content", new Object[]{buffer.toString()}));
                    dialog.show();
                }
            }
        }
    }

    public static class UneditableTextComponentFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            JTextComponent component = (JTextComponent)e.getSource();
            component.getCaret().setVisible(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTextComponent component = (JTextComponent)e.getSource();
            component.getCaret().setVisible(false);
        }
    }
}

