/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.IdeArb;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.analyzer.Assist;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.service.DefaultProfile;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.log.ProfileExportDialog;
import oracle.jdevimpl.audit.profile.AuditProfileSubpanel;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.swing.ComboBoxLabel;
import oracle.jdevimpl.audit.swing.DelegatingLayout;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Cache;
import oracle.jdevimpl.audit.util.Strings;

public class AuditProfilePanel
implements ActionListener,
ApplyListener,
ChangeListener,
ListDataListener,
Traversable {
    private boolean allowsManagement = true;
    private JComponent component;
    private JButton saveButton;
    private JButton deleteButton;
    private JButton exportButton;
    private JButton importButton;
    private JButton resetButton;
    private JButton prettyPrintProfileButton;
    private JTabbedPane tabbedPane;
    private AuditProfileSubpanel[] subpanels = new AuditProfileSubpanel[3];
    private StringBuffer reservedMnemonics = new StringBuffer();
    private int subpanelWidth;
    private ProfileModel model;
    private static final String IMPORT_EXPORT_DIRECTORY_KEY = "audit.profile.importexport.directory";
    private static String lastSelectedProfile;
    private static int lastSelectedSubpanel;
    private static Object lastSelectedSubpanelState;
    private static final Log LOG;
    private static final FormatBundle bundle;
    private static Class[] PROFILEABLE_TYPES;

    public AuditProfilePanel(ProfileModel model) {
        this.model = model;
    }

    public boolean isAllowsManagement() {
        return this.allowsManagement;
    }

    public void setAllowsManagement(boolean allowsManagement) {
        if (this.component != null) {
            throw new IllegalStateException("component != null");
        }
        this.allowsManagement = allowsManagement;
    }

    public Profile show(Component parent) {
        this.setAllowsManagement(false);
        JComponent component = (JComponent)this.getComponent();
        final DialogFactory dialog = new DialogFactory();
        dialog.setTitle(bundle.get("profile.audit.title"));
        dialog.setContent(component);
        dialog.setHelpTopic(bundle.get("profile.audit.help"));
        dialog.setInitialFocus(this.getSelectedSubpanel(null).getFocusComponent());
        JButton okButton = dialog.addOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AuditProfilePanel.this.getSelectedSubpanel(null).flush()) {
                    dialog.hide();
                }
            }
        });
        dialog.addCancelButton(null);
        dialog.setDefaultButton(okButton);
        JButton command = dialog.show(parent);
        Profile profile = null;
        if (okButton == command) {
            this.apply();
            profile = this.model.getSelectedItem();
        } else {
            this.cancel();
        }
        return profile;
    }

    public Profile show() {
        return this.show(null);
    }

    private AuditProfileSubpanel getSelectedSubpanel(Profile profile) {
        boolean creating;
        int index = this.tabbedPane.getSelectedIndex();
        AuditProfileSubpanel subpanel = this.subpanels[index];
        boolean bl = creating = subpanel == null;
        if (creating) {
            this.subpanels[index] = subpanel = new AuditProfileSubpanel(this.model, PROFILEABLE_TYPES[index], this.reservedMnemonics.toString(), this.subpanelWidth);
        }
        if (profile != null) {
            subpanel.setProfile(profile);
        }
        if (creating) {
            JPanel panel = (JPanel)this.tabbedPane.getSelectedComponent();
            panel.add(subpanel.getComponent());
        }
        return subpanel;
    }

    public void onEntry(TraversableContext context) {
        LOG.trace("handling traversable context entry, last profile {0}", (Object)lastSelectedProfile);
    }

    public void onExit(TraversableContext context) throws TraversalException {
        LOG.trace("handling traversable context exit");
        if (!this.getSelectedSubpanel(null).flush()) {
            throw new TraversalException(null);
        }
    }

    public void apply(ApplyEvent e) {
        this.saveSelection();
        LOG.trace("handling apply event");
        this.apply();
    }

    public void cancel(ApplyEvent e) {
        LOG.trace("handling cancel event");
        this.cancel();
    }

    public Object getExitTransition() {
        LOG.trace("handling exit transition");
        return null;
    }

    private void apply() {
        LOG.trace("applying changes");
        this.getSelectedSubpanel(null).flush();
        this.model.removeListDataListener(this);
        try {
            this.model.apply();
        }
        catch (IOException e) {
            Log.error((String)"exception applying profile changes: {1}", (Object)e);
            MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
            dialog.setTitle(bundle.get("profile.apply.ioexception.title"));
            dialog.setContent(bundle.get("profile.apply.ioexception.message", new Object[]{e}));
            dialog.show();
        }
    }

    private void cancel() {
        LOG.trace("cancelling changes");
        this.model.removeListDataListener(this);
        this.model.cancel();
    }

    protected Component createComponent() {
        JComponent selector;
        JPanel buttons = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 3;
        JLabel label = new JLabel(bundle.get("profile.selector.label"));
        char selectorMnemonic = bundle.get("profile.selector.mnemonic").charAt(0);
        this.reservedMnemonics.append(selectorMnemonic);
        buttons.add((Component)label, constraints);
        if (this.isAllowsManagement()) {
            JComboBox<Object> comboBox = new JComboBox<Object>(this.model);
            comboBox.setRenderer(new ProfileRenderer());
            comboBox.setPrototypeDisplayValue("01234567890123456789012345678901");
            selector = comboBox;
            label.setDisplayedMnemonic(selectorMnemonic);
        } else {
            ComboBoxLabel comboBoxLabel = new ComboBoxLabel(this.model);
            comboBoxLabel.setFocusable(true);
            comboBoxLabel.setRenderer(new ProfileRenderer());
            comboBoxLabel.setPrototypeDisplayValue("01234567890123456789012345678901");
            selector = comboBoxLabel;
        }
        label.setLabelFor(selector);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.insets.left = 12;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        buttons.add(selector, constraints);
        constraints.fill = 3;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        this.saveButton = new JButton(bundle.get("profile.saveas.label"));
        char saveMnemonic = bundle.get("profile.saveas.mnemonic").charAt(0);
        this.reservedMnemonics.append(saveMnemonic);
        this.saveButton.setMnemonic(saveMnemonic);
        constraints.gridx = 3;
        constraints.anchor = 13;
        buttons.add((Component)this.saveButton, constraints);
        char deleteMnemonic = bundle.get("profile.delete.mnemonic").charAt(0);
        this.reservedMnemonics.append(deleteMnemonic);
        char resetMnemonic = bundle.get("profile.reset.mnemonic").charAt(0);
        this.reservedMnemonics.append(resetMnemonic);
        char importMnemonic = bundle.get("profile.import.mnemonic").charAt(0);
        this.reservedMnemonics.append(importMnemonic);
        char exportMnemonic = bundle.get("profile.export.mnemonic").charAt(0);
        this.reservedMnemonics.append(exportMnemonic);
        char prettyPrintMnemonic = bundle.get("profile.pretty.print.mnemonic").charAt(0);
        this.reservedMnemonics.append(prettyPrintMnemonic);
        if (this.isAllowsManagement()) {
            this.deleteButton = new JButton(bundle.get("profile.delete.label"));
            this.deleteButton.setMnemonic(deleteMnemonic);
            constraints.gridx = 4;
            constraints.insets.left = 10;
            buttons.add((Component)this.deleteButton, constraints);
            this.resetButton = new JButton(bundle.get("profile.reset.label"));
            this.resetButton.setMnemonic(resetMnemonic);
            constraints.gridy = 1;
            constraints.gridx = 2;
            constraints.insets.left = 12;
            constraints.insets.top = 10;
            constraints.weightx = 1.0;
            buttons.add((Component)this.resetButton, constraints);
            constraints.weightx = 0.0;
            GridBagConstraints copyCon = (GridBagConstraints)constraints.clone();
            this.prettyPrintProfileButton = new JButton(bundle.get("profile.pretty.print.label"));
            this.prettyPrintProfileButton.setMnemonic(prettyPrintMnemonic);
            copyCon.gridx = 0;
            copyCon.gridwidth = 2;
            buttons.add((Component)this.prettyPrintProfileButton, copyCon);
            constraints.anchor = 10;
            this.importButton = new JButton(bundle.get("profile.import.label"));
            this.importButton.setMnemonic(importMnemonic);
            constraints.gridx = 3;
            constraints.insets.left = 10;
            buttons.add((Component)this.importButton, constraints);
            this.exportButton = new JButton(bundle.get("profile.export.label"));
            this.exportButton.setMnemonic(exportMnemonic);
            constraints.gridx = 4;
            buttons.add((Component)this.exportButton, constraints);
            Dimension buttonSize = this.saveButton.getPreferredSize();
            buttonSize.height = Math.max(buttonSize.height, label.getPreferredSize().height);
            buttonSize.height = Math.max(buttonSize.height, selector.getPreferredSize().height);
            buttonSize.height = Math.max(buttonSize.height, this.resetButton.getPreferredSize().height);
            this.maximize(buttonSize, this.deleteButton.getPreferredSize());
            this.maximize(buttonSize, this.importButton.getPreferredSize());
            this.maximize(buttonSize, this.exportButton.getPreferredSize());
            this.maximize(buttonSize, this.prettyPrintProfileButton.getPreferredSize());
            this.saveButton.setPreferredSize(buttonSize);
            this.deleteButton.setPreferredSize(buttonSize);
            this.importButton.setPreferredSize(buttonSize);
            this.exportButton.setPreferredSize(buttonSize);
            this.prettyPrintProfileButton.setPreferredSize(buttonSize);
            this.saveButton.setMinimumSize(buttonSize);
            this.deleteButton.setMinimumSize(buttonSize);
            this.importButton.setMinimumSize(buttonSize);
            this.exportButton.setMinimumSize(buttonSize);
            this.prettyPrintProfileButton.setMinimumSize(buttonSize);
            this.saveButton.setMaximumSize(buttonSize);
            this.deleteButton.setMaximumSize(buttonSize);
            this.importButton.setMaximumSize(buttonSize);
            this.exportButton.setMaximumSize(buttonSize);
            this.prettyPrintProfileButton.setMaximumSize(buttonSize);
        }
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.insets.top = 0;
        Component spacer = Box.createVerticalStrut(15);
        buttons.add(spacer, constraints);
        this.resetButtons();
        this.subpanelWidth = 3 * selector.getPreferredSize().width;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab(bundle.get("profile.rules.label"), new JPanel(new DelegatingLayout()));
        char rulesMnemonic = bundle.get("profile.rules.mnemonic").charAt(0);
        this.reservedMnemonics.append(rulesMnemonic);
        this.tabbedPane.setMnemonicAt(0, rulesMnemonic);
        this.tabbedPane.addTab(bundle.get("profile.assists.label"), new JPanel(new DelegatingLayout()));
        char assistsMnemonic = bundle.get("profile.assists.mnemonic").charAt(0);
        this.reservedMnemonics.append(assistsMnemonic);
        this.tabbedPane.setMnemonicAt(1, assistsMnemonic);
        this.tabbedPane.addTab(bundle.get("profile.metrics.label"), new JPanel(new DelegatingLayout()));
        char metricsMnemonic = bundle.get("profile.metrics.mnemonic").charAt(0);
        this.reservedMnemonics.append(metricsMnemonic);
        this.tabbedPane.setMnemonicAt(2, metricsMnemonic);
        this.tabbedPane.addChangeListener(this);
        this.reservedMnemonics.append(IdeArb.getMnemonic((int)418));
        JPanel component = new JPanel(new BorderLayout());
        component.add((Component)buttons, "North");
        component.add((Component)this.tabbedPane, "Center");
        this.saveButton.addActionListener(this);
        if (this.isAllowsManagement()) {
            this.deleteButton.addActionListener(this);
            this.resetButton.addActionListener(this);
            this.importButton.addActionListener(this);
            this.exportButton.addActionListener(this);
            this.prettyPrintProfileButton.addActionListener(this);
        }
        this.model.addListDataListener(this);
        this.restoreSelection();
        return component;
    }

    private void maximize(Dimension size, Dimension otherSize) {
        size.height = Math.max(size.height, otherSize.height);
        size.width = Math.max(size.width, otherSize.width);
    }

    private void resetButtons() {
        if (this.isAllowsManagement()) {
            Profile profile = this.model.getSelectedItem();
            boolean isDefault = profile != null && profile.isDefault();
            LOG.trace("resetting buttons on profile {1}, default {0}", isDefault, (Object)profile);
            this.deleteButton.setEnabled(profile != null && !isDefault && this.model.getSize() > 1);
            this.exportButton.setEnabled(profile != null);
            this.resetButton.setEnabled(profile != null && profile.isDefault());
            this.prettyPrintProfileButton.setEnabled(profile != null);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = (JComponent)this.createComponent();
        }
        return this.component;
    }

    public String getHelpID() {
        return bundle.get("preferences.audit.profiles.help");
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
        this.resetButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
        this.resetButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        Profile profile = this.model.getSelectedItem();
        if (event.getIndex0() == -1 || event.getIndex1() == -1) {
            LOG.trace("selected profile changed to {0}", (Object)profile);
            if (profile != null) {
                this.getSelectedSubpanel(profile);
            }
            this.resetButtons();
        }
        this.resetButtons();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Profile profile = this.model.getSelectedItem();
        if (event.getSource() instanceof JTabbedPane) {
            LOG.trace("tab changed {0}", (Object)event);
            this.getSelectedSubpanel(profile);
        }
        this.resetButtons();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.saveButton) {
            this.saveAs();
        } else if (source == this.deleteButton) {
            this.delete();
        } else if (source == this.resetButton) {
            this.restoreDefault();
        } else if (source == this.importButton) {
            this.importAs();
        } else if (source == this.exportButton) {
            this.export();
        } else if (source == this.prettyPrintProfileButton) {
            this.prettyPrintProfile();
        } else {
            Log.error((String)"unexpected action source in event {0}", (Object)event);
        }
    }

    private void saveAs() {
        Profile profile = this.model.getSelectedItem();
        String name = this.promptForNewName(profile.getName(), "profile.saveas");
        if (name == null) {
            return;
        }
        Profile overwrittenProfile = this.model.getProfile(name);
        if (!(overwrittenProfile == null || this.model.isNew(overwrittenProfile) || name.equals(profile.getName()) || this.confirmOverwrite(name, overwrittenProfile.getName()))) {
            return;
        }
        try {
            this.model.saveAs(name, overwrittenProfile);
        }
        catch (IOException e) {
            Log.error((String)"exception saving profile {0}: {1}", (Object)name, (Object)e);
            MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
            dialog.setTitle(bundle.get("profile.saveas.ioexception.title"));
            dialog.setContent(bundle.get("profile.saveas.ioexception.message", new Object[]{name, e}));
            dialog.show();
        }
    }

    private boolean confirmOverwrite(String name, String overwrittenName) {
        MessageDialog confirmDialog = new MessageDialog(MessageDialog.WARNING);
        confirmDialog.setTitle(bundle.get("profile.saveas.confirm.dialog.title"));
        String message = name.equals(overwrittenName) ? bundle.get("profile.saveas.confirm.dialog.message", new Object[]{name}) : bundle.get("profile.saveas.case.confirm.dialog.message", new Object[]{overwrittenName, name});
        confirmDialog.setContent(message);
        String okLabel = bundle.get("profile.saveas.confirm.dialog.ok.label");
        String cancelLabel = bundle.get("profile.saveas.confirm.dialog.cancel.label");
        confirmDialog.setCommands(okLabel, cancelLabel);
        return confirmDialog.show(null) == okLabel;
    }

    private String promptForNewName(String oldName, String prefix) {
        JTextField nameField = new JTextField(oldName, 32);
        nameField.selectAll();
        JLabel label = new JLabel(bundle.get(prefix + ".dialog.name.label"));
        label.setDisplayedMnemonic(bundle.get(prefix + ".dialog.name.mnemonic").charAt(0));
        label.setLabelFor(nameField);
        JPanel content = new JPanel(new GridBagLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.anchor = 17;
        content.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.insets.right = 0;
        content.add((Component)nameField, constraints);
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle(bundle.get(prefix + ".dialog.title"));
        dialog.setContent(content);
        dialog.setResizable(false);
        JButton okButton = dialog.addOkButton(new JButton(bundle.get(prefix + ".dialog.ok.label")));
        dialog.setDefaultButton(okButton);
        dialog.addCancelButton(null);
        new SaveAsListener(nameField.getDocument(), okButton);
        dialog.setHelpTopic(bundle.get(prefix + ".dialog.help"));
        JButton button = dialog.show(this.component);
        String name = button == okButton ? nameField.getText().trim() : null;
        return name;
    }

    private void delete() {
        this.model.remove();
    }

    private void restoreDefault() {
        this.model.restoreDefaults();
    }

    private void importAs() {
        LOG.trace("importing profile");
        URL directory = this.getDefaultImportExportDirectory();
        URLChooser chooser = DialogUtil.newURLChooser((URL)directory);
        DefaultURLFilter filter = new DefaultURLFilter(bundle.get("results.export.chooser.filter.xml.label"), ".xml");
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(bundle.get("results.export.chooser.filter.all.label")));
        chooser.setURLFilter((URLFilter)filter);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        int response = chooser.showOpenDialog(this.getComponent(), bundle.get("profile.import.dialog.title"));
        if (response != 0) {
            return;
        }
        URL url = chooser.getSelectedURL();
        Cache.put(IMPORT_EXPORT_DIRECTORY_KEY, URLFileSystem.getParent((URL)url));
        DefaultProfile.NameScanner scanner = new DefaultProfile.NameScanner(url);
        String name = this.promptForNewName(scanner.getName(), "profile.importas");
        if (name == null) {
            return;
        }
        Profile overwrittenProfile = this.model.getProfile(name);
        if (overwrittenProfile != null && !this.model.isNew(overwrittenProfile) && !this.confirmOverwrite(name, overwrittenProfile.getName())) {
            return;
        }
        try {
            this.model.importAs(url, name, overwrittenProfile);
        }
        catch (IOException e) {
            Log.error((String)"exception saving profile {0}: {1}", (Object)name, (Object)e);
            MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
            dialog.setTitle(bundle.get("profile.importas.ioexception.title"));
            dialog.setContent(bundle.get("profile.importas.ioexception.message", new Object[]{name, e}));
            dialog.show();
        }
    }

    private void export() {
        Profile profile = this.model.getSelectedItem();
        LOG.trace("exporting profile {0}", (Object)profile);
        if (profile == null) {
            return;
        }
        URL directory = this.getDefaultImportExportDirectory();
        String name = ProfileRepository.sanitizeFileName(profile.getName());
        URL url = URLFactory.newURL((URL)directory, (String)name);
        URLChooser chooser = DialogUtil.newURLChooser((URL)url);
        DefaultURLFilter filter = new DefaultURLFilter(bundle.get("results.export.chooser.filter.xml.label"), ".xml");
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(bundle.get("results.export.chooser.filter.all.label")));
        chooser.setURLFilter((URLFilter)filter);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        int response = chooser.showSaveDialog(this.getComponent(), bundle.get("profile.export.dialog.title"));
        if (response == 0) {
            url = chooser.getSelectedURL();
            if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".xml");
            }
            Cache.put(IMPORT_EXPORT_DIRECTORY_KEY, URLFileSystem.getParent((URL)url));
            try {
                this.model.exportAs(url, profile.getName());
            }
            catch (IOException e) {
                Log.error((String)"exception exporting \"{0}\": {1}", (Object)name, (Object)e.getCause());
                MessageDialog message = new MessageDialog(MessageDialog.ERROR);
                message.setTitle(bundle.get("profile.export.ioexception.title"));
                String content = Strings.toString(bundle.get("profile.export.ioexception.message"), new Object[]{URLFileSystem.getPlatformPathName((URL)url), e});
                message.setContent(content);
                message.show();
            }
        }
    }

    private void prettyPrintProfile() {
        Profile profile = this.model.getSelectedItem();
        LOG.trace("saving pretty print profile {0}", (Object)profile);
        if (profile == null) {
            return;
        }
        new ProfileExportDialog(profile, profile.getName()).show();
    }

    private URL getDefaultImportExportDirectory() {
        URL directory = (URL)Cache.get(IMPORT_EXPORT_DIRECTORY_KEY);
        if (directory == null || !URLFileSystem.exists((URL)directory)) {
            directory = URLFactory.newDirURL((String)System.getProperty("user.home"));
        }
        return directory;
    }

    private void saveSelection() {
        lastSelectedProfile = this.model.getSelectedItem().getName();
        lastSelectedSubpanel = this.tabbedPane.getSelectedIndex();
        lastSelectedSubpanelState = this.getSelectedSubpanel(null).getSelectionState();
    }

    private void restoreSelection() {
        Profile selection = this.model.getSelectedItem();
        if (selection == null) {
            selection = this.model.getProfile(lastSelectedProfile, "code-assist-rules");
        } else {
            this.model.setSelectedItem(null);
        }
        this.model.setSelectedItem(selection);
        this.tabbedPane.setSelectedIndex(lastSelectedSubpanel);
        this.getSelectedSubpanel(null).setSelectionState(lastSelectedSubpanelState);
    }

    static {
        LOG = new Log("profilepanel");
        bundle = new FormatBundle(AuditBundle.class);
        PROFILEABLE_TYPES = new Class[]{Rule.class, Assist.class, Metric.class};
    }

    private class SaveAsListener
    implements DocumentListener {
        private Document document;
        private JButton button;

        public SaveAsListener(Document document, JButton ok) {
            this.document = document;
            this.button = ok;
            document.addDocumentListener(this);
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String text;
            try {
                text = this.document.getText(0, this.document.getLength()).trim();
            }
            catch (BadLocationException e1) {
                throw new UnexpectedExceptionError((Throwable)e1);
            }
            this.button.setEnabled(text.length() != 0);
        }
    }

    private static class ProfileRenderer
    extends DefaultListCellRenderer {
        private ProfileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ProfileModel model = (ProfileModel)list.getModel();
            if (value instanceof Profile) {
                Profile profile = (Profile)value;
                String key = "profile.selector.renderer.unmodified.label";
                if (model.isModified(profile)) {
                    key = "profile.selector.renderer.modified.label";
                }
                value = bundle.get(key, new Object[]{profile.getName()});
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

