/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.preferences;

import java.util.Collection;
import java.util.LinkedList;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.ProvidesSearchTags;
import oracle.ide.panels.Traversable;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.preferences.AuditPreferencesPanel;
import oracle.jdevimpl.audit.profile.AuditProfilePanel;
import oracle.jdevimpl.audit.profile.ProfileModel;

public class AuditPreferencesNode
extends Navigable
implements ProvidesSearchTags {
    private ProfileModel profiles;
    private AuditPreferencesNode parent;
    private Navigable[] children;
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);
    private static final Log LOG = new Log("preferences");

    public AuditPreferencesNode() {
        super(bundle.get("preferences.audit.node.label"));
        LOG.trace("created root preferences node {0}", (Object)this);
    }

    public AuditPreferencesNode(AuditPreferencesNode parent) {
        super(bundle.get("preferences.audit.profiles.node.label"));
        this.parent = parent;
        LOG.trace("created child preferences node {0}", (Object)this);
    }

    protected Traversable newTraversable() {
        if (this.parent == null) {
            LOG.trace("creating new root traversable");
            return new AuditPreferencesPanel(this.getProfiles());
        }
        LOG.trace("creating new profile traversable");
        return new AuditProfilePanel(this.getProfiles());
    }

    protected Navigable[] getChildNavigables() {
        if (this.children == null) {
            this.children = this.createChildren();
        }
        return this.children;
    }

    protected Navigable[] createChildren() {
        if (this.parent == null) {
            return new Navigable[]{new AuditPreferencesNode(this)};
        }
        return new Navigable[0];
    }

    private ProfileModel getProfiles() {
        if (this.profiles == null) {
            this.profiles = this.parent == null ? new ProfileModel(ProfileRepository.getRepository()) : this.parent.getProfiles();
        }
        return this.profiles;
    }

    public Collection<String> searchTags() {
        LinkedList<String> tags = new LinkedList<String>();
        tags.add(bundle.get("preferences.audit.search.tags.rules"));
        tags.add(bundle.get("preferences.audit.search.tags.code.assist"));
        tags.add(bundle.get("preferences.audit.search.tags.metrics"));
        tags.add(bundle.get("preferences.audit.search.tags.audit"));
        tags.add(bundle.get("preferences.audit.search.tags.profiles"));
        return tags;
    }
}

