/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentCache;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public class WorkspaceModelAdapter
extends ContainerModelAdapter {
    private final Workspace workspace;

    public WorkspaceModelAdapter(ModelFactory factory, ModelType type, Workspace workspace) {
        super(factory, type, workspace);
        this.workspace = workspace;
    }

    @Override
    public ContainerModelAdapter getContainingAdapter() {
        return (ContainerModelAdapter)this.getFactory().getModelRoot().getModel();
    }

    @Override
    public URL getUrl() {
        return this.workspace.getURL();
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public Project getProject() {
        return null;
    }

    @Override
    public ContentDirectory getDirectory() {
        return null;
    }

    @Override
    public Object getRoot() {
        return this.workspace;
    }

    @Override
    public Location[] getElementLocations(Element element) {
        if (this.getWorkspace().equals((Object)element)) {
            return new Location[]{this.getLocation()};
        }
        return null;
    }

    @Override
    public Location getLocation(Object construct) {
        if (construct == this.getWorkspace()) {
            return this.getLocation();
        }
        return null;
    }

    @Override
    public Object getConstruct(Location location) {
        if (!this.equals(location.getModel())) {
            return null;
        }
        return this.getWorkspace();
    }

    @Override
    protected void createContainedModels(Object construct) {
        Workspace workspace = this.getWorkspace();
        assert (workspace.equals(construct));
        ContentCache cache = this.getFactory().getContentSetCache(null, this.getWorkspace());
        Collection<ContentDirectory> roots = cache.getRootDirectories();
        for (ContentDirectory directory : roots) {
            Collection<ModelAdapter> models = this.getFactory().getContainedModelAdapters(directory, directory.getURL(), this);
            this.addContainedModels(models);
        }
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        Iterator i = workspace.getChildren();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (workingSet != null && (!(node instanceof Project) || !workingSet.isIncluded((Project)node))) continue;
            Collection<ModelAdapter> models = this.getFactory().getContainedModelAdapters((Element)node, null, this);
            this.addContainedModels(models);
        }
    }

    @Override
    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        ModelAdapter model = (ModelAdapter)object;
        assert (this.getFactory() == model.getFactory()) : "generation mismatch: " + this + " - " + model;
        int comparison = WorkspaceModelAdapter.compareSiblings(this, model.getWorkspaceAdapter());
        if (comparison == 0) {
            comparison = -1;
        }
        return comparison;
    }

    @Override
    public boolean contains(ModelAdapter that) {
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        ContainerModelAdapter thatWorkspace = that.getWorkspaceAdapter();
        return this == thatWorkspace;
    }

    @Override
    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this.getWorkspace().equals(construct));
        assert (this == location.getModel());
        return true;
    }

    @Override
    public Node getNode() {
        return this.workspace;
    }

    @Override
    public boolean isModifiable() {
        return !this.workspace.isReadOnly();
    }

    @Override
    public Object label(Object construct) {
        String text = ((Element)construct).getShortLabel();
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        if (workingSet != null) {
            text = text + " (" + workingSet.getName() + ')';
        }
        return text;
    }

    @Override
    public Object summary(Object construct) {
        return ((Element)construct).getToolTipText();
    }

    @Override
    public Icon icon(Object construct) {
        return ((Element)construct).getIcon();
    }
}

