/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Element;
import oracle.javatools.util.Log;
import oracle.javatools.util.TypeMap;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdevimpl.audit.model.ContentRootFactory;
import oracle.jdevimpl.audit.model.DefaultModelFactory;

public class DefaultModelTypeFactory
extends ModelTypeFactory {
    private Collection<ModelType> modelTypes;
    private Collection<ContentRootFactory> contentRootFactories;
    private HashMap<Class<? extends ModelType>, ModelType> modelTypeByModelTypeClass;
    private TypeMap<Element, ModelType> modelTypeByRootElementType;
    private TypeMap<Element, ModelType> modelTypeByContainedElementType;
    private static final Log LOG = new Log("model");

    public DefaultModelTypeFactory(Collection<ModelType> modelTypes, Collection<ContentRootFactory> contentRootFactories) {
        this.modelTypes = modelTypes;
        this.contentRootFactories = contentRootFactories;
    }

    @Override
    public Collection<ModelType> getModelTypes() {
        return this.modelTypes;
    }

    @Override
    public Collection<ContentRootFactory> getContentRootFactories() {
        return this.contentRootFactories;
    }

    @Override
    public <T extends ModelType> T getModelType(Class<T> type) {
        this.load();
        return (T)((ModelType)type.cast(this.modelTypeByModelTypeClass.get(type)));
    }

    @Override
    public Collection<ModelType> getModelTypes(Element element) {
        LOG.trace("getting document type for document {0} element {1}", (Object)element);
        if (element == null) {
            return Collections.emptyList();
        }
        this.load();
        Class<?> elementType = element.getClass();
        ModelType type = (ModelType)this.modelTypeByRootElementType.get(elementType);
        if (type == null) {
            type = (ModelType)this.modelTypeByContainedElementType.get(elementType);
        }
        LOG.trace("got type {0}", (Object)type);
        if (type == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(type);
    }

    @Override
    public ModelFactory createModelFactory(Map attributes) {
        return new DefaultModelFactory(this, attributes);
    }

    private synchronized void load() {
        if (this.modelTypeByModelTypeClass == null) {
            LOG.trace("creating element type -> model type map");
            this.modelTypeByModelTypeClass = new HashMap();
            this.modelTypeByRootElementType = new TypeMap();
            this.modelTypeByContainedElementType = new TypeMap();
            for (ModelType modelType : this.getModelTypes()) {
                Collection<Class<? extends Element>> containedElementTypes;
                this.modelTypeByModelTypeClass.put(modelType.getClass(), modelType);
                Collection<Class<? extends Element>> rootElementTypes = modelType.getRootElementTypes();
                if (rootElementTypes != null) {
                    for (Class<? extends Element> type : rootElementTypes) {
                        LOG.trace("... mapping root element type {0} \t-> {1}", type, (Object)modelType);
                        if (type == null) continue;
                        this.modelTypeByRootElementType.put(type, (Object)modelType);
                    }
                }
                if ((containedElementTypes = modelType.getContainedElementTypes()) == null) continue;
                for (Class<? extends Element> type : containedElementTypes) {
                    LOG.trace("... mapping contained element type {0} \t-> {1}", type, (Object)modelType);
                    if (type == null) continue;
                    this.modelTypeByContainedElementType.put(type, (Object)modelType);
                }
            }
        }
    }
}

