/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryElement;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentCache;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdevimpl.audit.model.ContentRootFactory;
import oracle.jdevimpl.audit.model.DefaultContentCache;
import oracle.jdevimpl.audit.model.DirectoryModelAdapter;
import oracle.jdevimpl.audit.model.ProjectModelAdapter;
import oracle.jdevimpl.audit.model.RootModelAdapter;
import oracle.jdevimpl.audit.model.RootModelType;
import oracle.jdevimpl.audit.model.UnauditableFileModelType;
import oracle.jdevimpl.audit.model.WorkspaceModelAdapter;

public class DefaultModelFactory
implements ModelFactory {
    private static final Log LOG = new Log("model");
    private static volatile int generations = 0;
    private final MultiMap<Key, ModelAdapter> modelsByKey = new MultiMap();
    private final Map<Key, ContentCache> contentSetCaches = new HashMap<Key, ContentCache>();
    private final ModelTypeFactory typeFactory;
    private final RootModelAdapter root;
    private WorkingSet workingSet;
    private long maximumFileSize;
    private Map configurationAttributes;
    private int generation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultModelFactory(ModelTypeFactory factory, Map configurationAttributes) {
        this.typeFactory = factory;
        if (configurationAttributes == null) {
            configurationAttributes = new HashMap();
        }
        this.configurationAttributes = configurationAttributes;
        this.maximumFileSize = (long)(AuditManager.getAuditManager().getPreferences().getMaximumFileSize() * 1000000.0f);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.generation = generations++;
        }
        this.root = new RootModelAdapter(this, this.typeFactory.getModelType(RootModelType.class));
        this.modelsByKey.add((Object)new Key(), (Object)this.root);
        LOG.trace("created factory {0}, {1}", this.generation, configurationAttributes);
    }

    @Override
    public ModelTypeFactory getModelTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void setMaximumFileSize(long maximumFileSize) {
        this.maximumFileSize = maximumFileSize;
    }

    @Override
    public long getMaximumFileSize() {
        return this.maximumFileSize;
    }

    @Override
    public void setWorkingSet(WorkingSet workingSet) {
        if (workingSet != null && !workingSet.getName().equals(WorkingSets.ALL_FILES_WORKING_SET_LABEL)) {
            LOG.trace("setting working set of {1} to {0}", (Object)this, (Object)workingSet.getName());
            if (!this.contentSetCaches.isEmpty()) {
                throw new IllegalStateException("caches already created");
            }
            this.workingSet = workingSet;
        }
    }

    @Override
    public WorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public synchronized Location getModelRoot() {
        return this.root.getLocation();
    }

    @Override
    public ContentCache getContentSetCache(Project project, Workspace workspace) {
        Key key = new Key(workspace, (Element)project);
        ContentCache cache = this.contentSetCaches.get(key);
        if (cache == null) {
            PatternFilters globalIgnoreFilters = GlobalIgnoreList.getPatternFilters();
            PatternFilters jprJwsFilters = ContentSet.getExcludeJprJwsFilters();
            PatternFilters workingSetFilters = null;
            if (this.workingSet != null && project != null) {
                PatternFilters patternFilters = workingSetFilters = project != null ? this.workingSet.getPatternFilters(project) : null;
                if (workingSetFilters == null) {
                    workingSetFilters = PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
                }
            }
            IntersectedFilters filters = new IntersectedFilters(jprJwsFilters, globalIgnoreFilters, workingSetFilters);
            HashSet<ContentRoot> roots = new HashSet<ContentRoot>();
            for (ContentRootFactory rootFactory : this.typeFactory.getContentRootFactories()) {
                rootFactory.getRoots(workspace, project, filters, roots);
            }
            cache = new DefaultContentCache(new ArrayList<ContentRoot>(roots));
            this.contentSetCaches.put(key, cache);
        }
        return cache;
    }

    @Override
    public Collection<ModelAdapter> getModelAdapters(Element element, URL url, Project project, Workspace workspace) {
        ArrayList<ModelAdapter> models = new ArrayList<ModelAdapter>();
        this.addModelAdapters(models, element, url, project, workspace);
        return models;
    }

    public void addModelAdapters(Collection<ModelAdapter> models, Element element, URL url, Project project, Workspace workspace) {
        LOG.trace("getting model adapters for element {0}, url {1}, project {2}, workspace {3}", (Object)element, (Object)url, (Object)project, (Object)workspace);
        if (element instanceof RelativeDirectoryElement) {
            if (workspace == null) {
                return;
            }
            ContentCache cache = this.getContentSetCache(project, workspace);
            RelativeDirectoryElement folder = (RelativeDirectoryElement)element;
            String path = folder.getRelativePath();
            for (URL rootUrl : folder.getRootDirectories().asList()) {
                url = URLFactory.newDirURL((URL)rootUrl, (String)path);
                Collection<ContentDirectory> directories = cache.getDirectories(url);
                for (ContentDirectory directory : directories) {
                    this.getOrCreateModelAdapters(models, directory, directory.getURL(), project, workspace);
                }
            }
        } else if (url == null) {
            if (element instanceof Workspaces) {
                models.add(this.root);
            } else if (element instanceof Locatable && (url = ((Locatable)element).getURL()) != null) {
                if (URLFileSystem.isDirectoryPath((URL)url) || URLFileSystem.isDirectory((URL)url)) {
                    ContentCache cache = this.getContentSetCache(project, workspace);
                    Collection<ContentDirectory> directories = cache.getDirectories(url);
                    for (ContentDirectory directory : directories) {
                        this.getOrCreateModelAdapters(models, directory, directory.getURL(), project, workspace);
                    }
                } else {
                    this.getOrCreateModelAdapters(models, element, url, project, workspace);
                }
            }
        } else {
            this.getOrCreateModelAdapters(models, element, url, project, workspace);
        }
        LOG.trace("got models {0} for {1}", models, (Object)element);
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModelAdapter(Class<T> type, URL url, Project project, Workspace workspace) {
        Collection<ModelAdapter> models = this.getModelAdapters(null, url, project, workspace);
        for (ModelAdapter model : models) {
            if (!model.getClass().equals(type)) continue;
            return model;
        }
        return null;
    }

    @Override
    public Collection<ModelAdapter> getContainedModelAdapters(Element element, URL url, ContainerModelAdapter container) {
        ArrayList<ModelAdapter> models = new ArrayList<ModelAdapter>();
        this.addModelAdapters(models, element, url, container.getProject(), container.getWorkspace());
        Iterator i = models.iterator();
        while (i.hasNext()) {
            ModelAdapter model = (ModelAdapter)i.next();
            if (container == model.getContainingAdapter()) continue;
            i.remove();
        }
        return models;
    }

    @Override
    public synchronized void close() {
        LOG.trace("releasing factory {0} models", this.generation);
        for (Collection list : this.modelsByKey.values()) {
            for (ModelAdapter model : list) {
                model.release();
            }
        }
        this.modelsByKey.clear();
        LOG.trace("completed releasing factory {0} models", this.generation);
    }

    @Override
    public Object getAttribute(Object key) {
        return this.configurationAttributes.get(key);
    }

    @Override
    public Map getAttributes() {
        return this.configurationAttributes;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void getOrCreateModelAdapters(Collection<ModelAdapter> models, Element element, URL url, Project project, Workspace workspace) {
        assert (LOG.trace("get or create element {0}, url {1}, project {2}, workspace {3}", (Object)element, (Object)url, (Object)project, (Object)workspace));
        assert (url != null || element instanceof Workspaces);
        if (element == null && (element = NodeFactory.find((URL)url)) == null) {
            if (URLFileSystem.isRegularFile((URL)url)) {
                try {
                    element = NodeFactory.findOrCreate((URL)url);
                }
                catch (IllegalAccessException e) {
                    LOG.trace("findOrCreate failed for {0}: {1}", (Object)url, (Object)e);
                    return;
                }
                catch (InstantiationException e) {
                    LOG.trace("findOrCreate failed for {0}: {1}", (Object)url, (Object)e);
                    return;
                }
            } else {
                if (URLFileSystem.isDirectoryPath((URL)url) || URLFileSystem.isDirectory((URL)url)) {
                    assert (workspace != null);
                    ContentCache cache = this.getContentSetCache(project, workspace);
                    Collection<ContentDirectory> directories = cache.getDirectories(url);
                    for (ContentDirectory directory : directories) {
                        this.getOrCreateModelAdapters(models, directory, url, project, workspace);
                    }
                    LOG.trace("got or created {0} from {1}", models, (Object)url);
                    return;
                }
                LOG.trace("element null and URL does not exist: {0}", (Object)url);
                return;
            }
        }
        if (element == this.root.getElement()) {
            models.add(this.root);
        } else if (element instanceof Workspace) {
            Key key = new Key(element);
            Collection existingModels = this.modelsByKey.get((Object)key);
            if (existingModels == null) {
                LOG.trace("creating workspace {0}", (Object)element);
                Collection<ModelType> types = this.typeFactory.getModelTypes(element);
                for (ModelType type : types) {
                    ModelAdapter model = type.createModelAdapter(this, element, url, null, null, null);
                    this.modelsByKey.add((Object)key, (Object)model);
                    models.add(model);
                }
            } else {
                LOG.trace("getting workspace {0}", (Object)element);
                models.addAll(existingModels);
            }
        } else if (element instanceof Project) {
            if (workspace == null) {
                return;
            }
            Key key = new Key(workspace, element);
            Collection existingModels = this.modelsByKey.get((Object)key);
            if (existingModels == null) {
                LOG.trace("creating project {0}", (Object)element);
                WorkspaceModelAdapter workspaceModel = null;
                ArrayList<ModelAdapter> containers = new ArrayList<ModelAdapter>();
                this.getOrCreateModelAdapters(containers, (Element)workspace, workspace.getURL(), null, null);
                for (ModelAdapter container : containers) {
                    if (!(container instanceof WorkspaceModelAdapter)) continue;
                    workspaceModel = (WorkspaceModelAdapter)container;
                    break;
                }
                if (workspaceModel == null) {
                    throw new IllegalStateException("cannot get model for workspace " + workspace);
                }
                Collection<ModelType> types = this.typeFactory.getModelTypes(element);
                for (ModelType type : types) {
                    ModelAdapter model = type.createModelAdapter(this, element, url, null, null, workspaceModel);
                    this.modelsByKey.add((Object)key, (Object)model);
                    models.add(model);
                }
            } else {
                LOG.trace("getting project {0}", (Object)element);
                models.addAll(existingModels);
            }
        } else if (element instanceof ContentDirectory) {
            if (workspace == null) {
                return;
            }
            ContentDirectory directory = (ContentDirectory)element;
            int depth = directory.getDepth();
            Key key = new Key(workspace, project, url, depth);
            Collection existingModels = this.modelsByKey.get((Object)key);
            if (existingModels == null) {
                ProjectModelAdapter projectModel = this.getOrCreateProjectModelAdapter(workspace, project);
                DirectoryModelAdapter directoryModel = null;
                LOG.trace("getting parent directory for {1} at depth {0}", depth, (Object)url);
                if (depth > 0) {
                    ContentCache cache = this.getContentSetCache(project, workspace);
                    ContentDirectory parentDirectory = cache.getContainingDirectory(directory);
                    ArrayList<ModelAdapter> containers = new ArrayList<ModelAdapter>();
                    this.getOrCreateModelAdapters(containers, parentDirectory, parentDirectory.getURL(), project, workspace);
                    assert (!containers.isEmpty());
                    for (ModelAdapter container : containers) {
                        if (!(container instanceof DirectoryModelAdapter)) continue;
                        directoryModel = (DirectoryModelAdapter)container;
                        assert (container.getDirectory().getDepth() == directory.getDepth() - 1);
                    }
                }
                LOG.trace("got parent directory {0} for {1}", directoryModel, (Object)url);
                Collection<ModelType> types = this.typeFactory.getModelTypes(element);
                for (ModelType type : types) {
                    try {
                        if (!type.isRootElementType(element)) {
                            element = NodeFactory.findOrCreate((URL)url);
                        }
                        LOG.trace("creating model adapter for {0} in {1} of type {2}", (Object)url, directoryModel, (Object)type);
                        ModelAdapter model = type.createModelAdapter(this, element, url, directoryModel, projectModel, this.getOrCreateWorkspaceModelAdapter(workspace));
                        this.modelsByKey.add((Object)key, (Object)model);
                        models.add(model);
                        LOG.trace("got model {0} for {1}", (Object)model, (Object)url);
                    }
                    catch (Exception e) {
                        AuditLogger.error("node {0} nominally containing element {1} not created: {2}", e, url, element, e);
                    }
                }
            } else {
                LOG.trace("getting directory or file models {0}", (Object)existingModels);
                models.addAll(existingModels);
            }
        } else {
            if (workspace == null) {
                return;
            }
            Key key = new Key(workspace, project, url);
            Collection existingModels = this.modelsByKey.get((Object)key);
            if (existingModels == null) {
                LOG.trace("getting parent directory for {0}", (Object)url);
                ProjectModelAdapter projectModel = this.getOrCreateProjectModelAdapter(workspace, project);
                ContentCache cache = this.getContentSetCache(project, workspace);
                Collection<ContentDirectory> directories = cache.getDirectories(url);
                if (directories.isEmpty()) {
                    return;
                }
                Iterator<ContentDirectory> i = directories.iterator();
                ContentDirectory preferredDirectory = i.next();
                while (i.hasNext()) {
                    ContentDirectory directory = i.next();
                    if (preferredDirectory.getDepth() <= directory.getDepth()) continue;
                    preferredDirectory = directory;
                }
                DirectoryModelAdapter directoryModel = null;
                LOG.trace("getting parent directory for {0}", (Object)url);
                ArrayList<ModelAdapter> containers = new ArrayList<ModelAdapter>();
                URL directoryUrl = URLFileSystem.getParent((URL)url);
                this.getOrCreateModelAdapters(containers, preferredDirectory, directoryUrl, project, workspace);
                for (ModelAdapter container : containers) {
                    if (!(container instanceof DirectoryModelAdapter)) continue;
                    directoryModel = (DirectoryModelAdapter)container;
                }
                LOG.trace("got parent directory {0} for {1}", directoryModel, (Object)url);
                Collection<ModelType> types = URLFileSystem.getLength((URL)url) <= this.maximumFileSize ? this.typeFactory.getModelTypes(element) : Collections.singletonList(this.typeFactory.getModelType(UnauditableFileModelType.class));
                for (ModelType type : types) {
                    try {
                        if (!type.isRootElementType(element)) {
                            element = NodeFactory.findOrCreate((URL)url);
                        }
                        if (!type.isAuditable(element, preferredDirectory, project, workspace)) continue;
                        LOG.trace("creating model adapter for {0} in {1} of type {2}", (Object)url, (Object)directoryModel, (Object)type);
                        ModelAdapter model = type.createModelAdapter(this, element, url, directoryModel, projectModel, this.getOrCreateWorkspaceModelAdapter(workspace));
                        this.modelsByKey.add((Object)key, (Object)model);
                        models.add(model);
                        LOG.trace("got model {0} for {1}", (Object)model, (Object)url);
                    }
                    catch (Exception e) {
                        AuditLogger.error("node {0} nominally containing element {1} not created: {2}", e, url, element, e);
                    }
                }
            } else {
                LOG.trace("getting directory or file models {0}", (Object)existingModels);
                models.addAll(existingModels);
            }
        }
        LOG.trace("got or created {0}", models);
    }

    private WorkspaceModelAdapter getOrCreateWorkspaceModelAdapter(Workspace workspace) {
        if (workspace != null) {
            ArrayList<ModelAdapter> containers = new ArrayList<ModelAdapter>();
            this.getOrCreateModelAdapters(containers, (Element)workspace, workspace.getURL(), null, null);
            for (ModelAdapter container : containers) {
                if (!(container instanceof WorkspaceModelAdapter)) continue;
                return (WorkspaceModelAdapter)container;
            }
        }
        return null;
    }

    private ProjectModelAdapter getOrCreateProjectModelAdapter(Workspace workspace, Project project) {
        if (project != null) {
            ArrayList<ModelAdapter> containers = new ArrayList<ModelAdapter>();
            this.getOrCreateModelAdapters(containers, (Element)project, project.getURL(), null, workspace);
            for (ModelAdapter container : containers) {
                if (!(container instanceof ProjectModelAdapter)) continue;
                return (ProjectModelAdapter)container;
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.generation);
    }

    static class Key {
        private String k1 = "";
        private String k2 = "";
        private String k3 = "";
        private int depth;
        private int code;

        public Key() {
        }

        public Key(Element workspace) {
            this();
            if (workspace != null) {
                this.k1 = workspace.getLongLabel();
                this.code = this.k1.hashCode();
            }
            this.k3 = "";
            this.k2 = "";
        }

        public Key(Workspace workspace, Element project) {
            this((Element)workspace);
            if (project != null) {
                this.k2 = project.getLongLabel();
                this.code = this.code * 37 + this.k2.hashCode();
            }
        }

        public Key(Workspace workspace, Project project, URL url) {
            this(workspace, (Element)project);
            this.k3 = URLFileSystem.getPlatformPathName((URL)url);
            this.code = this.code * 37 + this.k3.hashCode();
        }

        public Key(Workspace workspace, Project project, URL url, int depth) {
            this(workspace, project, url);
            this.depth = depth;
            this.code = this.code * 37 + depth;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key that = (Key)object;
            return this.k1.equals(that.k1) && this.k2.equals(that.k2) && this.k3.equals(that.k3) && this.depth == that.depth;
        }

        public int hashCode() {
            return this.code;
        }
    }
}

