/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntersectedFilters;
import oracle.jdeveloper.audit.model.ContentRoot;

public class DefaultContentRoot
implements ContentRoot {
    private URL url;
    private String path;
    private String normalizedPath;
    private IntersectedFilters filters;
    private String label;
    private String key;
    private boolean canContainJavaSources;

    DefaultContentRoot(URL url) {
        this.url = url;
        this.path = url.toString();
        this.normalizedPath = "file".equals(url.getProtocol()) && !URLFileSystem.isLocalFileSystemCaseSensitive() ? this.path.toLowerCase() : this.path;
    }

    public DefaultContentRoot(URL url, String key, String label, boolean java, IntersectedFilters filters) {
        this(url);
        this.key = key;
        this.label = label;
        this.filters = filters;
        this.canContainJavaSources = java;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public IntersectedFilters getFilters() {
        return this.filters;
    }

    @Override
    public boolean canContainJavaSources() {
        return this.canContainJavaSources;
    }

    @Override
    public int compareTo(ContentRoot root) {
        return this.normalizedPath.compareTo(root.getNormalizedPath());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentRoot)) {
            return false;
        }
        ContentRoot that = (ContentRoot)object;
        return this.normalizedPath.equals(that.getNormalizedPath()) && this.key.equals(that.getKey()) && this.filters.equals((Object)that.getFilters());
    }

    public int hashCode() {
        return (this.normalizedPath.hashCode() * 37 << 1 + this.key.hashCode()) * 37 << 1 + this.filters.hashCode();
    }

    @Override
    public boolean contains(ContentRoot root) {
        return root.getNormalizedPath().startsWith(this.normalizedPath);
    }

    public String toString() {
        return "root [" + this.path + ", " + this.key + "]";
    }
}

