/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.transform.TransformerException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.report.StyleSheet;
import oracle.jdevimpl.audit.report.StyleSheetRepository;
import oracle.jdevimpl.audit.report.XMLAuditReporter;
import oracle.jdevimpl.audit.report.XSLTAuditReporter;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Cache;
import oracle.jdevimpl.audit.util.Strings;

public class AuditExportDialog {
    private AuditModel model;
    private String tabName;
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);

    public AuditExportDialog(AuditModel model, String tabName) {
        this.model = model;
        this.tabName = tabName;
    }

    public void show() {
        String defaultName;
        URL file;
        String oldSuffix;
        int dot;
        Context context = new Context();
        Location root = this.model.getLocation(this.model.getRoot());
        if (root.getWorkspace() != null) {
            context.setWorkspace(root.getWorkspace());
            if (root.getProject() != null) {
                context.setProject(root.getProject());
            }
        }
        StyleSheetRepository repository = new StyleSheetRepository();
        List<StyleSheet> styleSheets = repository.getStyleSheets();
        Collections.sort(styleSheets, new StyleSheetComparator());
        String XSLT_KEY = "audit.report.xslt";
        String STYLE_SHEET_KEY = "audit.report.style.sheet";
        String DIRECTORY_KEY = "audit.report.directory";
        String title = bundle.get("results.export.audit.default-title", new Object[]{this.tabName});
        boolean xslt = Cache.get("audit.report.xslt", true);
        StyleSheet styleSheet = null;
        String suffix = ".xml";
        if (styleSheets.isEmpty()) {
            xslt = false;
        } else {
            StyleSheet defaultStyleSheet = styleSheets.get(0);
            String defaultStyleSheetName = defaultStyleSheet.getName();
            String styleSheetName = (String)Cache.get("audit.report.style.sheet", defaultStyleSheetName);
            styleSheet = repository.getStyleSheet(styleSheetName);
            if (styleSheet == null) {
                styleSheet = defaultStyleSheet;
            }
            if (xslt) {
                suffix = styleSheet.getOutputSuffix();
            }
        }
        URL defaultDirectory = (URL)Cache.get("audit.report.directory");
        if (defaultDirectory == null) {
            Project node = context.getProject();
            if (node == null) {
                node = context.getWorkspace();
            }
            defaultDirectory = node == null ? Ide.getWorkspaces().getWorkDirectory() : URLFileSystem.getParent((URL)node.getURL());
        }
        if ((dot = this.tabName.lastIndexOf(46)) >= 0) {
            this.tabName = this.tabName.substring(0, dot);
        }
        if (!(oldSuffix = URLFileSystem.getSuffix((URL)(file = URLFactory.newURL((URL)defaultDirectory, (String)(defaultName = this.tabName + "-" + this.model.getProfile().getName().toLowerCase().replace(' ', '-') + suffix))))).equals(suffix)) {
            file = URLFileSystem.convertSuffix((URL)file, (String)oldSuffix, (String)suffix);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.weightx = 1.0;
        ++constraints.gridy;
        constraints.insets.top = 15;
        JLabel titleLabel = new JLabel(bundle.get("results.export.title.label"));
        titleLabel.setDisplayedMnemonic(bundle.get("results.export.title.mnemonic").charAt(0));
        panel.add((Component)titleLabel, constraints);
        ++constraints.gridy;
        constraints.insets.top = 5;
        JTextField titleField = new JTextField(title);
        titleLabel.setLabelFor(titleField);
        panel.add((Component)titleField, constraints);
        ++constraints.gridy;
        constraints.insets.top = 15;
        final JCheckBox xsltCheckBox = new JCheckBox(bundle.get("results.export.apply-style-sheet.label"), xslt);
        xsltCheckBox.setMargin(new Insets(0, 0, 0, 0));
        xsltCheckBox.setMnemonic(bundle.get("results.export.apply-style-sheet.mnemonic").charAt(0));
        xsltCheckBox.setEnabled(!styleSheets.isEmpty());
        panel.add((Component)xsltCheckBox, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.insets.top = 5;
        constraints.insets.left = 24;
        constraints.weightx = 0.0;
        final JLabel styleSheetLabel = new JLabel(bundle.get("results.export.style-sheet.label"));
        styleSheetLabel.setDisplayedMnemonic(bundle.get("results.export.style-sheet.mnemonic").charAt(0));
        panel.add((Component)styleSheetLabel, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.insets.left = 12;
        constraints.weightx = 1.0;
        final JComboBox<Object> styleSheetBox = new JComboBox<Object>(styleSheets.toArray());
        styleSheetBox.setSelectedItem(styleSheet);
        styleSheetBox.setEnabled(xslt);
        styleSheetLabel.setLabelFor(styleSheetBox);
        panel.add(styleSheetBox, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.insets.top = 15;
        constraints.insets.left = 0;
        JLabel fileLabel = new JLabel(bundle.get("results.export.output-file.label"));
        fileLabel.setDisplayedMnemonic(bundle.get("results.export.output-file.mnemonic").charAt(0));
        panel.add((Component)fileLabel, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 2;
        constraints.insets.top = 5;
        constraints.insets.bottom = 15;
        constraints.insets.right = 12;
        constraints.weightx = 1.0;
        final CustomURLTextField fileField = new CustomURLTextField(context, file, styleSheetBox);
        fileField.setColumns(32);
        fileField.setURL(file);
        fileLabel.setLabelFor((Component)((Object)fileField));
        panel.add((Component)((Object)fileField), constraints);
        constraints.gridx = 2;
        constraints.insets.right = 0;
        constraints.weightx = 0.0;
        JButton browse = new JButton(bundle.get("results.export.browse.label"));
        browse.setMnemonic(bundle.get("results.export.browse.mnemonic").charAt(0));
        browse.addActionListener((ActionListener)((Object)fileField));
        panel.add((Component)browse, constraints);
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        ++constraints.gridy;
        constraints.weighty = 1.0;
        panel.add(Box.createVerticalGlue(), constraints);
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle(bundle.get("results.export.audit.title", new Object[]{this.tabName, this.model.getProfile().getName()}));
        dialog.setContent(panel);
        dialog.addCancelButton(null);
        final JButton ok = dialog.addOkButton(null);
        dialog.setHelpTopic(bundle.get("results.export.audit.help"));
        xsltCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean xslt = xsltCheckBox.isSelected();
                styleSheetLabel.setEnabled(xslt);
                styleSheetBox.setEnabled(xslt);
                AuditExportDialog.this.resetSuffix(styleSheetBox, fileField);
            }
        });
        fileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ok.setEnabled(fileField.getURL() != null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(null);
            }
        });
        styleSheetBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditExportDialog.this.resetSuffix(styleSheetBox, fileField);
            }
        });
        JButton result = dialog.show();
        if (result == ok) {
            title = titleField.getText();
            xslt = xsltCheckBox.isSelected();
            if (xslt) {
                styleSheet = (StyleSheet)styleSheetBox.getSelectedItem();
                suffix = styleSheet.getOutputSuffix();
            } else {
                suffix = ".xml";
            }
            file = fileField.getURL();
            if ("".equals(URLFileSystem.getSuffix((URL)file))) {
                file = URLFileSystem.ensureSuffix((URL)file, (String)suffix);
            }
            String name = URLFileSystem.getPlatformPathName((URL)file);
            try {
                if (xslt) {
                    XSLTAuditReporter reporter = new XSLTAuditReporter();
                    reporter.setStyleSheet(styleSheet);
                    reporter.setTitle(title);
                    reporter.setFile(file);
                    reporter.report(this.model);
                } else {
                    XMLAuditReporter reporter = new XMLAuditReporter();
                    reporter.setTitle(title);
                    reporter.setFile(file);
                    reporter.report(this.model);
                }
                Ide.getStatusBar().setText(bundle.get("results.export.audit.completed", new Object[]{name}));
                Cache.put("audit.report.xslt", xslt);
                if (xslt) {
                    Cache.put("audit.report.style.sheet", styleSheet.getName());
                }
                Cache.put("audit.report.directory", URLFileSystem.getParent((URL)file));
            }
            catch (InvocationTargetException e) {
                Log.error((String)"exception exporting \"{0}\": {1}", (Object)name, (Object)e.getCause());
                MessageDialog message = new MessageDialog(MessageDialog.ERROR);
                message.setTitle(bundle.get("results.export.exception.title"));
                Throwable cause = e.getCause();
                String content = xslt && cause instanceof TransformerException ? Strings.toString(bundle.get("results.export.transformer-exception.message"), new Object[]{name, styleSheet.getName(), ((TransformerException)cause).getMessageAndLocation()}) : Strings.toString(bundle.get("results.export.exception.message"), new Object[]{name, cause});
                message.setContent(content);
                message.show();
            }
        }
    }

    private void resetSuffix(JComboBox styleSheetBox, URLTextField fileField) {
        URL url;
        String oldSuffix;
        String suffix = ".xml";
        if (styleSheetBox.isEnabled()) {
            StyleSheet styleSheet = (StyleSheet)styleSheetBox.getSelectedItem();
            suffix = styleSheet.getOutputSuffix();
        }
        if (!suffix.equals(oldSuffix = URLFileSystem.getSuffix((URL)(url = fileField.getURL())))) {
            fileField.setURL(URLFileSystem.convertSuffix((URL)url, (String)oldSuffix, (String)suffix));
        }
    }

    private static class StyleSheetComparator
    implements Comparator<StyleSheet> {
        private StyleSheetComparator() {
        }

        @Override
        public int compare(StyleSheet o1, StyleSheet o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class CustomURLTextField
    extends URLTextField {
        private Context context;
        private JComboBox styleSheetBox;

        public CustomURLTextField(Context context, URL url, JComboBox styleSheetBox) {
            super(url, false);
            this.context = context;
            this.styleSheetBox = styleSheetBox;
        }

        public boolean browseForURL() {
            DefaultURLFilter filter;
            boolean result = false;
            URL url = this.getURL();
            LinkedHashMap<String, DefaultURLFilter> filters = new LinkedHashMap<String, DefaultURLFilter>();
            String filterSuffix = null;
            String oldSuffix = URLFileSystem.getSuffix((URL)url);
            if (this.styleSheetBox.isEnabled()) {
                filters.put(".html", new DefaultURLFilter(bundle.get("results.export.chooser.filter.html.label"), ".html"));
                filters.put(".txt", new DefaultURLFilter(bundle.get("results.export.chooser.filter.text.label"), ".txt"));
                filters.put(".xml", new DefaultURLFilter(bundle.get("results.export.chooser.filter.xml.label"), ".xml"));
                filters.put(null, new DefaultURLFilter(bundle.get("results.export.chooser.filter.all.label")));
                StyleSheet styleSheet = (StyleSheet)this.styleSheetBox.getSelectedItem();
                String styleSheetSuffix = styleSheet.getOutputSuffix();
                filter = (URLFilter)filters.get(styleSheetSuffix);
                if (filter != null) {
                    filterSuffix = styleSheetSuffix;
                } else {
                    filter = (URLFilter)filters.get(null);
                }
            } else {
                filter = new DefaultURLFilter(bundle.get("results.export.chooser.filter.xml.label"), ".xml");
                filters.put(".xml", filter);
                filters.put(null, new DefaultURLFilter(bundle.get("results.export.chooser.filter.all.label")));
                filterSuffix = ".xml";
            }
            if (oldSuffix.equals(filterSuffix)) {
                url = URLFileSystem.convertSuffix((URL)url, (String)oldSuffix, (String)"");
            }
            URLChooser chooser = DialogUtil.newURLChooser((Context)this.context, (URL)url);
            chooser.clearChooseableURLFilters();
            Iterator i = filters.values().iterator();
            while (i.hasNext()) {
                chooser.addChooseableURLFilter((URLFilter)i.next());
            }
            chooser.setURLFilter((URLFilter)filter);
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(0);
            int response = chooser.showSaveDialog((Component)((Object)this), bundle.get("results.export.chooser.title"));
            if (response == 0) {
                url = chooser.getSelectedURL();
                if ("".equals(URLFileSystem.getSuffix((URL)url))) {
                    filter = chooser.getSelectedFilter();
                    String newSuffix = null;
                    for (Map.Entry entry : filters.entrySet()) {
                        if (filter != entry.getValue()) continue;
                        newSuffix = (String)entry.getKey();
                        break;
                    }
                    url = URLFileSystem.convertSuffix((URL)url, (String)"", newSuffix);
                }
                this.setURL(url);
                result = true;
            }
            return result;
        }
    }
}

