/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ideimpl.controller.CommandExecutionTracker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.Tuple;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyListener;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.DefaultTransformsAction;
import oracle.jdeveloper.audit.service.Iteration;
import oracle.jdeveloper.audit.service.TransformAction;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.TransformerListener;
import oracle.jdeveloper.audit.service.TransformerQueryInterceptor;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.CompositeTransform;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.core.AuditELContext;

public class DefaultTransformer
implements Transformer {
    private AuditELContext expressionContext = new AuditELContext();
    private boolean queryAllowed = true;
    private Map<Transform, TransformerQueryInterceptor> interceptors;
    private final DependencyListener NULL_CHANGE_LISTENER = new DependencyListener(){

        @Override
        public void dependencyChanged(Dependency dependency, boolean possibleSequence) {
        }
    };
    private static final FormatBundle bundle = new FormatBundle(AuditBundle.class);
    private static final Log LOG = new Log("transformer");
    private Map<String, Method> mostSpecificMethods = new HashMap<String, Method>();
    private Map<Class<?>, Method[]> allMethods = new HashMap();

    @Override
    public void setQueryAllowed(boolean queryAllowed) {
        LOG.trace("query allowed {0}", queryAllowed);
        this.queryAllowed = queryAllowed;
    }

    @Override
    public void setQueryInterceptor(Transform transform, TransformerQueryInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new HashMap<Transform, TransformerQueryInterceptor>();
        }
        this.interceptors.put(transform, interceptor);
    }

    private List<Violation> getViolationsWithDefaultTransforms(AuditModel model, Object[] objects) {
        final ArrayList<Violation> violations = new ArrayList<Violation>();
        for (Object object : objects) {
            if (object == null) continue;
            model.iterateViolations(object, new Iteration(){

                @Override
                public boolean iteration(Object object) {
                    Violation violation = (Violation)object;
                    if (violation.getDefaultTransform() != null) {
                        violations.add(violation);
                    }
                    return true;
                }
            });
        }
        return violations;
    }

    private TransformContext[] createContexts(Transform transform, Violation violation) {
        TransformContext[] contexts;
        Map<String, DeferredSetter> setters = transform.setters();
        if (setters != null && !setters.isEmpty()) {
            this.expressionContext.setBean(transform, violation.getRule(), violation);
            for (Map.Entry entry : setters.entrySet()) {
                DeferredSetter setter = (DeferredSetter)entry.getValue();
                try {
                    setter.set(transform, this.expressionContext);
                }
                catch (Throwable e) {
                    setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform, setter.getText(), e);
                    return new TransformContext[0];
                }
            }
        }
        if (transform instanceof CompositeTransform) {
            for (Transform transform2 : ((CompositeTransform)transform).getComponents()) {
                setters = transform2.setters();
                if (setters == null || setters.isEmpty()) continue;
                this.expressionContext.setBean(transform2, violation.getRule(), violation);
                for (Map.Entry<String, DeferredSetter> entry : setters.entrySet()) {
                    DeferredSetter setter = entry.getValue();
                    try {
                        setter.set(transform2, this.expressionContext);
                    }
                    catch (Throwable e) {
                        setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform2, setter.getText(), e);
                        return new TransformContext[0];
                    }
                }
            }
        }
        if ((contexts = transform.createContexts(violation)) == null) {
            contexts = new TransformContext[]{};
        }
        return contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isApplicable(TransformContext context) {
        Location location = context.getLocation();
        ModelAdapter model = location.getModel();
        model.beginRead();
        try {
            if (!context.getAdapter().isTransformable(context)) {
                boolean bl = false;
                return bl;
            }
            Object construct = model.getConstruct(location);
            Method[] methods = this.methods(context, construct);
            if (methods == null) {
                boolean bl = false;
                return bl;
            }
            Method applicableMethod = methods[0];
            if (applicableMethod != null) {
                boolean applicable = this.invokeBoolean(context.getTransform(), applicableMethod, context, construct);
                LOG.trace("applicable {0} ({1})", applicable, (Object)applicableMethod);
                if (!applicable) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)"exception caught while evaluating transform {0}: {1}", (Object)context.getTransform(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            model.endRead();
        }
        LOG.trace("applicable by default");
        return true;
    }

    @Override
    public List<TransformAction> createTransformActions(Violation violation, TransformerListener listener, AuditModel model) {
        return this.createTransformActions(Collections.singletonList(violation), listener, model);
    }

    @Override
    public List<TransformAction> createTransformActions(Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        ArrayList<TransformAction> actions = new ArrayList<TransformAction>();
        HashSet<String> labels = new HashSet<String>();
        for (Violation violation : violations) {
            Icon icon = violation.getRule().getSeverity().getIcon();
            int count = violation.getTransformCount();
            for (int i = 0; i < count; ++i) {
                String label;
                Transform transform = violation.getTransform(i);
                TransformContext[] contexts = this.createContexts(transform, violation);
                if (contexts.length == 0 || !labels.add(label = transform.boundLabel(contexts[0]))) continue;
                DefaultTransformAction action = new DefaultTransformAction(label, icon, Collections.singletonList(violation), transform, listener, model);
                for (TransformContext context : contexts) {
                    if (this.isApplicable(context)) continue;
                    action.setEnabled(false);
                    action.putValue("ShortDescription", AuditBundle.get("transform.disabled.tip"));
                    break;
                }
                actions.add(action);
            }
        }
        return actions;
    }

    @Override
    public DefaultTransformsAction createDefaultTransformsAction(String label, Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        DefaultTransformAction action = new DefaultTransformAction(label != null ? label : bundle.get("apply-default-fixes.label"), OracleIcons.getIcon((String)"fix.png"), violations, null, listener, model);
        action.setEnabled(false);
        block0: for (Violation violation : violations) {
            Transform transform = violation.getDefaultTransform();
            if (transform == null) continue;
            for (TransformContext context : this.createContexts(transform, violation)) {
                if (!this.isApplicable(context)) continue;
                action.setEnabled(true);
                continue block0;
            }
        }
        return action;
    }

    @Override
    public DefaultTransformsAction createDefaultTransformsAction(String label, AuditModel model, Object[] objects, TransformerListener listener) {
        return this.createDefaultTransformsAction(label, this.getViolationsWithDefaultTransforms(model, objects), listener, model);
    }

    @Override
    public Throwable applyDefaultTransforms(String label, Collection<? extends Violation> violations, TransformerListener listener, AuditModel model) {
        DefaultTransformsAction action = this.createDefaultTransformsAction(label, violations, listener, model);
        return action.apply();
    }

    @Override
    public Throwable applyDefaultTransforms(String label, AuditModel model, Object[] objects, TransformerListener listener) {
        List<Violation> violations = this.getViolationsWithDefaultTransforms(model, objects);
        if (violations.isEmpty()) {
            return null;
        }
        return this.applyDefaultTransforms(label, violations, listener, model);
    }

    private Method[] methods(TransformContext context, Object construct) {
        Transform transform = context.getTransform();
        try {
            if (construct == null) {
                LOG.trace("not applicable: construct null");
                return null;
            }
            Class<?> type = construct.getClass();
            Method applyMethod = this.method("apply", transform, context, construct);
            if (applyMethod == null) {
                LOG.trace("not applicable: no apply method in {0}", type);
                return null;
            }
            Method queryRequiredMethod = this.method("isQueryRequired", transform, context, construct);
            Method queryMethod = this.method("query", transform, context, construct);
            if (!this.queryAllowed && queryMethod != null && queryRequiredMethod == null) {
                LOG.trace("not applicable: query required but queries disallowed");
                return null;
            }
            Method applicableMethod = this.method("isApplicable", transform, context, construct);
            Method[] methods = new Method[]{applicableMethod, queryRequiredMethod, queryMethod, applyMethod};
            LOG.trace("methods {0} for ", (Object)methods, type);
            return methods;
        }
        catch (Throwable e) {
            Log.error((String)"exception caught while evaluating fix {0}: {1}", (Object)transform, (Object)e);
            return null;
        }
    }

    private boolean invokeBoolean(Object target, Method method, TransformContext context, Object construct) throws IllegalAccessException, InvocationTargetException {
        return Boolean.TRUE.equals(this.invoke(target, method, context, construct));
    }

    private Object invoke(Object target, Method method, TransformContext context, Object construct) throws IllegalAccessException, InvocationTargetException {
        Object[] arguments = new Object[]{context, construct};
        return method.invoke(target, arguments);
    }

    private Method method(String name, Object transformOrInterceptor, TransformContext context, Object construct) {
        Class<?> transformType = transformOrInterceptor.getClass();
        Class<?> contextType = context.getClass();
        Class<?> constructType = construct.getClass();
        String key = name + transformType.getName() + contextType.getName() + constructType.getName();
        Method mostSpecificMethod = this.mostSpecificMethods.get(key);
        if (mostSpecificMethod != null) {
            return mostSpecificMethod;
        }
        Method[] methods = this.allMethods.get(transformType);
        if (methods == null) {
            methods = transformType.getMethods();
            this.allMethods.put(transformType, methods);
        }
        ArrayList<Method> maximallySpecificMethods = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?> methodConstructType;
            Class<?> methodContextType;
            if (!name.equals(method.getName())) continue;
            Class<?> returnType = method.getReturnType();
            if (name.equals("isApplicable") && !returnType.equals(Boolean.TYPE)) {
                Log.error((String)"Method {0} ignored because return type is not boolean", (Object)method);
            } else if (name.equals("query") && !returnType.equals(Boolean.TYPE)) {
                Log.error((String)"Method {0} ignored because return type is not boolean", (Object)method);
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 2 || !(methodContextType = parameterTypes[0]).isAssignableFrom(contextType) || !(methodConstructType = parameterTypes[1]).isAssignableFrom(constructType)) continue;
            if (maximallySpecificMethods.isEmpty()) {
                maximallySpecificMethods.add(method);
                continue;
            }
            ListIterator<Method> i = maximallySpecificMethods.listIterator();
            while (i.hasNext()) {
                Method maximallySpecificMethod = (Method)i.next();
                Class<?>[] types = maximallySpecificMethod.getParameterTypes();
                boolean contextMoreSpecific = types[0].isAssignableFrom(methodContextType);
                boolean constructMoreSpecific = types[1].isAssignableFrom(methodConstructType);
                if (contextMoreSpecific && constructMoreSpecific) {
                    i.remove();
                    i.add(method);
                    continue;
                }
                if (!contextMoreSpecific && !constructMoreSpecific) continue;
                i.add(method);
            }
        }
        switch (maximallySpecificMethods.size()) {
            case 0: {
                mostSpecificMethod = null;
                break;
            }
            case 1: {
                mostSpecificMethod = (Method)maximallySpecificMethods.iterator().next();
                break;
            }
            default: {
                if (transformOrInterceptor instanceof Transform) {
                    ((Transform)transformOrInterceptor).logError("No {0} method in {1} is unambiguously most specific for {2} - {3}; methods: {4}", name, transformType.getName(), contextType.getName(), constructType.getName(), maximallySpecificMethods);
                } else {
                    ExtensionRegistry.getExtensionRegistry().getManifestLogger().log(Level.WARNING, "No {0} method in {1} is unambiguously most specific for {2} - {3}; methods: {4}", new Object[]{name, transformType.getName(), contextType.getName(), constructType.getName(), maximallySpecificMethods});
                }
                mostSpecificMethod = null;
            }
        }
        this.mostSpecificMethods.put(key, mostSpecificMethod);
        return mostSpecificMethod;
    }

    private class Sequencer {
        ModelAdapter readModel = null;
        TransformSequenceContext sequenceContext = null;
        String label;
        int applied = 0;

        private Sequencer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean maybeTransition(ModelAdapter newModel) {
            ModelAdapter oldModel = this.readModel;
            if (newModel == oldModel) {
                return false;
            }
            try {
                if (this.sequenceContext != null) {
                    assert (oldModel != null);
                    if (this.applied > 0) {
                        this.sequenceContext.getAdapter().endTransformSequence(this.sequenceContext);
                    } else {
                        this.sequenceContext.getAdapter().cancelTransformSequence(this.sequenceContext);
                    }
                    this.sequenceContext = null;
                }
            }
            catch (Throwable e) {
                AuditLogger.error("exception cancelling transform sequence for {0}: {1}", e, this.label, e);
            }
            finally {
                this.sequenceContext = null;
                if (oldModel != null) {
                    oldModel.endRead();
                }
            }
            if (newModel != null) {
                newModel.beginRead();
            }
            this.readModel = newModel;
            return newModel != null;
        }

        void maybeBeginSequence(TransformContext context) throws Exception {
            assert (context.getModel() == this.readModel);
            TransformAdapter adapter = context.getAdapter();
            if (this.sequenceContext == null || this.sequenceContext.getAdapter().getClass() != adapter.getClass()) {
                if (this.sequenceContext != null) {
                    if (this.applied > 0) {
                        this.sequenceContext.getAdapter().endTransformSequence(this.sequenceContext);
                    } else {
                        this.sequenceContext.getAdapter().cancelTransformSequence(this.sequenceContext);
                    }
                }
                this.sequenceContext = new TransformSequenceContext(adapter, this.readModel);
                this.applied = 0;
                this.label = context.getTransform().label();
                adapter.beginTransformSequence(this.sequenceContext);
            }
        }

        void transformApplied() {
            ++this.applied;
        }
    }

    private class DefaultTransformAction
    extends DefaultTransformsAction {
        private Collection<? extends Violation> violations;
        private AuditModel trackingModel;
        private int applicableTransformCount;
        private Map<String, String> applicableDescriptions;
        private Set<ModelAdapter> applicableDocuments;
        private Set<ModelAdapter> openApplicableDocuments;
        private Map<ModelAdapter, Collection<Violation>> violationsByDocument;
        private List<CodeEditor> openModifiedCodeEditors;
        private Set<ModelAdapter> modifiedDocuments;
        private int appliedTransformCount;

        public DefaultTransformAction(String label, Icon icon, Collection<? extends Violation> violations, Transform transform, TransformerListener listener, AuditModel model) {
            super(label, icon, transform);
            this.violations = violations;
            this.trackingModel = model;
            this.putValue(TransformerListener.class.getName(), listener);
        }

        @Override
        public Throwable apply() {
            IdeMainWindow mainWindow;
            Transform transform = this.getTransform();
            String label = (String)this.getValue("Name");
            LOG.trace("transform {0}", (Object)transform);
            TransformerListener listener = (TransformerListener)this.getValue(TransformerListener.class.getName());
            TransformerQueryInterceptor interceptor = (TransformerQueryInterceptor)this.getValue(TransformerQueryInterceptor.class.getName());
            if (interceptor == null && DefaultTransformer.this.interceptors != null) {
                interceptor = (TransformerQueryInterceptor)DefaultTransformer.this.interceptors.get(transform);
            }
            Throwable exception = this.apply(this.violations, transform, label, listener, interceptor, this.trackingModel);
            if (this.getAppliedTransformCount() == 0 && (mainWindow = Ide.getMainWindow()) != null) {
                mainWindow.getToolkit().beep();
            }
            return exception;
        }

        public void actionPerformed(ActionEvent event) {
            this.apply();
        }

        @Override
        public int getApplicableTransformCount() {
            this.scan(this.violations, this.getTransform());
            return this.applicableTransformCount;
        }

        @Override
        public Collection getTransformDescriptions() {
            this.scan(this.violations, this.getTransform());
            return this.applicableDescriptions.values();
        }

        @Override
        public int getApplicableModelCount() {
            this.scan(this.violations, this.getTransform());
            return this.applicableDocuments.size();
        }

        @Override
        public int getOpenApplicableModelCount() {
            this.scan(this.violations, this.getTransform());
            return this.openApplicableDocuments.size();
        }

        @Override
        public Collection getApplicableModels() {
            this.scan(this.violations, this.getTransform());
            return Collections.unmodifiableSet(this.applicableDocuments);
        }

        @Override
        public int getAppliedTransformCount() {
            return this.appliedTransformCount;
        }

        @Override
        public int getModifiedModelCount() {
            return this.modifiedDocuments.size();
        }

        private void scan(Collection<? extends Violation> violations, Transform transform) {
            EditorManager editorManager;
            if (violations == null) {
                throw new IllegalStateException("no violations set");
            }
            if (this.violationsByDocument != null) {
                return;
            }
            this.applicableTransformCount = 0;
            this.applicableDescriptions = new LinkedHashMap<String, String>();
            this.applicableDocuments = new LinkedHashSet<ModelAdapter>();
            this.openApplicableDocuments = new LinkedHashSet<ModelAdapter>();
            this.violationsByDocument = new LinkedHashMap<ModelAdapter, Collection<Violation>>();
            this.openModifiedCodeEditors = new ArrayList<CodeEditor>();
            LinkedHashSet<Node> openNodes = new LinkedHashSet<Node>();
            if (SwingUtilities.isEventDispatchThread() && (editorManager = EditorManager.getEditorManager()) != null) {
                try {
                    List editors = editorManager.getAllEditors();
                    for (Editor editor : editors) {
                        Node node = editor.getContext().getNode();
                        openNodes.add(node);
                        if (!node.isDirty() || !(editor instanceof CodeEditor)) continue;
                        this.openModifiedCodeEditors.add((CodeEditor)editor);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            LOG.trace("loaded open nodes {0}", openNodes);
            for (Violation violation : violations) {
                TransformContext[] contexts;
                Transform t = transform;
                if (t == null) {
                    t = violation.getDefaultTransform();
                }
                if (t == null || (contexts = DefaultTransformer.this.createContexts(t, violation)).length == 0) continue;
                ++this.applicableTransformCount;
                String name = t.id();
                if (!this.applicableDescriptions.containsKey(name)) {
                    this.applicableDescriptions.put(name, t.boundLabel(contexts[0]));
                }
                ModelAdapter model = contexts[0].getModel();
                assert (model != null);
                ArrayList<Violation> documentViolations = (ArrayList<Violation>)this.violationsByDocument.get(model);
                if (documentViolations == null) {
                    documentViolations = new ArrayList<Violation>();
                    this.violationsByDocument.put(model, documentViolations);
                }
                documentViolations.add(violation);
                for (TransformContext context : contexts) {
                    model = context.getModel();
                    this.applicableDocuments.add(model);
                    if (!openNodes.contains(model.getNode()) && !model.getNode().isDirty()) continue;
                    this.openApplicableDocuments.add(model);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Throwable apply(Collection<? extends Violation> violations, Transform explicitTransform, String label, TransformerListener listener, TransformerQueryInterceptor interceptor, AuditModel trackingModel) {
            this.scan(violations, explicitTransform);
            for (CodeEditor editor : this.openModifiedCodeEditors) {
                BasicEditorPane pane = editor.getFocusedEditorPane();
                if (editor == null) continue;
                pane.invokeAction("cancel");
            }
            Throwable exception = null;
            CommandProcessor processor = CommandProcessor.getInstance();
            TransformEndCommand endCommand = new TransformEndCommand(trackingModel);
            CommandExecutionTracker.commandExecutionTracker().start(label);
            processor.beginTrans(label);
            try {
                this.modifiedDocuments = new LinkedHashSet<ModelAdapter>();
                this.appliedTransformCount = 0;
                block22: for (Collection<Violation> list : this.violationsByDocument.values()) {
                    if (exception != null) break;
                    Sequencer sequencer = new Sequencer();
                    try {
                        block23: for (Violation violation : list) {
                            TransformContext[] contexts;
                            if (exception != null) continue block22;
                            HashMap<ModelAdapter, Dependency> dependencies = new HashMap<ModelAdapter, Dependency>();
                            Transform transform = explicitTransform;
                            if (transform == null && (transform = violation.getDefaultTransform()) == null || (contexts = DefaultTransformer.this.createContexts(transform, violation)).length == 0) continue;
                            try {
                                ModelAdapter model;
                                ModelAdapter model2;
                                Location location;
                                TransformContext context;
                                int k;
                                Method[][] contextMethods = new Method[contexts.length][];
                                Object[] constructs = new Object[contexts.length];
                                for (k = 0; k < contexts.length; ++k) {
                                    Object construct;
                                    Method[] methods;
                                    Dependency dependency;
                                    context = contexts[k];
                                    location = context.getLocation();
                                    model2 = location.getModel();
                                    if (sequencer.maybeTransition(model2)) {
                                        if (!context.getAdapter().isTransformable(context)) {
                                            LOG.trace("not transformable {0}", (Object)location);
                                            continue block23;
                                        }
                                        dependency = model2.getDependency();
                                        dependency.addChangeListener(DefaultTransformer.this.NULL_CHANGE_LISTENER);
                                        dependencies.put(model2, dependency);
                                    } else if (dependencies.isEmpty()) {
                                        dependency = model2.getDependency();
                                        dependency.addChangeListener(DefaultTransformer.this.NULL_CHANGE_LISTENER);
                                        dependencies.put(model2, dependency);
                                    }
                                    if ((methods = (contextMethods[k] = DefaultTransformer.this.methods(context, construct = (constructs[k] = model2.getConstruct(location))))) == null) continue block23;
                                    Method applicableMethod = methods[0];
                                    if (applicableMethod == null) continue;
                                    boolean applicable = DefaultTransformer.this.invokeBoolean(context.getTransform(), applicableMethod, context, construct);
                                    LOG.trace("isApplicable: {1} returned {0}", applicable, (Object)applicableMethod);
                                    if (!applicable) continue block23;
                                }
                                for (k = 0; k < contexts.length; ++k) {
                                    Method interceptorQueryMethod;
                                    context = contexts[k];
                                    location = context.getLocation();
                                    model2 = location.getModel();
                                    Method queryMethod = contextMethods[k][2];
                                    if (queryMethod == null) continue;
                                    Object queryTarget = context.getTransform();
                                    if (interceptor != null && (interceptorQueryMethod = DefaultTransformer.this.method("query", interceptor, context, constructs[k])) != null) {
                                        queryTarget = interceptor;
                                        queryMethod = interceptorQueryMethod;
                                    }
                                    Method queryRequiredMethod = contextMethods[k][1];
                                    boolean queryRequired = true;
                                    if (queryRequiredMethod != null) {
                                        sequencer.maybeTransition(model2);
                                        queryRequired = DefaultTransformer.this.invokeBoolean(context.getTransform(), queryRequiredMethod, context, constructs[k]);
                                    }
                                    LOG.trace("isQueryRequired: {1} returned {0}", queryRequired, (Object)queryRequiredMethod);
                                    if (!queryRequired) continue;
                                    if (!DefaultTransformer.this.queryAllowed) continue block23;
                                    sequencer.maybeTransition(null);
                                    boolean ok = DefaultTransformer.this.invokeBoolean(queryTarget, queryMethod, context, constructs[k]);
                                    LOG.trace("query: {1} ok {0}", ok, (Object)queryMethod);
                                    if (!ok) continue block23;
                                }
                                for (Map.Entry entry : dependencies.entrySet()) {
                                    if (!((Dependency)entry.getValue()).hasChanged()) continue;
                                    throw new ModelChangedException((ModelAdapter)entry.getKey(), (Dependency)entry.getValue());
                                }
                                for (k = 0; k < contexts.length; ++k) {
                                    context = contexts[k];
                                    TransformAdapter adapter = context.getAdapter();
                                    Boolean writable = adapter.makeTransformable(context);
                                    if (writable == null) continue;
                                    if (!writable.booleanValue()) continue block23;
                                    model = context.getModel();
                                    if (listener != null) {
                                        listener.modelWritable(model);
                                    }
                                    if (!((Dependency)dependencies.get(model)).hasChanged()) continue;
                                    Dependency dependency = model.getDependency();
                                    dependency.addChangeListener(DefaultTransformer.this.NULL_CHANGE_LISTENER);
                                    dependencies.put(model, dependency);
                                    constructs[k] = null;
                                    for (int j = k + 1; j < contexts.length; ++j) {
                                        if (contexts[j].getModel() != model) continue;
                                        constructs[j] = null;
                                    }
                                }
                                Object predecessorData = null;
                                for (int k2 = 0; k2 < contexts.length; ++k2) {
                                    TransformContext context2 = contexts[k2];
                                    TransformAdapter adapter = context2.getAdapter();
                                    model = context2.getModel();
                                    sequencer.maybeTransition(model);
                                    if (((Dependency)dependencies.get(model)).hasChanged()) {
                                        throw new ModelChangedException(model, (Dependency)dependencies.get(model));
                                    }
                                    Object reevaluation = model.getConstruct(context2.getLocation());
                                    if (reevaluation == null) {
                                        throw new ModelChangedException(model, (Dependency)dependencies.get(model));
                                    }
                                    if (reevaluation.getClass() != constructs[k2].getClass()) {
                                        constructs[k2] = reevaluation;
                                        contextMethods[k2] = DefaultTransformer.this.methods(contexts[k2], constructs[k2]);
                                    }
                                    adapter.setPredecessorApplyData(context2, predecessorData);
                                    if (explicitTransform != null) {
                                        Location focusLocation = violation.getFocusLocation();
                                        if (focusLocation == null) {
                                            focusLocation = violation.getLocation();
                                        }
                                        focusLocation.getModel().edit(focusLocation);
                                    }
                                    sequencer.maybeBeginSequence(context2);
                                    adapter.beginTransform(context2);
                                    boolean aborting = false;
                                    try {
                                        Method applyMethod = contextMethods[k2][3];
                                        LOG.trace("apply: {0}", (Object)applyMethod);
                                        predecessorData = DefaultTransformer.this.invoke(context2.getTransform(), applyMethod, context2, constructs[k2]);
                                        adapter.endTransform(context2);
                                        Dependency dependency = model.getDependency();
                                        dependency.addChangeListener(DefaultTransformer.this.NULL_CHANGE_LISTENER);
                                        dependencies.put(model, dependency);
                                    }
                                    catch (Throwable e) {
                                        aborting = true;
                                        Throwable cause = e.getCause();
                                        if (cause instanceof CancellationException || cause instanceof InterruptedException) {
                                            throw cause;
                                        }
                                        LOG.trace("exception applying {0} to {1}: {2}", (Object)transform, (Object)violation, (Object)e);
                                        throw e;
                                    }
                                    finally {
                                        if (aborting) {
                                            try {
                                                adapter.cancelTransform(context2);
                                            }
                                            catch (Throwable e) {
                                                Log.error((String)"cancelling {0} failed: {1}", (Object)transform, (Object)e);
                                            }
                                        }
                                    }
                                    List deferredCommands = adapter.getDeferredCommands();
                                    int deferredCommandCount = deferredCommands.size();
                                    if (deferredCommandCount > 0) {
                                        sequencer.maybeTransition(null);
                                    }
                                    for (int m = 0; m < deferredCommandCount; ++m) {
                                        CommandProcessor.getInstance().invoke((Command)deferredCommands.get(m));
                                    }
                                }
                            }
                            catch (Throwable e) {
                                AuditLogger.error("exception applying {0} to {1}: {2}", e, transform, violation, e);
                                sequencer.maybeTransition(null);
                                boolean ok = listener != null && listener.transformFailed(e, violation, transform, label);
                                if (ok || exception != null) continue block22;
                                exception = e;
                                continue block22;
                            }
                            sequencer.transformApplied();
                            ++this.appliedTransformCount;
                            for (TransformContext context : contexts) {
                                this.modifiedDocuments.add(context.getModel());
                            }
                            endCommand.setTransformApplied(transform, violation);
                        }
                    }
                    finally {
                        sequencer.maybeTransition(null);
                    }
                }
                if (exception == null && !this.modifiedDocuments.isEmpty()) {
                    try {
                        endCommand.setContext(this.modifiedDocuments.iterator().next());
                        processor.invoke((Command)endCommand);
                    }
                    catch (Throwable e) {
                        AuditLogger.error("exception invoking transform end command for {0}: {1}", e, e, label);
                    }
                }
            }
            finally {
                if (exception == null && !this.modifiedDocuments.isEmpty()) {
                    processor.endTrans();
                } else {
                    processor.abortTrans();
                }
                CommandExecutionTracker.commandExecutionTracker().end();
            }
            for (ModelAdapter model : this.modifiedDocuments) {
                try {
                    if (!this.openApplicableDocuments.contains(model)) {
                        LOG.trace("saving {0}", (Object)model);
                        model.getNode().save();
                        if (listener == null) continue;
                        listener.modelSaved(model);
                        continue;
                    }
                    LOG.trace("not saving {0}", (Object)model);
                }
                catch (IOException e) {
                    boolean ok = false;
                    if (listener != null) {
                        ok = listener.saveFailed(e, model, label);
                    }
                    if (ok || exception != null) continue;
                    exception = e;
                }
            }
            return exception;
        }
    }

    private static class TransformEndCommand
    extends Command {
        private static final String NAME = "audit-transform-end";
        private static final int CID = Ide.createCmdID((String)"audit-transform-end");
        private WeakReference<AuditModel> model;
        private List<Tuple<Transform, Violation>> appliedTransforms = new ArrayList<Tuple<Transform, Violation>>();

        public TransformEndCommand(AuditModel model) {
            super(CID, 0, NAME);
            this.model = new WeakReference<AuditModel>(model);
        }

        public void setTransformApplied(Transform transform, Violation violation) {
            this.appliedTransforms.add((Tuple<Transform, Violation>)new Tuple((Object)transform, (Object)violation));
        }

        public void setContext(ModelAdapter model) {
            this.setContext(new Context(null, model.getWorkspace(), model.getProject(), model.getNode()));
        }

        public int doit() throws Exception {
            for (Tuple<Transform, Violation> tuple : this.appliedTransforms) {
                Transform transform = (Transform)tuple.object1();
                Violation violation = (Violation)tuple.object2();
                AuditModel model = (AuditModel)this.model.get();
                if (model == null) continue;
                model.setTransformDone(transform, violation);
            }
            return 0;
        }

        public int undo() throws Exception {
            for (Tuple<Transform, Violation> tuple : this.appliedTransforms) {
                Transform transform = (Transform)tuple.object1();
                Violation violation = (Violation)tuple.object2();
                AuditModel model = (AuditModel)this.model.get();
                if (model == null) continue;
                model.setTransformUndone(transform, violation);
            }
            return 0;
        }
    }

    private static class ModelChangedException
    extends Exception {
        private ModelAdapter model;
        private Dependency dependency;

        public ModelChangedException(ModelAdapter model, Dependency dependency) {
            this.model = model;
            this.dependency = dependency;
        }

        public ModelAdapter getModel() {
            return this.model;
        }

        public Dependency getDependency() {
            return this.dependency;
        }
    }
}

