/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import oracle.ide.IdeCore;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.management.Memory;
import oracle.javatools.status.Issue;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.Pair;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.Assist;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.analyzer.ViolationReport;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.model.CompositeDependency;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditListener;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.CountColumn;
import oracle.jdevimpl.audit.core.DefaultAuditContext;
import oracle.jdevimpl.audit.core.DefaultAuditTaskContext;
import oracle.jdevimpl.audit.core.InternalCategory;
import oracle.jdevimpl.audit.core.ProfileBinding;
import oracle.jdevimpl.audit.core.SeverityColumn;
import oracle.jdevimpl.audit.util.Strings;

public final class DefaultAuditor
extends Auditor
implements Runnable {
    private static final boolean PRESENT_ALL = Boolean.getBoolean("audit.present.all");
    private static final String SHOW_COUNTS = System.getProperty("audit.show.issue.counts");
    private static final Set<String> analyzerExcludes;
    private static final Log LOG;
    private static final Log LOG_CANCEL;
    private static final Log LOG_HEAP;
    private static final Log MEMORY_STATISTICS;
    private static final Log ANALYZER_STATISTICS;
    private static final Log SUPPRESS_INTERNAL;
    private static final FormatBundle BUNDLE;
    private ModelTypeFactory typeFactory;
    private Set<ModelType> modelTypes = new HashSet<ModelType>();
    private List<Class> typeList = new ArrayList<Class>();
    private Map<Class, Class> typeMap = new LinkedHashMap<Class, Class>();
    private Map<Object, Object> configurationAttributes = new HashMap<Object, Object>();
    private ModelFactory modelFactory;
    private List<Location> locations = new ArrayList<Location>();
    private CompositeDependency dependenciesCollector;
    private Profile profile;
    private ProfileBinding binding;
    private List<AuditContext> contexts = new ArrayList<AuditContext>();
    private volatile boolean auditing;
    private long maximumFileSize;
    private WorkingSet workingSet;
    private boolean ignoreAssists = false;
    private WriteLockRequestListener writeLockRequestListener;
    private boolean visitDescendants = true;
    private boolean visitAncestors = true;
    private CopyOnWriteArrayList<AuditListener> listeners = new CopyOnWriteArrayList();
    private volatile int runCount;
    private volatile boolean cancelled = false;
    private Throwable cancellationTrace;
    private final Object stateLock = new Object();
    private boolean analyzersCancellable = false;
    private ModelAdapter modelToCancel;
    private ModelAdapter activeModel;
    private NodeListener closeNodeListener = new NodeListener(){

        public void nodeWillClose(NodeEvent e) {
            LOG.trace("ancestor node will close: {0}", (Object)e);
            Node node = e.getNode();
            if (node instanceof Workspace || node instanceof Project) {
                DefaultAuditor.this.cancel();
            } else {
                Log.error((String)"{0} closed during traversal", (Object)node, (Object)new Throwable(node.getShortLabel()));
            }
        }
    };
    private AuditELContext expressionContext = new AuditELContext();
    private ViolationReporter violationReporter = new ViolationReporter();
    private MultiMap<Class<? extends ModelType>, Location> fragments;
    private Set<Issue> optionalAnalyses = new HashSet<Issue>();
    private Rule errorRule;

    public DefaultAuditor(ModelTypeFactory factory) {
        this.typeFactory = factory;
        this.maximumFileSize = (long)(AuditManager.getAuditManager().getPreferences().getMaximumFileSize() * 1000000.0f);
        this.modelFactory = this.createModelFactory();
    }

    private ModelFactory createModelFactory() {
        ModelFactory factory = this.typeFactory.createModelFactory(this.configurationAttributes);
        factory.setWorkingSet(this.getWorkingSet());
        factory.setMaximumFileSize(this.getMaximumFileSize());
        return factory;
    }

    @Override
    public void addAuditListener(AuditListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeAuditListener(AuditListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isAuditableType(Element element) {
        return !this.modelFactory.getModelTypeFactory().getModelTypes(element).isEmpty();
    }

    @Override
    public boolean isAuditable(Element element, Node node, Project project, Workspace workspace) {
        return !this.getModelAdapters(element, node, project, workspace).isEmpty();
    }

    @Override
    public boolean cancel() {
        return this.cancel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancel(Throwable cause) {
        boolean alreadyCancelled;
        boolean auditing;
        Object object = this.stateLock;
        synchronized (object) {
            auditing = this.auditing;
            alreadyCancelled = this.cancelled;
            if (!alreadyCancelled) {
                this.cancelled = true;
                if (cause == null) {
                    LOG_CANCEL.trace("cancel requested: {0}", (Object)this.cancellationTrace);
                    this.cancellationTrace = new Throwable("cancellation cause");
                } else {
                    this.cancellationTrace = cause;
                }
            }
        }
        if (!alreadyCancelled) {
            if (cause instanceof OutOfMemoryError) {
                String path = this.dumpHeap("audit-oome");
                System.err.println("Heap snapshot: " + path);
            }
            if (this.modelToCancel != null) {
                this.modelToCancel.cancelRead();
            }
            if (this.analyzersCancellable) {
                this.binding.cancelAnalyzers();
            }
        }
        return auditing && alreadyCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void throwIfCancelled() {
        if (this.cancelled) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.cancelled) {
                    LOG_CANCEL.trace("cancel processed: {0}", (Object)this.cancellationTrace);
                    CancellationException cancellation = new CancellationException();
                    cancellation.initCause(this.cancellationTrace);
                    throw cancellation;
                }
            }
        }
    }

    @Override
    public void clear() {
        LOG.trace("clearing locations");
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        this.locations = new ArrayList<Location>();
        this.dependenciesCollector = null;
        this.fireAuditorCleared();
        this.modelFactory.close();
        this.modelFactory = this.createModelFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addElement(Element element, Node node, Project project, Workspace workspace) {
        Collection<ModelAdapter> models = this.getModelAdapters(element, node, project, workspace);
        if (models.isEmpty()) {
            return false;
        }
        boolean added = false;
        for (ModelAdapter model : models) {
            model.beginRead();
            try {
                Location[] locations = model.getElementLocations(element);
                LOG.trace("found locations {0} for {1}", (Object)locations, (Object)model);
                if (locations == null || locations.length <= 0) continue;
                for (Location location : locations) {
                    this.addLocation(location);
                }
                added = true;
            }
            finally {
                model.endRead();
            }
        }
        return added;
    }

    private Collection<ModelAdapter> getModelAdapters(Element element, Node node, Project project, Workspace workspace) {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        Collection<ModelAdapter> models = this.modelFactory.getModelAdapters(element, node != null ? node.getURL() : null, project, workspace);
        LOG.trace("found adapters {0} for {1}", models, (Object)node);
        return models;
    }

    @Override
    public boolean addElements(Element[] elements, Node node, Project project, Workspace workspace) {
        boolean added = false;
        for (Element element : elements) {
            if (!this.addElement(element, node, project, workspace)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public boolean addNode(Node node, Project project, Workspace workspace) {
        if (node == null) {
            throw new IllegalArgumentException("null document");
        }
        return this.addElement((Element)node, node, project, workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addConstruct(Object construct, URL file, Project project, Workspace workspace) {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        if (construct == null) {
            return false;
        }
        Collection<ModelAdapter> models = this.modelFactory.getModelAdapters(null, file, project, workspace);
        boolean added = false;
        for (ModelAdapter model : models) {
            model.beginRead();
            try {
                Location location = model.getLocation(construct);
                if (location == null) continue;
                this.addLocation(location);
                added = true;
            }
            finally {
                model.endRead();
            }
        }
        return added;
    }

    @Override
    public boolean isAuditableType(URL url) {
        if (URLFileSystem.isRegularFile((URL)url)) {
            try {
                return !this.modelFactory.getModelTypeFactory().getModelTypes((Element)NodeFactory.findOrCreate((URL)url)).isEmpty();
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InstantiationException e) {
                return false;
            }
        }
        return URLFileSystem.isDirectoryPath((URL)url) || URLFileSystem.isDirectory((URL)url);
    }

    @Override
    public boolean addUrl(URL document, Project project, Workspace workspace) {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        if (document == null || workspace == null) {
            return false;
        }
        Collection<ModelAdapter> models = this.modelFactory.getModelAdapters(null, document, project, workspace);
        for (ModelAdapter model : models) {
            this.addLocation(model.getLocation());
        }
        return !models.isEmpty();
    }

    protected void addLocation(Location location) {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        this.addLocation(location, this.locations);
    }

    private void addLocation(Location location, List<Location> locations) {
        Location successor;
        int predecessorIndex;
        Location predecessor;
        LOG.trace("adding {0} to {1}", (Object)location, locations);
        if (locations.isEmpty()) {
            LOG.trace("adding initial location {0}", (Object)location);
            locations.add(location);
            return;
        }
        int index = -Collections.binarySearch(locations, location) - 1;
        if (index < 0) {
            return;
        }
        if (index > 0 && (predecessor = locations.get(predecessorIndex = index - 1)).contains(location)) {
            LOG.trace("ignoring {0} for {1}", (Object)location, (Object)predecessor);
            return;
        }
        if (index < locations.size() && location.contains(successor = locations.get(index))) {
            LOG.trace("replacing {0} into {1}", (Object)location, (Object)successor);
            locations.set(index, location);
            return;
        }
        locations.add(index, location);
        LOG.trace("adding {0}", (Object)location);
    }

    @Override
    public ModelFactory getFactory() {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        return this.modelFactory;
    }

    public ProfileBinding getBinding() {
        return this.binding;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("profile == null");
        }
        this.profile = profile;
        this.binding = new ProfileBinding(profile);
    }

    @Override
    public void setAttribute(Object key, Object value) {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        this.configurationAttributes.put(key, value);
    }

    @Override
    public boolean isAuditing() {
        return this.auditing;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public long getMaximumFileSize() {
        return this.maximumFileSize;
    }

    @Override
    public void setMaximumFileSize(long size) {
        this.maximumFileSize = size;
        this.modelFactory.setMaximumFileSize(size);
    }

    @Override
    public void setWorkingSet(WorkingSet workingSet) {
        this.workingSet = workingSet;
        this.modelFactory.setWorkingSet(workingSet);
    }

    @Override
    public WorkingSet getWorkingSet() {
        return this.workingSet;
    }

    @Override
    public void setIgnoreAssists(boolean ignore) {
        this.ignoreAssists = ignore;
    }

    @Override
    public boolean isIgnoreAssists() {
        return this.ignoreAssists;
    }

    @Override
    public void setWriteLockRequestListener(WriteLockRequestListener listener) {
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        this.writeLockRequestListener = listener;
    }

    @Override
    public void setDependencyCollector(CompositeDependency collector) {
        this.dependenciesCollector = collector;
    }

    @Override
    public void setVisitDescendants(boolean shallow) {
        this.visitDescendants = shallow;
    }

    @Override
    public boolean isVisitDescendants() {
        return this.visitDescendants;
    }

    @Override
    public void setVisitAncestors(boolean shallow) {
        this.visitAncestors = shallow;
    }

    @Override
    public boolean isVisitAncestors() {
        return this.visitAncestors;
    }

    @Override
    public void run() {
        try {
            this.audit();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    public void runAsynchronously() {
        this.runAsynchronously(null);
    }

    @Override
    public synchronized void runAsynchronously(Thread.UncaughtExceptionHandler handler) {
        LOG.trace("invoking audit asynchronously");
        if (this.auditing) {
            throw new IllegalStateException("Auditor already auditing");
        }
        Thread thread = new Thread((Runnable)this, "audit-thread-" + this.runCount);
        thread.setPriority(Math.max(thread.getPriority() - 1, 1));
        if (handler == null) {
            handler = new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof CancellationException)) {
                        AuditLogger.error("Unexpected exception while auditing: {0}", e, e);
                    }
                }
            };
        }
        thread.setUncaughtExceptionHandler(handler);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit() {
        if (this.profile == null) {
            throw new IllegalStateException("profile not set");
        }
        if (this.locations.isEmpty()) {
            throw new IllegalStateException("no locations added");
        }
        LOG.trace("auditing {0} with {1}", this.locations, (Object)this.profile);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.auditing) {
                throw new IllegalStateException("Auditor already auditing");
            }
            this.auditing = true;
            this.cancelled = false;
            this.cancellationTrace = null;
        }
        IdeCore.setActiveWorkspaceOverrideEnabled((boolean)true);
        try {
            List<Location> locations;
            ModelAdapter rootModel;
            ModelFactory modelFactory;
            if (this.runCount++ == 0) {
                modelFactory = this.modelFactory;
                rootModel = modelFactory.getModelRoot().getModel();
                locations = this.locations;
            } else {
                long start = System.currentTimeMillis();
                ModelFactory oldModelFactory = this.modelFactory;
                List<Location> oldLocations = this.locations;
                modelFactory = this.createModelFactory();
                locations = new ArrayList<Location>(oldLocations.size());
                for (Location oldLocation : oldLocations) {
                    ModelAdapter oldModel = oldLocation.getModel();
                    assert (oldModel.getFactory() == oldModelFactory);
                    assert (oldModel.getFactory() != modelFactory);
                    Collection<ModelAdapter> newModels = modelFactory.getModelAdapters(oldModel.getElement(), oldModel.getUrl(), oldModel.getProject(), oldModel.getWorkspace());
                    for (ModelAdapter newModel : newModels) {
                        assert (newModel.getFactory() == modelFactory);
                        Location newLocation = oldLocation.isRoot() ? newModel.getLocation() : newModel.getLocation(oldLocation.getOffset(), oldLocation.getLength());
                        this.addLocation(newLocation, locations);
                    }
                }
                if (locations.isEmpty()) {
                    throw new IllegalStateException("no locations valid ");
                }
                oldModelFactory.close();
                this.modelFactory = modelFactory;
                rootModel = modelFactory.getModelRoot().getModel();
                this.locations = locations;
                LOG.trace("recreated locations in {0} ms", System.currentTimeMillis() - start);
            }
            Location ancestor = locations.get(0);
            ModelAdapter ancestorModel = ancestor.getModel();
            Object ancestorConstruct = null;
            for (Location location : locations) {
                boolean added;
                ContainerModelAdapter parent;
                ModelAdapter model = location.getModel();
                if (!ancestor.contains(location)) {
                    if (model == ancestorModel) {
                        int begin = Math.min(location.getOffset(), ancestor.getOffset());
                        int end = Math.max(location.getEndOffset(), ancestor.getEndOffset());
                        ancestorModel.beginRead();
                        try {
                            ancestorConstruct = model.getConstruct(model.getLocation(begin, end));
                            ancestor = model.getLocation(ancestorConstruct);
                        }
                        finally {
                            ancestorModel.endRead();
                        }
                    } else {
                        ancestorModel = ancestorModel.getContainingAdapter();
                        while (!ancestorModel.contains(model)) {
                            ancestorModel = ancestorModel.getContainingAdapter();
                        }
                        ancestor = ancestorModel.getLocation();
                        ancestorConstruct = null;
                    }
                }
                while ((parent = model.getContainingAdapter()) != null && (added = parent.addContainedModel(model))) {
                    model = parent;
                }
            }
            LOG.trace("found common ancestor {0}", (Object)ancestor);
            this.throwIfCancelled();
            this.optionalAnalyses = new HashSet<Issue>();
            this.throwIfCancelled();
            boolean firedAuditStarted = false;
            try {
                DefaultAuditContext context = new DefaultAuditContext(this, null);
                if (this.configurationAttributes != null) {
                    for (Map.Entry<Object, Object> entry : this.configurationAttributes.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        context.setAttribute(context.sharedKey(key), value);
                    }
                }
                this.contexts.add(context);
                this.throwIfCancelled();
                long start = System.currentTimeMillis();
                ArrayList<Metric> metrics = new ArrayList<Metric>();
                int rules = 0;
                Map<Analyzer, Collection<ExtensionBean>> instances = this.binding.createInstances();
                for (Map.Entry<Analyzer, Collection<ExtensionBean>> entry : instances.entrySet()) {
                    boolean enabled = false;
                    Analyzer analyzer = entry.getKey();
                    if (!analyzerExcludes.contains(analyzer.getClass().getName())) {
                        Collection<ExtensionBean> beans = entry.getValue();
                        for (ExtensionBean bean : beans) {
                            Rule rule;
                            if (bean instanceof Metric) {
                                Metric metric = (Metric)bean;
                                if (!metric.isEnabled()) continue;
                                enabled = true;
                                metrics.add(metric);
                                continue;
                            }
                            if (bean instanceof Assist) {
                                Assist assist = (Assist)bean;
                                if (this.ignoreAssists) {
                                    assist.setEnabled(false);
                                    continue;
                                }
                                if (!assist.isEnabled()) continue;
                                enabled = true;
                                continue;
                            }
                            if (!(bean instanceof Rule) || !(rule = (Rule)bean).isEnabled()) continue;
                            enabled = true;
                            ++rules;
                        }
                    }
                    analyzer.setEnabled(enabled);
                }
                if (rules > 0) {
                    SeverityColumn severityColumn = new SeverityColumn();
                    severityColumn.setEnabled(true);
                    metrics.add(severityColumn);
                    if (SHOW_COUNTS != null) {
                        CountColumn visibleIssuesColumn = new CountColumn(AuditModel.Count.VISIBLE_ISSUES);
                        visibleIssuesColumn.setEnabled(true);
                        metrics.add(visibleIssuesColumn);
                        if (SHOW_COUNTS.equalsIgnoreCase("all")) {
                            CountColumn issuesColumn = new CountColumn(AuditModel.Count.ISSUES);
                            issuesColumn.setEnabled(true);
                            metrics.add(issuesColumn);
                        }
                    }
                }
                if (ANALYZER_STATISTICS.isEnabled()) {
                    int count = 0;
                    String EOL = System.getProperty("line.separator");
                    StringBuilder builder = new StringBuilder(EOL);
                    Collection<Analyzer> analyzers = this.binding.getAnalyzers();
                    for (Analyzer analyzer : analyzers) {
                        builder.append("  ");
                        if (analyzer.isEnabled()) {
                            ++count;
                        } else {
                            builder.append("-");
                        }
                        String name = analyzer.getClass().getName();
                        int dot = name.lastIndexOf(46);
                        builder.append(name, dot + 1, name.length());
                        builder.append(" (");
                        builder.append(name, 0, Math.max(dot, 0));
                        builder.append(")");
                        builder.append(EOL);
                    }
                    ANALYZER_STATISTICS.trace("Profile bound in {0} ms, {1} analyzers (of {2}) enabled:{3}", (Object)(System.currentTimeMillis() - start), (Object)count, (Object)analyzers.size(), (Object)builder);
                }
                this.throwIfCancelled();
                if (ancestorConstruct == null) {
                    ancestorModel.beginRead();
                    try {
                        ancestorConstruct = ancestorModel.getConstruct(ancestor);
                    }
                    finally {
                        ancestorModel.endRead();
                    }
                }
                this.fireAuditStarted(metrics, locations, ancestor, ancestorConstruct.getClass());
                firedAuditStarted = true;
                this.throwIfCancelled();
                DefaultAuditor count = this;
                synchronized (count) {
                    this.analyzersCancellable = true;
                }
                start = System.currentTimeMillis();
                assert (rootModel.getFactory() == ancestor.getModel().getFactory());
                this.audit(context, null, rootModel, ancestor, false, true);
                count = this;
                synchronized (count) {
                    this.analyzersCancellable = false;
                }
                this.printRunningStatistics("completed traversals", new Object[0]);
                this.printMethodStatistics();
                List<Pair<Class<? extends Analyzer>, Method>> methods = this.binding.getStartTaskMethods();
                Object[] arguments = new Object[1];
                int count2 = 0;
                LinkedBlockingQueue<Violation> queue = new LinkedBlockingQueue<Violation>();
                for (Pair pair : methods) {
                    Analyzer analyzer = this.binding.getAnalyzer((Class)pair.getFirst());
                    arguments[0] = new DefaultAuditTaskContext(this, analyzer, modelFactory, queue);
                    Object started = ((Method)pair.getSecond()).invoke((Object)analyzer, arguments);
                    if (!Boolean.TRUE.equals(started)) continue;
                    ++count2;
                }
                if (count2 > 0) {
                    this.firePhaseStarted(BUNDLE.get("phase.background.label"));
                }
                while (count2 > 0) {
                    Violation violation = (Violation)queue.take();
                    if (violation == null) {
                        --count2;
                        continue;
                    }
                    this.fireViolationReported(violation, 0);
                }
            }
            catch (ExpiredTextBufferException e) {
                this.cancel(e);
                this.throwIfCancelled();
            }
            catch (CancellationException e) {
                this.cancel(e);
                throw e;
            }
            catch (OutOfMemoryError e) {
                this.cancel(e);
                throw e;
            }
            catch (Throwable e) {
                this.cancel(e);
                throw new UnexpectedExceptionError(e);
            }
            finally {
                if (firedAuditStarted) {
                    this.fireAuditStopped(this.cancelled);
                }
                if (this.binding != null) {
                    this.binding.clear();
                }
                this.contexts.clear();
            }
            this.printRunningStatistics("completed audit", new Object[0]);
        }
        finally {
            object = this.stateLock;
            synchronized (object) {
                this.cancelled = false;
                this.cancellationTrace = null;
                this.auditing = false;
            }
            IdeCore.setActiveWorkspaceOverrideEnabled((boolean)false);
        }
    }

    @Override
    public Collection<Issue> getOptionalAnalyses() {
        return this.optionalAnalyses;
    }

    @Override
    public Throwable applyDefaultTransforms(String label) {
        AuditManager manager = AuditManager.getAuditManager();
        AuditModel model = manager.createModel();
        this.addAuditListener(model);
        this.run();
        Transformer transformer = manager.createTransformer();
        return transformer.applyDefaultTransforms(label, model, new Object[]{model.getRoot()}, null);
    }

    /*
     * Exception decompiling
     */
    private void audit(DefaultAuditContext context, ModelAdapter model, Object construct, Location root, boolean visible, boolean ancestor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void audit(DefaultAuditContext context, ModelAdapter model, Object construct) {
        Location location;
        LOG.trace("auditing {0} in {1} (invisible)", construct, (Object)model);
        this.throwIfCancelled();
        Class type = this.getPresentationType(model, construct);
        if (PRESENT_ALL || type != null) {
            location = model.getLocation(construct);
            this.fireLocationEntered(location, type);
        } else {
            location = null;
        }
        context.setContext(location, construct);
        try {
            ProfileBinding.Invoker invoker = this.binding.getInvoker(construct.getClass());
            invoker.enter(context);
            DefaultAuditContext childContext = this.createChildContext(context);
            try {
                Iterator iterator = model.getContainedConstructs(construct);
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (child == null) {
                        AuditLogger.error("null contained construct in {0}", context);
                        continue;
                    }
                    this.audit(childContext, model, child);
                    this.throwIfCancelled();
                }
            }
            catch (ExpiredTextBufferException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                this.report(context, construct, e);
            }
            invoker.exit(context);
        }
        catch (ExpiredTextBufferException e) {
            this.cancel(e);
            throw e;
        }
        catch (CancellationException e) {
            this.cancel(e);
            throw e;
        }
        catch (OutOfMemoryError e) {
            this.cancel(e);
            throw e;
        }
        catch (Throwable e) {
            this.report(context, construct, e);
        }
        finally {
            this.endReport();
            context.clearContext();
        }
        if (type != null) {
            this.fireLocationExited(location);
        }
        LOG.trace("completed auditing model {0} construct {1}", (Object)model, construct);
    }

    private DefaultAuditContext createChildContext(DefaultAuditContext parent) {
        int depth = parent.getDepth() + 1;
        if (depth < this.contexts.size()) {
            return (DefaultAuditContext)this.contexts.get(depth);
        }
        DefaultAuditContext context = new DefaultAuditContext(this, parent);
        this.contexts.add(context);
        return context;
    }

    private Class getPresentationType(ModelAdapter model, Object construct) {
        Class<?> constructType;
        Class type;
        Collection<Class<?>> presentationTypes;
        ModelType modelType = model.getType();
        if (this.modelTypes.add(modelType) && (presentationTypes = modelType.getPresentationTypes()) != null) {
            for (Class<?> type2 : presentationTypes) {
                this.typeList.add(type2);
                this.typeMap.put(type2, type2);
            }
        }
        if ((type = this.typeMap.get(constructType = construct.getClass())) != null) {
            if (type == Object.class) {
                return null;
            }
            return type;
        }
        for (Class t : this.typeList) {
            if (!t.isInstance(construct)) continue;
            this.typeMap.put(constructType, t);
            return t;
        }
        this.typeMap.put(constructType, Object.class);
        return null;
    }

    void produceFragment(Class<? extends ModelType> fragmentType, Location location) {
        if (location.getLength() <= 0) {
            LOG.trace("zero length {0} fragment at {1}", fragmentType, (Object)location);
            return;
        }
        if (this.fragments == null) {
            this.fragments = new MultiMap();
        }
        this.fragments.add(fragmentType, (Object)location);
        LOG.trace("added {0} fragment at {1}", fragmentType, (Object)location);
    }

    private void report(AuditContext context, Object construct, Throwable exception) {
        Location location = context.getLocation();
        if (exception instanceof InvocationTargetException) {
            exception = exception.getCause();
        }
        if (!SUPPRESS_INTERNAL.isEnabled()) {
            AuditLogger.error("exception traversing {0}{1}{2}", exception, construct, Strings.LINE_SEPARATOR, location.getModel().contextDescription(location));
        }
        if (this.errorRule == null) {
            Localizer LOCALIZER = Localizer.instance(CoreBundle.class);
            this.errorRule = new Rule("traversal-exception", new InternalCategory(), Severity.ERROR, LOCALIZER);
            this.errorRule.setEnabled(true);
        }
        ViolationReport report = context.report(this.errorRule, location);
        report.addParameter("exception", exception.getClass().getSimpleName());
        StackTraceElement[] trace = exception.getStackTrace();
        if (trace.length > 0) {
            report.addParameter("method", trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber());
        } else {
            report.addParameter("method", "?");
        }
    }

    public void addDependency(Dependency dependency) {
        if (this.dependenciesCollector != null) {
            this.dependenciesCollector.addDependency(dependency);
        }
    }

    public void addOptionalAnalysis(Issue issue) {
        this.optionalAnalyses.add(issue);
    }

    public ViolationReport report(AuditContext context, Rule rule, Location location, Object construct) {
        return this.violationReporter.report(context, rule, location, construct);
    }

    public void endReport() {
        this.violationReporter.endReport();
    }

    public void cancelReport() {
        this.violationReporter.cancelReport();
    }

    public void report(Metric metric, Location location, Object measurement) {
        if (location == null) {
            throw new IllegalArgumentException("location == null");
        }
        if (!metric.isEnabled()) {
            return;
        }
        this.fireValueReported(location, metric, measurement);
    }

    private void fireAuditStarted(List<Metric> columns, List<Location> locations, Location root, Class type) {
        LOG.trace("**** firing audit started at {0}", (Object)root);
        for (AuditListener listener : this.listeners) {
            listener.auditStarted(this, columns, locations, root, type);
        }
        LOG.trace("completed firing audit started");
    }

    private void fireAuditStopped(boolean cancelled) {
        LOG.trace("**** firing audit stopped, cancelled {0}", cancelled);
        for (AuditListener listener : this.listeners) {
            listener.auditStopped(this, cancelled);
        }
        LOG.trace("completed firing audit stopped, cancelled {0}", cancelled);
    }

    private void firePhaseStarted(String phaseName) {
        LOG.trace("**** firing phase {0} started", (Object)phaseName);
        for (AuditListener listener : this.listeners) {
            listener.phaseStarted(this, phaseName);
        }
        LOG.trace("completed firing phase {0} started", (Object)phaseName);
    }

    private void fireDocumentStarted(ModelAdapter model) {
        LOG.trace("**** firing model {0} started", (Object)model);
        for (AuditListener listener : this.listeners) {
            listener.modelEntered(this, model);
        }
        LOG.trace("completed firing model {0} started", (Object)model);
    }

    private void printRunningStatistics(String message, Object ... arguments) {
        if (MEMORY_STATISTICS.isEnabled()) {
            String EOL = System.getProperty("line.separator");
            StringBuilder openNodes = new StringBuilder(EOL);
            Iterator i = NodeFactory.getOpenNodes();
            while (i.hasNext()) {
                openNodes.append("  ");
                openNodes.append(((Node)i.next()).getLongLabel());
                openNodes.append(EOL);
            }
            MEMORY_STATISTICS.trace("{0}: {1} nodes, {2} open nodes:{3}{4}{5}", new Object[]{Log.format((String)message, (Object[])arguments), NodeFactory.getCachedNodeCount(), NodeFactory.getOpenNodeCount(), openNodes, Memory.summary(), EOL});
        }
    }

    private void printMethodStatistics() {
        if (ANALYZER_STATISTICS.isEnabled()) {
            ANALYZER_STATISTICS.trace("{1}Method Statistics{1}{0}{1}", (Object)this.binding.statistics(), (Object)System.getProperty("line.separator"));
        }
    }

    private String dumpHeap(String name) {
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        File file = new File(tmpdir, name + "-" + String.valueOf(System.currentTimeMillis() - Log.TIME_ZERO_MILLI) + ".hprof");
        String path = file.getAbsolutePath();
        Memory.dumpHeap((String)path, (boolean)true);
        return path;
    }

    private void fireDocumentStopped(ModelAdapter model) {
        LOG.trace("**** firing model {0} stopped", (Object)model);
        for (AuditListener listener : this.listeners) {
            listener.modelExited(this, model);
        }
        LOG.trace("completed firing model {0} stopped", (Object)model);
    }

    private void fireLocationEntered(Location location, Class type) {
        LOG.trace("**** firing {0} entered, type {1}", (Object)location, (Object)type);
        for (AuditListener listener : this.listeners) {
            listener.locationEntered(this, location, type);
        }
        LOG.trace("completed firing {0} entered", (Object)location, (Object)type);
    }

    private void fireLocationExited(Location location) {
        LOG.trace("**** firing {0} exited", (Object)location);
        for (AuditListener listener : this.listeners) {
            listener.locationExited(this, location);
        }
        LOG.trace("completed firing {0} exited", (Object)location);
    }

    private void fireViolationReported(Violation violation, int transformMask) {
        for (AuditListener listener : this.listeners) {
            listener.issueReported(this, violation, transformMask);
        }
    }

    private void fireValueReported(Location location, Metric metric, Object newValue) {
        LOG.trace("firing {1} value {2} reported at {0)", (Object)location, (Object)metric, newValue);
        for (AuditListener listener : this.listeners) {
            listener.valueReported(this, location, metric, newValue);
        }
        LOG.trace("completed firing {1} value {2} reported at {0)", (Object)location, (Object)metric, newValue);
    }

    private void fireAuditorCleared() {
        LOG.trace("firing auditor cleared");
        for (AuditListener listener : this.listeners) {
            listener.auditorCleared(this);
        }
        LOG.trace("completed firing auditor cleared");
    }

    static {
        String text = System.getProperty("audit.analyzer.excludes");
        analyzerExcludes = text != null ? new HashSet<String>(Strings.tokens(text, ',')) : Collections.emptySet();
        LOG = new Log("auditor");
        LOG_CANCEL = new Log("auditor-cancel", "auditor");
        LOG_HEAP = new Log("auditor-heap");
        MEMORY_STATISTICS = new Log("memory-statistics", "log");
        ANALYZER_STATISTICS = new Log("statistics", "log");
        SUPPRESS_INTERNAL = new Log("suppress-internal");
        BUNDLE = new FormatBundle(CoreBundle.class);
    }

    private class ViolationReporter
    implements ViolationReport,
    Violation {
        private ModelAdapter activeModel;
        private ModelAdapter model;
        private Rule rule;
        private String variation;
        private Location location;
        private Object construct;
        private Location focusLocation;
        private int parameterCount;
        private String[] parameterNames = new String[256];
        private Object[] parameterValues = new Object[256];
        private int transformMask;
        private int transformFocusLocationMask;
        private Location[] transformFocusLocations = new Location[15];
        private Transform defaultTransform;

        private ViolationReporter() {
        }

        public ViolationReport report(AuditContext context, Rule rule, Location location, Object construct) {
            this.endReport();
            this.activeModel = context.getModel();
            this.model = location.getModel();
            this.rule = rule;
            this.variation = null;
            this.location = location;
            this.construct = construct;
            this.focusLocation = null;
            this.parameterCount = 0;
            this.transformMask = (1 << rule.getTransforms().length) - 1;
            this.transformFocusLocationMask = 0;
            this.defaultTransform = rule.getDefaultTransform();
            return this;
        }

        public void report(Metric metric, Location location, Object measurement) {
            if (location == null) {
                throw new IllegalArgumentException("location == null");
            }
            if (!metric.isEnabled()) {
                return;
            }
            DefaultAuditor.this.fireValueReported(location, metric, measurement);
        }

        public void endReport() {
            if (this.rule == null) {
                return;
            }
            if (this.rule.declarative()) {
                Object value;
                for (Rule.Parameter parameter : this.rule.parameters()) {
                    boolean found = false;
                    String requiredName = parameter.getName();
                    for (int i = 0; i < this.parameterCount; ++i) {
                        if (!requiredName.equals(this.parameterNames[i])) continue;
                        found = true;
                        value = this.parameterValues[i];
                        if (value == null) {
                            this.rule.logWarning("Parameter ''{0}'' null", requiredName);
                            break;
                        }
                        if (parameter.getType().isInstance(value)) break;
                        this.rule.logError("Parameter ''{0}'' type ''{1}'' not convertable to expected type ''{2}''", requiredName, value.getClass().getName(), parameter.getType().getName());
                        break;
                    }
                    if (found || !parameter.isRequired()) continue;
                    this.rule.logError("Required parameter ''{0}'' not added", requiredName);
                }
                Transform[] transforms = this.rule.getTransforms();
                for (int i = 0; i < transforms.length; ++i) {
                    DeferredExpression condition;
                    boolean applicable = true;
                    Transform transform = transforms[i];
                    DefaultAuditor.this.expressionContext.setBean(transform, this.rule, this);
                    for (Map.Entry<String, DeferredSetter> entry : transform.setters().entrySet()) {
                        DeferredSetter setter = entry.getValue();
                        try {
                            value = setter.set(transform, DefaultAuditor.this.expressionContext);
                            if (!setter.isRequired() || value != null) continue;
                            applicable = false;
                            break;
                        }
                        catch (Throwable e) {
                            setter.log("property ''{0}'' of ''{1}'' not set to \"{2}\": {3}", entry.getKey(), transform, setter.getText(), e);
                        }
                    }
                    if (applicable && (condition = transform.condition()) != null) {
                        try {
                            applicable = (Boolean)condition.evaluate(DefaultAuditor.this.expressionContext);
                        }
                        catch (Exception e) {
                            applicable = false;
                            condition.log("condition \"{0}\" failed: {1}", condition.getText(), e);
                        }
                    }
                    if (applicable) continue;
                    this.transformMask &= ~(1 << i);
                }
            }
            LOG.trace("firing {0} reported at {1}", (Object)this.rule, (Object)this.location);
            DefaultAuditor.this.fireViolationReported(this, this.transformMask);
            LOG.trace("completed firing {0} violation reported at {1}", (Object)this.rule, (Object)this.location);
            this.clear();
        }

        public void cancelReport() {
            LOG.trace("cancelling report {0} reported at {1}", (Object)this.rule, (Object)this.location);
            this.clear();
        }

        private void clear() {
            int i;
            this.rule = null;
            this.construct = null;
            this.location = null;
            this.model = null;
            this.activeModel = null;
            this.focusLocation = null;
            this.defaultTransform = null;
            if (this.transformFocusLocationMask != 0) {
                for (i = 0; i < this.transformFocusLocations.length; ++i) {
                    this.transformFocusLocations[i] = null;
                }
            }
            for (i = 0; i < this.parameterCount; ++i) {
                this.parameterValues[i] = null;
            }
        }

        @Override
        public void addParameter(String name, Object value) {
            Location location = this.model.getLocation(value);
            if (location == null) {
                this.parameterNames[this.parameterCount] = name;
                this.parameterValues[this.parameterCount++] = value;
            } else if (!DefaultAuditor.this.typeMap.containsKey(value.getClass())) {
                this.parameterNames[this.parameterCount] = name;
                this.parameterValues[this.parameterCount++] = location;
            } else {
                throw new IllegalArgumentException("Type " + value.getClass() + " of " + name + " parameter is a construct.");
            }
        }

        @Override
        public void addConstructParameter(String name, Object construct) {
            this.addParameter(name, this.model.getLocation(construct));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConstructParameter(String name, ModelAdapter model, Object construct) {
            if (model == this.activeModel) {
                this.addParameter(name, model.getLocation(construct));
            } else {
                model.beginRead();
                try {
                    this.addParameter(name, model.getLocation(construct));
                }
                finally {
                    model.endRead();
                }
            }
        }

        @Override
        public void setFocusLocation(Object construct) {
            if (construct == null) {
                return;
            }
            Location location = this.location.getModel().getLocation(construct);
            if (location != null) {
                this.focusLocation = location;
            }
        }

        @Override
        public void setFocusLocation(Location location) {
            this.focusLocation = location;
        }

        @Override
        public void setVariation(String name) {
            this.variation = name;
        }

        @Override
        public void hideAllTransforms() {
            this.transformMask = 0;
            this.defaultTransform = null;
        }

        @Override
        public void showTransform(Transform transform) {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (transform != transforms[i]) continue;
                this.transformMask |= 1 << i;
                return;
            }
        }

        @Override
        public void hideTransform(Transform transform) {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (transform != transforms[i]) continue;
                this.transformMask &= ~(1 << i);
                return;
            }
        }

        @Override
        public void setTransformFocusLocation(Transform transform, Object construct) {
            Location location;
            if (construct != null && (location = this.location.getModel().getLocation(construct)) != null) {
                this.setTransformFocusLocation(transform, location);
            }
        }

        @Override
        public void setTransformFocusLocation(Transform transform, Location location) {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (transform != transforms[i]) continue;
                this.transformFocusLocationMask &= ~(1 << i);
                this.transformFocusLocations[i] = location;
                return;
            }
        }

        @Override
        public void setDefaultTransform(Transform fix) {
            this.defaultTransform = fix;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public int getParameterCount() {
            return this.parameterCount;
        }

        @Override
        public String getParameterName(int index) {
            return this.parameterNames[index];
        }

        @Override
        public Object getParameterValue(int index) {
            return this.parameterValues[index];
        }

        @Override
        public Object getParameterValue(String name) {
            int i = this.getParameterCount();
            while (i-- > 0) {
                if (!name.equals(this.getParameterName(i))) continue;
                return this.getParameterValue(i);
            }
            return null;
        }

        @Override
        public Location getFocusLocation() {
            if (this.focusLocation == null && this.construct != null) {
                this.focusLocation = this.model.getFocusLocation(this.construct, this.location);
            }
            return this.focusLocation;
        }

        @Override
        public Rule getRule() {
            return this.rule;
        }

        @Override
        public String getVariation() {
            return this.variation;
        }

        @Override
        public int getTransformCount() {
            int count = 0;
            for (int i = 0; i < 15; ++i) {
                if ((this.transformMask & 1 << i) == 0) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Transform getTransform(int index) {
            for (int i = 0; i < 15; ++i) {
                if ((this.transformMask & 1 << i) == 0 || index-- != 0) continue;
                return this.rule.getTransforms()[i];
            }
            throw new IndexOutOfBoundsException(index + " of " + this.getTransformCount());
        }

        @Override
        public Location getTransformFocusLocation(int index) {
            for (int i = 0; i < 15; ++i) {
                if ((this.transformMask & 1 << i) == 0 || index-- != 0) continue;
                if ((this.transformFocusLocationMask & 1 << i) != 0) {
                    return this.transformFocusLocations[i];
                }
                return null;
            }
            throw new IndexOutOfBoundsException(index + " of " + this.getTransformCount());
        }

        @Override
        public Transform getDefaultTransform() {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if ((this.transformMask & 1 << i) == 0 || transforms[i] != this.defaultTransform) continue;
                return this.defaultTransform;
            }
            return null;
        }

        @Override
        public int getSerialNumber() {
            return 0;
        }

        public String toString() {
            if (this.rule == null) {
                return "[void]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.location);
            builder.append(" ");
            builder.append(this.rule.labelOrId());
            builder.append(" [");
            for (int i = 0; i < this.getParameterCount(); ++i) {
                String name;
                if (i > 0) {
                    builder.append(", ");
                }
                if ((name = this.getParameterName(i)) == null || name.isEmpty()) {
                    name = String.valueOf(i);
                }
                builder.append(name);
                builder.append("=");
                builder.append(this.getParameterValue(i));
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

