/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import com.sun.el.ExpressionFactoryImpl;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.swing.SwingUtilities;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideri.util.Product;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.TypeMap;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.AuditProvider;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.Converter;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.extension.Required;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.DefaultProfile;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.transform.CompositeTransform;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.DefaultAuditModel;
import oracle.jdevimpl.audit.core.DefaultAuditor;
import oracle.jdevimpl.audit.core.DefaultTransformer;
import oracle.jdevimpl.audit.core.PropertyDeferredException;
import oracle.jdevimpl.audit.log.AuditLogPage;
import oracle.jdevimpl.audit.model.ContentRootFactory;
import oracle.jdevimpl.audit.model.DefaultModelTypeFactory;
import oracle.jdevimpl.audit.model.DirectoryModelType;
import oracle.jdevimpl.audit.model.ProjectModelType;
import oracle.jdevimpl.audit.model.RootModelType;
import oracle.jdevimpl.audit.model.WorkspaceModelType;
import oracle.jdevimpl.audit.util.SortedCollections;
import org.xml.sax.Locator;

public class DefaultAuditManager
extends AuditManager {
    private final List<AuditProvider> providers = new ArrayList<AuditProvider>();
    private Map<String, ExtensionBean> beans;
    private Set<Class<? extends Analyzer>> analyzers;
    private Map<Class<?>, PersistenceDelegate> persistenceDelegates;
    private List<Profile> profiles;
    private List<URL> styleSheets;
    private List<URL> profileStyleSheets;
    private Map<Class<?>, BeanCustomizer> beanCustomizers;
    private volatile DefaultModelTypeFactory defaultModelTypeFactory;
    private volatile List<ContentRootFactory> contentRootFactories;
    private AuditPreferences preferences;
    private static final Log LOG = new Log("audit-initialization");
    private TypeMap<Object, Converter<?>> converters;
    private Map<Class<?>, List<PropertyDescriptor>> properties = new HashMap();
    private Comparator propertyValueComparator = new Comparator(){

        public int compare(Object left, Object right) {
            return ((PropertyDescriptor)left).getName().compareTo(((AuditHook.Value)right).getName());
        }
    };

    @Override
    public void register(AuditProvider provider) {
        LOG.trace("registering {0}", (Object)provider);
        this.providers.add(provider);
    }

    @Override
    public AuditPreferences getPreferences() {
        if (this.preferences == null) {
            ClientSetting settings = ClientSetting.findOrCreate((String)Product.getProductID());
            String KEY = "audit-preferences";
            this.preferences = (AuditPreferences)settings.getData(KEY);
            if (this.preferences == null) {
                oracle.jdevimpl.audit.preferences.AuditPreferences p = new oracle.jdevimpl.audit.preferences.AuditPreferences();
                settings.putData(KEY, (Copyable)p);
                this.preferences = p;
            }
        }
        return this.preferences;
    }

    @Override
    public ModelTypeFactory createModelTypeFactory(ModelType ... modelTypes) {
        ArrayList<ModelType> types = new ArrayList<ModelType>();
        types.add(new RootModelType());
        types.add(new WorkspaceModelType());
        types.add(new ProjectModelType());
        types.add(new DirectoryModelType());
        for (ModelType type : modelTypes) {
            types.add(type);
        }
        return new DefaultModelTypeFactory(types, this.getContentRootFactories());
    }

    @Override
    public ModelTypeFactory getDefaultModelTypeFactory() {
        if (this.defaultModelTypeFactory == null) {
            LinkedHashSet<Class> modelTypeTypes = new LinkedHashSet<Class>();
            for (AuditProvider provider : this.providers) {
                Class[] types = provider.getModels();
                if (types == null) continue;
                for (Class type : types) {
                    if (type == null) continue;
                    modelTypeTypes.add(type);
                }
            }
            ArrayList<ModelType> modelTypes = new ArrayList<ModelType>(modelTypeTypes.size());
            for (Class typeClass : modelTypeTypes) {
                try {
                    modelTypes.add((ModelType)typeClass.newInstance());
                }
                catch (Throwable e) {
                    Log.error((String)"Model type {0} not created : {1}", (Object)typeClass, (Object)e);
                }
            }
            for (AuditHook.TypeDefinition definition : AuditHook.getAuditHook().getModels()) {
                ModelType type = (ModelType)definition.getInstance();
                if (type == null) continue;
                modelTypes.add(type);
            }
            this.defaultModelTypeFactory = new DefaultModelTypeFactory(modelTypes, this.getContentRootFactories());
        }
        return this.defaultModelTypeFactory;
    }

    private List<ContentRootFactory> getContentRootFactories() {
        if (this.contentRootFactories == null) {
            ArrayList<ContentRootFactory> contentRootFactories = new ArrayList<ContentRootFactory>();
            for (AuditHook.TypeDefinition definition : AuditHook.getAuditHook().getRootFactories()) {
                ContentRootFactory factory = (ContentRootFactory)definition.getInstance();
                if (factory == null) continue;
                contentRootFactories.add(factory);
            }
            this.contentRootFactories = contentRootFactories;
        }
        return this.contentRootFactories;
    }

    @Override
    public Auditor createAuditor() {
        return this.createAuditor(this.getDefaultModelTypeFactory());
    }

    @Override
    public Auditor createAuditor(ModelTypeFactory factory) {
        try {
            return new DefaultAuditor(factory);
        }
        catch (NoClassDefFoundError e) {
            String EOL = System.getProperty("line.separator");
            String[] PLEA = new String[]{"Please describe this installation if possible (e.g., make pullsan or make release in JDEVADF view", "(note role if any), unzip of Java edition, install of Studio Edition, etc). Build command history", "(e.g., module clean or rebuild commands) may also be relevant."};
            File product = new File(Ide.getOracleHomeDirectory());
            File oracle = product.getParentFile();
            File built = new File(oracle, "built");
            StringBuilder builder = new StringBuilder();
            builder.append(e).append(EOL).append(EOL);
            for (String line : PLEA) {
                builder.append("  ").append(line).append(EOL);
            }
            builder.append(EOL);
            DefaultAuditManager.appendJsp(builder, new File(oracle, "modules"), true, EOL);
            DefaultAuditManager.appendJsp(builder, new File(product, "modules"), false, EOL);
            DefaultAuditManager.appendDir(builder, built, EOL);
            DefaultAuditManager.appendDir(builder, new File(built, "dist-wls"), EOL);
            throw new UnexpectedExceptionError(builder.toString(), (Throwable)e);
        }
    }

    private static StringBuilder appendJsp(StringBuilder builder, File modules, boolean contents, String EOL) {
        File jsp = null;
        String[] names = modules.list();
        builder.append("  ");
        if (names == null) {
            builder.append(modules);
            if (modules.exists()) {
                builder.append(" empty");
            } else {
                builder.append(" not found");
            }
        } else {
            for (String name : names) {
                if (!name.startsWith("javax.jsp")) continue;
                jsp = new File(modules, name);
                break;
            }
            builder.append(modules).append(" found").append(EOL).append("  ");
            if (jsp != null) {
                builder.append(jsp).append(" found");
            } else {
                builder.append(modules).append(File.separator).append("javax.jsp* not found");
                if (contents) {
                    builder.append(", but found:");
                    for (String name : names) {
                        if (name.startsWith("com.bea")) continue;
                        builder.append(EOL).append("    ").append(modules).append(File.separator).append(name);
                    }
                }
            }
        }
        builder.append(EOL);
        return builder;
    }

    private static StringBuilder appendDir(StringBuilder builder, File dir, String EOL) {
        builder.append("  ").append(dir);
        if (dir.exists()) {
            builder.append(" found");
        } else {
            builder.append(" not found");
        }
        builder.append(EOL);
        return builder;
    }

    @Override
    public AuditModel createModel() {
        return new DefaultAuditModel();
    }

    @Override
    public Profile createProfile(String key, String name, URL url) {
        return new DefaultProfile(key, name, url);
    }

    @Override
    public Profile createProfile(String name, Class<? extends Analyzer> ... analyzers) {
        return new DefaultProfile(name, analyzers);
    }

    @Override
    public AuditModel runShowLogPage(Auditor auditor, String label, Thread.UncaughtExceptionHandler handler) {
        return AuditLogPage.runShow(auditor, label, handler);
    }

    @Override
    public void showLogPage(final Auditor auditor, final AuditModel model, final String label) {
        if (SwingUtilities.isEventDispatchThread()) {
            AuditLogPage.auditLogPage(auditor, model, label).show();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AuditLogPage.auditLogPage(auditor, model, label).show();
                }
            });
        }
    }

    @Override
    public Transformer createTransformer() {
        return new DefaultTransformer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<String, ExtensionBean> getBeans() {
        if (this.beans != null) {
            return this.beans;
        }
        LOG.trace("initializing beans");
        String LOGGER_ID = "audit-initialization";
        PerformanceLogger timer = PerformanceLogger.get();
        timer.startTiming("audit-initialization");
        try {
            Field idField = this.getField(ExtensionBean.class, "id");
            Field extensionIdField = this.getField(ExtensionBean.class, "extensionId");
            Field extensionLineField = this.getField(ExtensionBean.class, "extensionLine");
            Field extensionBundleField = this.getField(ExtensionBean.class, "extensionBundle");
            Field settersField = this.getField(ExtensionBean.class, "setters");
            Field categoryCategoryField = this.getField(Category.class, "category");
            Field conditionField = this.getField(Transform.class, "condition");
            Field parametersField = this.getField(Rule.class, "parameters");
            Field ruleCategoryField = this.getField(Rule.class, "category");
            Field variationsField = this.getField(Rule.class, "variations");
            Field transformsField = this.getField(Rule.class, "transforms");
            Field defaultTransformField = this.getField(Rule.class, "defaultTransform");
            Field metricCategoryField = this.getField(Metric.class, "category");
            Field valueClassField = this.getField(Metric.class, "type");
            ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
            AuditELContext expressionContext = new AuditELContext();
            this.beans = new HashMap<String, ExtensionBean>();
            AuditHook auditHook = AuditHook.getAuditHook();
            Category undefinedCategory = new Category("oracle.ide.audit.undefined", "oracle.ide.audit", null);
            Collection<AuditHook.CategoryDefinition> unresolved = auditHook.getCategories();
            boolean unresolvable = false;
            while (!unresolved.isEmpty()) {
                int lastUnresolvedCount = unresolved.size();
                Collection<AuditHook.CategoryDefinition> definitions = unresolved;
                unresolved = new ArrayList<AuditHook.CategoryDefinition>();
                for (AuditHook.CategoryDefinition categoryDefinition : definitions) {
                    String enclosingCategoryId = categoryDefinition.getCategoryId();
                    ExtensionBean bean = this.beans.get(enclosingCategoryId);
                    if (enclosingCategoryId == null || bean != null || unresolvable) {
                        Category enclosingCategory;
                        if (unresolvable) {
                            categoryDefinition.log(Level.SEVERE, "Category ''{0}'' references undefined category ''{1}''", categoryDefinition.getId(), categoryDefinition.getCategoryId());
                            this.beans.put(undefinedCategory.id(), undefinedCategory);
                            enclosingCategory = undefinedCategory;
                        } else if (enclosingCategoryId == null || bean instanceof Category) {
                            enclosingCategory = (Category)bean;
                        } else {
                            categoryDefinition.log(Level.SEVERE, "Category ''{0}'' references category ''{2}'' but found ''{3}''", categoryDefinition.getId(), categoryDefinition.getCategoryId(), bean);
                            this.beans.put(undefinedCategory.id(), undefinedCategory);
                            enclosingCategory = undefinedCategory;
                        }
                        AuditHook.TypeDefinition beanClass = categoryDefinition.getBeanClass();
                        try {
                            Category category;
                            if (beanClass != null) {
                                category = (Category)beanClass.getInstance();
                                if (category == null) {
                                    category = new Category();
                                }
                            } else {
                                category = new Category();
                            }
                            this.inject(idField, category, categoryDefinition.getId(), categoryDefinition);
                            this.inject(extensionIdField, category, categoryDefinition.getExtensionId(), categoryDefinition);
                            this.inject(extensionLineField, category, categoryDefinition.getLineNumber(), categoryDefinition);
                            this.inject(extensionBundleField, category, categoryDefinition.getExtensionBundle(), categoryDefinition);
                            this.inject(categoryCategoryField, category, enclosingCategory, categoryDefinition);
                            expressionContext.setBean(category);
                            this.configure(categoryDefinition, category, this.getProperties(category), categoryDefinition.getValues(), null, (ExpressionFactory)expressionFactory, expressionContext);
                            category.setStrings(categoryDefinition.getStrings());
                            this.beans.put(category.id(), category);
                        }
                        catch (Throwable e) {
                            categoryDefinition.log(Level.SEVERE, "Category ''{0}'' not created: {1}", beanClass.getName(), e);
                        }
                        continue;
                    }
                    unresolved.add(categoryDefinition);
                }
                if (unresolvable) break;
                unresolvable = unresolved.size() == lastUnresolvedCount;
            }
            Map<String, AuditHook.TransformDefinition> transformDefinitions = auditHook.getTransforms();
            MultiMap<String, AuditHook.TransformBinding> transformBindings = auditHook.getTransformBindings();
            for (AuditHook.RuleDefinition ruleDefinition : auditHook.getRules()) {
                String ruleId = ruleDefinition.getId();
                ExtensionBean category = this.getCategory(ruleDefinition, undefinedCategory);
                AuditHook.TypeDefinition ruleClass = ruleDefinition.getBeanClass();
                try {
                    Collection<String> variations;
                    Rule rule;
                    if (ruleClass != null) {
                        rule = (Rule)ruleClass.getInstance();
                        if (rule == null) {
                            rule = new Rule();
                        }
                    } else {
                        rule = new Rule();
                    }
                    rule.setEnabled(true);
                    this.inject(extensionIdField, rule, ruleDefinition.getExtensionId(), ruleDefinition);
                    this.inject(extensionLineField, rule, ruleDefinition.getLineNumber(), ruleDefinition);
                    this.inject(extensionBundleField, rule, ruleDefinition.getExtensionBundle(), ruleDefinition);
                    this.inject(idField, rule, ruleDefinition.getId(), ruleDefinition);
                    this.inject(ruleCategoryField, rule, category, ruleDefinition);
                    String severity = ruleDefinition.getSeverity();
                    if (severity != null) {
                        rule.setSeverity(Severity.valueOf(severity));
                    }
                    if (!(variations = ruleDefinition.getVariations()).isEmpty()) {
                        this.inject(variationsField, rule, variations, ruleDefinition);
                    }
                    List<PropertyDescriptor> properties = this.getProperties(rule);
                    Rule.Parameter[] parameters = new Rule.Parameter[ruleDefinition.getParameters().size()];
                    int p = 0;
                    for (AuditHook.Parameter parameter : ruleDefinition.getParameters()) {
                        String parameterName = parameter.getName();
                        AuditHook.TypeDefinition typeDefinition = parameter.getParameterType();
                        Class<Object> type = typeDefinition.getType();
                        if (type == null) {
                            type = Object.class;
                        }
                        parameters[p++] = new DefaultParameter(parameterName, type, parameter.isRequired());
                        if (this.getProperty(rule.getClass(), parameterName) == null) continue;
                        parameter.log(Level.SEVERE, "Parameter ''{0}'' conflicts with property of same name", parameterName);
                    }
                    this.inject(parametersField, rule, parameters, ruleDefinition);
                    expressionContext.setBean(rule);
                    this.configure(ruleDefinition, rule, properties, ruleDefinition.getValues(), null, (ExpressionFactory)expressionFactory, expressionContext);
                    rule.setStrings(ruleDefinition.getStrings());
                    this.beans.put(rule.id(), rule);
                    Collection bindings = transformBindings.get((Object)ruleId);
                    if (bindings == null) continue;
                    ArrayList<Transform> transforms = new ArrayList<Transform>();
                    Transform defaultTransform = null;
                    String defaultTransformExtensionId = null;
                    block16: for (AuditHook.TransformBinding binding : bindings) {
                        AuditHook.Condition condition;
                        Transform transform;
                        String transformId = binding.getTransform();
                        String bindingExtensionId = binding.getExtensionId();
                        AuditHook.TransformDefinition transformDefinition = transformDefinitions.get(transformId);
                        if (transformDefinition == null) {
                            this.log(Level.SEVERE, "Transform ''{0}'' not defined", transformId);
                            continue;
                        }
                        String transformExtensionId = transformDefinition.getExtensionId();
                        AuditHook.TypeDefinition transformClass = transformDefinition.getBeanClass();
                        if (transformDefinition.isComposite()) {
                            if (transformClass != null) {
                                transform = (Transform)transformClass.getInstance();
                                if (!(transform instanceof CompositeTransform)) {
                                    this.log(Level.SEVERE, "Transform ''{0}'' class ''{1}'' does not extend ''{2}''", transformId, transform.getClass().getName(), CompositeTransform.class.getName());
                                    continue;
                                }
                            } else {
                                transform = new CompositeTransform();
                            }
                            CompositeTransform composite = (CompositeTransform)transform;
                            for (AuditHook.TransformDefinition componentDefinition : transformDefinition.getTransforms()) {
                                AuditHook.TypeDefinition componentClass = componentDefinition.getBeanClass();
                                Transform component = (Transform)componentClass.getInstance();
                                if (component == null) continue block16;
                                component.setEnabled(true);
                                this.inject(extensionIdField, component, transformExtensionId, componentDefinition);
                                this.inject(extensionLineField, component, componentDefinition.getLineNumber(), componentDefinition);
                                this.inject(extensionBundleField, component, componentDefinition.getExtensionBundle(), componentDefinition);
                                this.inject(idField, component, transformId, componentDefinition);
                                expressionContext.setBean(component, rule, null);
                                List<PropertyDescriptor> componentProperties = this.getProperties(component);
                                HashMap<String, DeferredSetter> deferredValues = new HashMap<String, DeferredSetter>();
                                expressionContext.setBean(component, rule, null);
                                this.configure(componentDefinition, component, componentProperties, this.merge(binding.getValues(), componentDefinition.getValues()), deferredValues, (ExpressionFactory)expressionFactory, expressionContext);
                                if (deferredValues != null) {
                                    this.inject(settersField, component, deferredValues, componentDefinition);
                                }
                                composite.addComponent(component);
                            }
                        } else {
                            transform = (Transform)transformClass.getInstance();
                            if (transform == null) continue;
                            transform = (Transform)transformClass.getInstance();
                        }
                        this.inject(extensionIdField, transform, transformExtensionId, transformDefinition);
                        this.inject(extensionLineField, transform, transformDefinition.getLineNumber(), transformDefinition);
                        this.inject(extensionBundleField, transform, transformDefinition.getExtensionBundle(), transformDefinition);
                        this.inject(idField, transform, transformId, transformDefinition);
                        expressionContext.setBean(transform, rule, null);
                        List<PropertyDescriptor> transformProperties = this.getProperties(transform);
                        HashMap<String, DeferredSetter> deferredValues = new HashMap<String, DeferredSetter>();
                        expressionContext.setBean(transform, rule, null);
                        this.configure(transformDefinition, transform, transformProperties, this.merge(binding.getValues(), transformDefinition.getValues()), deferredValues, (ExpressionFactory)expressionFactory, expressionContext);
                        if (deferredValues != null) {
                            this.inject(settersField, transform, deferredValues, transformDefinition);
                        }
                        if ((condition = binding.getCondition()) != null) {
                            String expressionText;
                            String text = condition.getText();
                            switch (text.charAt(0)) {
                                case '#': 
                                case '$': {
                                    expressionText = text;
                                    break;
                                }
                                default: {
                                    expressionText = "${" + text + "}";
                                }
                            }
                            try {
                                ValueExpression expression = expressionFactory.createValueExpression((ELContext)expressionContext, expressionText, Boolean.TYPE);
                                DefaultDeferredExpression deferredExpression = new DefaultDeferredExpression(expression, text, condition);
                                this.inject(conditionField, transform, deferredExpression, transformDefinition);
                            }
                            catch (ELException e) {
                                binding.log(Level.SEVERE, "parsing \"{0}\" failed: {1}", new Object[]{text, e});
                            }
                        }
                        transform.setStrings(transformDefinition.getStrings());
                        transforms.add(transform);
                        if (!binding.isDefault()) continue;
                        if (defaultTransform == null) {
                            defaultTransform = transform;
                            defaultTransformExtensionId = bindingExtensionId;
                            continue;
                        }
                        binding.log(Level.SEVERE, "Default transform already defined as ''{0}'' by extension ''{1}''", defaultTransform.id(), defaultTransformExtensionId);
                    }
                    this.inject(transformsField, rule, transforms.toArray(new Transform[transforms.size()]), ruleDefinition);
                    this.inject(defaultTransformField, rule, defaultTransform, ruleDefinition);
                }
                catch (Throwable e) {
                    ruleDefinition.log(Level.SEVERE, "Rule ''{0}'' not created: {1}", ruleDefinition, e);
                }
            }
            for (AuditHook.MetricDefinition metricDefinition : auditHook.getMetrics()) {
                Metric metric;
                ExtensionBean category = this.getCategory(metricDefinition, undefinedCategory);
                Object valueType = null;
                AuditHook.TypeDefinition valueTypeDefinition = metricDefinition.getValueType();
                if (valueTypeDefinition == null) continue;
                AuditHook.TypeDefinition metricClass = metricDefinition.getBeanClass();
                if (metricClass != null) {
                    metric = (Metric)metricClass.getInstance();
                    if (metric == null) {
                        metric = new Metric();
                    }
                } else {
                    metric = new Metric();
                }
                this.inject(idField, metric, metricDefinition.getId(), metricDefinition);
                this.inject(extensionIdField, metric, metricDefinition.getExtensionId(), metricDefinition);
                this.inject(extensionLineField, category, metricDefinition.getLineNumber(), metricDefinition);
                this.inject(extensionBundleField, category, metricDefinition.getExtensionBundle(), metricDefinition);
                this.inject(metricCategoryField, metric, category, metricDefinition);
                this.inject(valueClassField, metric, valueType, metricDefinition);
                expressionContext.setBean(metric);
                this.configure(metricDefinition, metric, this.getProperties(metric), metricDefinition.getValues(), null, (ExpressionFactory)expressionFactory, expressionContext);
                metric.setStrings(metricDefinition.getStrings());
                this.beans.put(metric.id(), metric);
            }
        }
        finally {
            LOG.trace("completed initializing beans");
            timer.stopTiming("audit-initialization", "Audit initialization");
        }
        return this.beans;
    }

    private Collection<AuditHook.Value> merge(Collection<AuditHook.Value> left, Collection<AuditHook.Value> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        ArrayList<AuditHook.Value> values = new ArrayList<AuditHook.Value>(left.size() + right.size());
        SortedCollections.ComparisonIterator<AuditHook.Value, AuditHook.Value> iterator = SortedCollections.comparisonIterator(left, right);
        while (iterator.hasNext()) {
            switch (iterator.next()) {
                case LESS_THAN: {
                    values.add(iterator.left());
                    break;
                }
                case GREATER_THAN: {
                    values.add(iterator.right());
                    break;
                }
                case EQUAL: {
                    values.add(iterator.left());
                }
            }
        }
        return values;
    }

    private ExtensionBean getCategory(AuditHook.CategoryDefinition definition, Category undefinedCategory) {
        ExtensionBean category = this.beans.get(definition.getCategoryId());
        if (category == null) {
            definition.log(Level.SEVERE, "Category ''{0}'' not defined", definition.getCategoryId());
            category = undefinedCategory;
            this.beans.put(undefinedCategory.id(), undefinedCategory);
        } else if (!(category instanceof Category)) {
            definition.log(Level.SEVERE, "Category id ''{0}'' references a ''{1}'', not a Category", definition.getCategoryId(), category.getClass().getName());
            category = undefinedCategory;
            this.beans.put(undefinedCategory.id(), undefinedCategory);
        }
        return category;
    }

    private void log(Level level, String message, Object ... parameters) {
        Logger logger = ExtensionRegistry.getExtensionRegistry().getManifestLogger();
        logger.log(level, message, parameters);
    }

    private Field getField(Class<?> type, String name) {
        try {
            Field field = type.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            this.log(Level.SEVERE, "Field ''{0}'' of type ''{1}'' not found: {3}", name, type, e);
            return null;
        }
    }

    private void inject(Field field, Object object, Object value, AuditHook.Definition definition) {
        try {
            if (field != null) {
                field.set(object, value);
            }
        }
        catch (Throwable e) {
            definition.log(Level.SEVERE, "Field ''{0}'' of ''{1}'' not set to \"{2}\": {3}", field, object, value, e);
        }
    }

    private List<PropertyDescriptor> getProperties(Object bean) {
        Class<?> type = bean.getClass();
        List<PropertyDescriptor> collector = this.properties.get(type);
        if (collector == null) {
            try {
                PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
                collector = new ArrayList<PropertyDescriptor>(descriptors.length);
                for (PropertyDescriptor descriptor : descriptors) {
                    if (descriptor.getWriteMethod() == null || descriptor.getReadMethod() == null) continue;
                    collector.add(descriptor);
                }
                Collections.sort(collector, new Comparator<PropertyDescriptor>(){

                    @Override
                    public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            catch (IntrospectionException e) {
                this.log(Level.SEVERE, "bean ''{0}'' not introspected: {1}", bean, e);
                collector = Collections.emptyList();
            }
            this.properties.put(type, collector);
        }
        return collector;
    }

    private PropertyDescriptor getProperty(Object bean, String name) {
        for (PropertyDescriptor descriptor : this.getProperties(bean)) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void configure(AuditHook.Definition definition, Object bean, Collection<PropertyDescriptor> properties, Collection<AuditHook.Value> values, Map<String, DeferredSetter> deferredValues, ExpressionFactory expressionFactory, AuditELContext expressionContext) {
        iterator = SortedCollections.comparisonIterator(properties, values, this.propertyValueComparator);
        while (iterator.hasNext()) {
            switch (4.$SwitchMap$oracle$jdevimpl$audit$util$SortedCollections$Comparison[iterator.next().ordinal()]) {
                case 1: {
                    property = iterator.left();
                    if (property.getWriteMethod().getAnnotation(Required.class) == null) break;
                    definition.log(Level.SEVERE, "property ''{0}'' unset", new Object[]{property.getName()});
                    break;
                }
                case 3: {
                    property = iterator.left();
                    value = iterator.right();
                    type = property.getPropertyType();
                    name = property.getName();
                    if (!value.getValues().isEmpty()) ** GOTO lbl52
                    text = value.getText();
                    switch (text.charAt(0)) {
                        case '#': 
                        case '$': {
                            expressionText = text;
                            break;
                        }
                        default: {
                            expressionText = "${" + text + "}";
                        }
                    }
                    try {
                        expression = expressionFactory.createValueExpression((ELContext)expressionContext, expressionText, type);
                    }
                    catch (ELException e) {
                        value.log(Level.SEVERE, "parsing \"{0}\" failed: {1}", new Object[]{text, e});
                        break;
                    }
                    writeMethod = property.getWriteMethod();
                    try {
                        object /* !! */  = expressionContext.evaluateExpression(expression);
                        ambiguities = expressionContext.getAmbiguities();
                        if (!ambiguities.isEmpty()) {
                            setter = new DefaultDeferredSetter(name, writeMethod, expression, text, value);
                            deferredValues.put(name, setter);
                            for (String ambiguity : ambiguities) {
                                value.log(Level.WARNING, ambiguity, new Object[0]);
                            }
                            break;
                        }
                        ** GOTO lbl59
                    }
                    catch (PropertyDeferredException e) {
                        setter = new DefaultDeferredSetter(name, writeMethod, expression, text, value);
                        deferredValues.put(name, setter);
                        break;
                    }
                    catch (PropertyNotFoundException e) {
                        value.log(Level.SEVERE, "property not found in \"{0}\": {1}", new Object[]{text, e});
                        break;
                    }
                    catch (Exception e) {
                        value.log(Level.SEVERE, "evaluating \"{0}\" failed: {1}", new Object[]{text, e});
                        break;
                    }
lbl52:
                    // 1 sources

                    try {
                        object /* !! */  = type.newInstance();
                        this.configure(value, object /* !! */ , this.getProperties(object /* !! */ ), value.getValues(), deferredValues, expressionFactory, expressionContext);
                    }
                    catch (Throwable e) {
                        value.log(Level.SEVERE, "new ''{0}'' not created: {1}", new Object[]{type, e});
                        break;
                    }
lbl59:
                    // 2 sources

                    try {
                        property.getWriteMethod().invoke(bean, new Object[]{object /* !! */ });
                    }
                    catch (Throwable e) {
                        value.log(Level.SEVERE, "property ''{0}'' not set: {1}", new Object[]{property.getName(), e});
                    }
                    break;
                }
                case 2: {
                    value = iterator.right();
                    value.log(Level.SEVERE, "property ''{0}'' not defined", new Object[]{value.getName()});
                    break;
                }
            }
        }
    }

    @Override
    public synchronized Collection<Class<? extends Analyzer>> getAnalyzers() {
        if (this.analyzers != null) {
            return this.analyzers;
        }
        this.analyzers = new HashSet<Class<? extends Analyzer>>();
        for (AuditHook.TypeDefinition definition : AuditHook.getAuditHook().getAnalyzers()) {
            Class type = definition.getType();
            if (type == null) continue;
            this.analyzers.add(type);
        }
        for (AuditProvider provider : this.providers) {
            Class[] types = provider.getAnalyzers();
            if (types == null) continue;
            for (Class type : types) {
                if (type == null) continue;
                this.analyzers.add(type);
            }
        }
        return this.analyzers;
    }

    public synchronized Converter getConverter(Class<?> type) {
        if (this.converters == null) {
            this.converters = new TypeMap();
            for (AuditHook.TypeDefinition definition : AuditHook.getAuditHook().getConverters()) {
                Converter converter = (Converter)definition.getInstance();
                Class converterType = converter.getType();
                this.converters.put(converterType, (Object)converter);
                Class<?> primitiveType = DefaultAuditManager.getPrimitiveType(converterType);
                if (primitiveType == null) continue;
                this.converters.put(primitiveType, (Object)converter);
            }
        }
        return (Converter)this.converters.get(type);
    }

    public static Class<?> getPrimitiveType(Class type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    @Override
    public Map<Class<?>, PersistenceDelegate> getPersistenceDelegates() {
        if (this.persistenceDelegates != null) {
            return this.persistenceDelegates;
        }
        this.persistenceDelegates = new HashMap();
        for (AuditProvider provider : this.providers) {
            AuditProvider.PersistenceDelegateBinding[] bindings = provider.getPersistenceDelegates();
            if (bindings == null) continue;
            for (AuditProvider.PersistenceDelegateBinding binding : bindings) {
                if (binding == null) continue;
                if (!this.persistenceDelegates.containsKey(binding.getType())) {
                    this.persistenceDelegates.put(binding.getType(), binding.getDelegate());
                    continue;
                }
                Log.error((String)"Persistence delegate for {0} in {1} already bound", (Object)binding.getType(), (Object)provider);
            }
        }
        return this.persistenceDelegates;
    }

    @Override
    public Collection<Profile> getProfiles() {
        if (this.profiles != null) {
            return this.profiles;
        }
        this.profiles = new ArrayList<Profile>();
        for (AuditProvider provider : this.providers) {
            Profile[] profile = provider.getProfiles();
            if (profile == null) continue;
            for (Profile type : profile) {
                if (type == null) continue;
                this.profiles.add(type);
            }
        }
        return this.profiles;
    }

    @Override
    public Collection<URL> getStyleSheets() {
        if (this.styleSheets != null) {
            return this.styleSheets;
        }
        this.styleSheets = new ArrayList<URL>();
        for (AuditProvider provider : this.providers) {
            URL[] urls = provider.getStyleSheets();
            if (urls == null) continue;
            for (URL url : urls) {
                if (url == null) continue;
                this.styleSheets.add(url);
            }
        }
        return this.styleSheets;
    }

    @Override
    public Collection<URL> getProfileStyleSheets() {
        if (this.profileStyleSheets != null) {
            return this.profileStyleSheets;
        }
        this.profileStyleSheets = new ArrayList<URL>();
        for (AuditProvider provider : this.providers) {
            URL[] urls = provider.getProfileStyleSheets();
            if (urls == null) continue;
            for (URL url : urls) {
                if (url == null) continue;
                this.profileStyleSheets.add(url);
            }
        }
        return this.profileStyleSheets;
    }

    @Override
    public Map<Class<?>, BeanCustomizer> getBeanCustomizers() {
        if (this.beanCustomizers == null) {
            this.beanCustomizers = new HashMap();
            for (AuditProvider provider : this.providers) {
                Class[] classes = provider.getBeanCustomizers();
                if (classes == null) continue;
                for (Class clas : classes) {
                    try {
                        BeanCustomizer object = (BeanCustomizer)clas.newInstance();
                        Class<?> type = object.getType();
                        if (!this.beanCustomizers.containsKey(type)) {
                            this.beanCustomizers.put(type, object);
                            continue;
                        }
                        Log.error((String)"duplicate customizer {0} for type {1}", (Object)object, type);
                    }
                    catch (Throwable e) {
                        Log.error((String)"exception instantiating customizer {0}: {1}", (Object)clas, (Object)e);
                    }
                }
            }
            this.beanCustomizers = Collections.unmodifiableMap(this.beanCustomizers);
        }
        return this.beanCustomizers;
    }

    @Override
    public boolean isRegistered(Class<?> type) {
        if (Analyzer.class.isAssignableFrom(type)) {
            return this.getAnalyzers().contains(type);
        }
        if (ModelType.class.isAssignableFrom(type)) {
            return this.getDefaultModelTypeFactory().getModelTypes().contains(type);
        }
        throw new IllegalArgumentException();
    }

    private class DefaultDeferredSetter
    extends DefaultDeferredExpression
    implements DeferredSetter {
        private final String name;
        private final Method writeMethod;

        public DefaultDeferredSetter(String name, Method writeMethod, ValueExpression expression, String text, Locator locator) {
            super(expression, text, locator);
            this.name = name;
            this.writeMethod = writeMethod;
        }

        @Override
        public Object set(Object bean, ELContext context) {
            Object value = this.evaluate(context);
            try {
                this.writeMethod.invoke(bean, value);
                return value;
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnexpectedExceptionError(e.getCause());
            }
        }

        @Override
        public boolean isRequired() {
            return this.writeMethod.isAnnotationPresent(Required.class);
        }
    }

    private class DefaultDeferredExpression
    implements DeferredExpression,
    Locator {
        private final ValueExpression expression;
        private final String text;
        private final String systemId;
        private final int line;

        public DefaultDeferredExpression(ValueExpression expression, String text, Locator locator) {
            this.expression = expression;
            this.text = text;
            this.systemId = locator.getSystemId();
            this.line = locator.getLineNumber();
        }

        @Override
        public Object evaluate(ELContext context) {
            Object value = ((AuditELContext)context).evaluateExpression(this.expression);
            return value;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void log(String message, Object ... parameters) {
            ExtensionLogRecord record = new ExtensionLogRecord((Locator)this, Level.SEVERE, message);
            if (parameters != null && parameters.length > 0) {
                record.setParameters(parameters);
            }
            ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
        }

        @Override
        public int getColumnNumber() {
            return 0;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public String getPublicId() {
            return "";
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        public String toString() {
            return this.getText();
        }
    }

    private class DefaultParameter
    implements Rule.Parameter {
        private String name;
        private Class<?> type;
        private boolean required;

        public DefaultParameter(String name, Class<?> type, boolean required) {
            this.name = name;
            this.type = type;
            this.required = required;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "parameter " + this.name + (this.required ? " (required)" : "");
        }
    }
}

