/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.Color;
import java.util.regex.Pattern;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.ObjectWrapper;
import oracle.ide.marshal.xml.ToDomConverter;
import oracle.javatools.marshal.ToStringManager;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import org.w3c.dom.Element;

public class Converters {
    private static boolean registered = false;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        ToStringManager.registerCustomConverter(CategoryConverter.class);
        ToStringManager.registerCustomConverter(LocalizerConverter.class);
        ToStringManager.registerCustomConverter(PatternConverter.class);
        Object2Dom.registerConverter((ToDomConverter)new TypeSafeEnumerationConverter());
        Object2Dom.registerConverter((ToDomConverter)new ColorConverter());
    }

    public static class ColorConverter
    implements ToDomConverter {
        public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
            if (Color.class.isAssignableFrom(type)) {
                String text = String.valueOf(((Color)wrapper.getObject()).getRGB());
                element.appendChild(element.getOwnerDocument().createTextNode(text));
                return true;
            }
            return false;
        }

        public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
            if (Color.class.isAssignableFrom(type)) {
                String text = element.getFirstChild().getNodeValue();
                wrapper.setObject((Object)new Color(Integer.parseInt(text), true));
                return true;
            }
            return false;
        }
    }

    public static class TypeSafeEnumerationConverter
    implements ToDomConverter {
        public boolean toElement(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
            if (TypeSafeEnumeration.class.isAssignableFrom(type)) {
                TypeSafeEnumerationFactory descriptor = TypeSafeEnumerationFactory.factory(type);
                String text = descriptor.tag(wrapper.getObject());
                element.appendChild(element.getOwnerDocument().createTextNode(text));
                return true;
            }
            return false;
        }

        public boolean toObject(ObjectWrapper wrapper, Element element, Class type, Object2Dom o2d) {
            if (TypeSafeEnumeration.class.isAssignableFrom(type)) {
                TypeSafeEnumerationFactory descriptor = TypeSafeEnumerationFactory.factory(type);
                wrapper.setObject(descriptor.value(element.getFirstChild().getNodeValue()));
                return true;
            }
            return false;
        }
    }

    public static class PatternConverter {
        public static Class supportedClass() {
            return Pattern.class;
        }

        public static String toString(Pattern pattern) {
            return pattern.pattern();
        }

        public static Pattern fromString(String string) {
            return Pattern.compile(string);
        }
    }

    public static class LocalizerConverter {
        public static Class supportedClass() {
            return Localizer.class;
        }

        public static String toString(Localizer localizer) {
            return localizer.getBundleName();
        }

        public static Localizer fromString(String string) {
            return Localizer.instance(string);
        }
    }

    public static class CategoryConverter {
        public static Class supportedClass() {
            return Category.class;
        }

        public static String toString(Category category) {
            return category.id();
        }

        public static Category fromString(String string) {
            return new Category(string, null);
        }
    }
}

