/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.PropertyDeferredException;

class AuditELContext
extends ELContext {
    private CompositeELResolver resolver = new CompositeELResolver();
    private AuditELResolver auditResolver = new AuditELResolver();
    private Object bean;
    private Transform transform;
    private Rule rule;
    private Violation violation;
    private boolean defer;
    private Map<String, Reference> references;
    private ValueExpression expression;
    private Map<String, Reference> ambiguousReferences = new HashMap<String, Reference>();
    private Map<String, Reference> usedReferences = new HashMap<String, Reference>();

    public AuditELContext() {
        this.resolver.add((ELResolver)this.auditResolver);
        this.resolver.add((ELResolver)new MapELResolver());
        this.resolver.add((ELResolver)new ListELResolver());
        this.resolver.add((ELResolver)new ArrayELResolver());
        this.resolver.add((ELResolver)new BeanELResolver());
    }

    public void setBean(Object bean) {
        this.bean = bean;
        this.transform = null;
        this.rule = null;
        this.violation = null;
        this.defer = false;
        this.references = null;
        this.expression = null;
        this.ambiguousReferences.clear();
        this.usedReferences.clear();
    }

    public void setBean(Transform transform, Rule rule, Violation violation) {
        this.bean = null;
        this.transform = transform;
        this.rule = rule;
        this.violation = violation;
        this.defer = violation == null;
        this.references = null;
        this.expression = null;
        this.ambiguousReferences.clear();
        this.usedReferences.clear();
    }

    public void setBean(Transform transform, Rule rule) {
        this.bean = null;
        this.transform = transform;
        this.rule = rule;
        this.violation = null;
        this.defer = false;
        this.references = null;
        this.expression = null;
        this.ambiguousReferences.clear();
        this.usedReferences.clear();
    }

    public Object evaluateExpression(ValueExpression expression) {
        this.expression = expression;
        Object value = expression.getValue((ELContext)this);
        this.expression = null;
        return value;
    }

    public List<String> getAmbiguities() {
        ArrayList<String> ambiguities = new ArrayList<String>(this.usedReferences.size());
        for (Map.Entry<String, Reference> entry : this.usedReferences.entrySet()) {
            String name = entry.getKey();
            Reference overridden = this.ambiguousReferences.get(name);
            if (overridden == null) continue;
            if (entry.getValue() instanceof ParameterReference) {
                ambiguities.add("Ambiguous reference '" + name + "': rule property selected, use 'transform." + name + "' to select transform property instead");
                continue;
            }
            ambiguities.add("Ambiguous reference '" + name + "': parameter selected, use 'rule." + name + "' or 'transform." + name + "' to select rule or transform property instead");
        }
        return ambiguities;
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return null;
    }

    public VariableMapper getVariableMapper() {
        return null;
    }

    private Map<String, Reference> getReferences() {
        if (this.references == null) {
            this.references = new HashMap<String, Reference>();
            try {
                if (this.bean != null) {
                    for (PropertyDescriptor descriptor : Introspector.getBeanInfo(this.bean.getClass()).getPropertyDescriptors()) {
                        if (descriptor.getReadMethod() == null) continue;
                        String propertyName = descriptor.getName();
                        this.references.put(propertyName, new PropertyReference(this.bean, descriptor));
                    }
                    if (this.bean instanceof Category && !this.references.containsKey("category")) {
                        this.references.put("category", new BeanReference(this.bean, this.bean.getClass()));
                    }
                    if (this.bean instanceof Rule && !this.references.containsKey("rule")) {
                        this.references.put("rule", new BeanReference(this.bean, this.bean.getClass()));
                    }
                    if (this.bean instanceof Transform && !this.references.containsKey("transform")) {
                        this.references.put("transform", new BeanReference(this.bean, this.bean.getClass()));
                    }
                    if (this.bean instanceof Metric && !this.references.containsKey("metric")) {
                        this.references.put("metric", new BeanReference(this.bean, this.bean.getClass()));
                    }
                } else {
                    Reference overridden;
                    String name;
                    for (PropertyDescriptor descriptor : Introspector.getBeanInfo(this.transform.getClass()).getPropertyDescriptors()) {
                        if (descriptor.getReadMethod() == null) continue;
                        name = descriptor.getName();
                        this.references.put(name, new PropertyReference(this.transform, descriptor));
                    }
                    for (PropertyDescriptor descriptor : Introspector.getBeanInfo(this.rule.getClass()).getPropertyDescriptors()) {
                        if (descriptor.getReadMethod() == null || (overridden = this.references.put(name = descriptor.getName(), new PropertyReference(this.rule, descriptor))) == null) continue;
                        this.ambiguousReferences.put(name, overridden);
                    }
                    for (Rule.Parameter parameter : this.rule.parameters()) {
                        name = parameter.getName();
                        overridden = this.references.put(name, new ParameterReference(parameter));
                        if (overridden == null) continue;
                        this.ambiguousReferences.put(name, overridden);
                    }
                    if (this.violation != null) {
                        for (int i = 0; i < this.violation.getParameterCount(); ++i) {
                            String name2 = this.violation.getParameterName(i);
                            Reference overridden2 = this.references.get(name2);
                            if (overridden2 instanceof ParameterReference) continue;
                            this.references.put(name2, new UndeclaredParameterReference(this.violation.getParameterValue(i)));
                            if (overridden2 == null) continue;
                            this.ambiguousReferences.put(name2, overridden2);
                        }
                    }
                    if (!this.references.containsKey("rule")) {
                        this.references.put("rule", new BeanReference(this.rule, this.rule.getClass()));
                    }
                    if (!this.references.containsKey("transform")) {
                        this.references.put("transform", new BeanReference(this.transform, this.transform.getClass()));
                    }
                }
            }
            catch (IntrospectionException e) {
                throw new ELException((Throwable)e);
            }
        }
        return this.references;
    }

    private class AuditELResolver
    extends ELResolver {
        private AuditELResolver() {
        }

        public Object getValue(ELContext context, Object base, Object property) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (property == null) {
                return null;
            }
            String propertyName = property.toString();
            if (base == null) {
                Reference reference = (Reference)AuditELContext.this.getReferences().get(propertyName);
                if (reference != null) {
                    Object value = reference.getValue();
                    context.setPropertyResolved(true);
                    AuditELContext.this.usedReferences.put(propertyName, reference);
                    if (reference instanceof UndeclaredParameterReference && AuditELContext.this.ambiguousReferences.containsKey(propertyName)) {
                        AuditELContext.this.rule.logWarning("Undeclared ambiguous parameter ''{0}'' selected: use ''rule.{0}'' to silence this warning or ''transform.{0}'' to select transform property instead", propertyName);
                    }
                    return value;
                }
                if (AuditELContext.this.expression != null) {
                    Class type = AuditELContext.this.expression.getExpectedType();
                    if (TypeSafeEnumeration.class.isAssignableFrom(type)) {
                        Object value = TypeSafeEnumerationFactory.factory(type).value(propertyName);
                        if (value != null) {
                            context.setPropertyResolved(true);
                            return value;
                        }
                    } else if (Enum.class.isAssignableFrom(type)) {
                        Enum[] values;
                        for (Enum value : values = (Enum[])type.getEnumConstants()) {
                            String name = value.name();
                            if (!propertyName.equalsIgnoreCase(name)) continue;
                            context.setPropertyResolved(true);
                            return value;
                        }
                    }
                }
            } else if (base == AuditELContext.this.rule) {
                Reference reference = (Reference)AuditELContext.this.getReferences().get(propertyName);
                if (reference instanceof ParameterReference) {
                    Object value = reference.getValue();
                    context.setPropertyResolved(true);
                    AuditELContext.this.usedReferences.put(propertyName, reference);
                    return value;
                }
            } else if (base instanceof Collection) {
                if ("size".equals(propertyName) || "length".equals(propertyName)) {
                    Integer value = ((Collection)base).size();
                    context.setPropertyResolved(true);
                    return value;
                }
            } else if (base instanceof Map) {
                if ("size".equals(propertyName) || "length".equals(propertyName)) {
                    Integer value = ((Map)base).size();
                    context.setPropertyResolved(true);
                    return value;
                }
            } else if (base instanceof Object[] && ("size".equals(propertyName) || "length".equals(propertyName))) {
                Integer value = ((Object[])base).length;
                context.setPropertyResolved(true);
                return value;
            }
            return null;
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (property == null) {
                return null;
            }
            String propertyName = property.toString();
            if (base == null) {
                Reference reference = (Reference)AuditELContext.this.getReferences().get(propertyName);
                if (reference != null) {
                    Class<?> type = reference.getType();
                    context.setPropertyResolved(true);
                    AuditELContext.this.usedReferences.put(propertyName, reference);
                    return type;
                }
                if (AuditELContext.this.expression != null) {
                    Class type = AuditELContext.this.expression.getExpectedType();
                    if (TypeSafeEnumeration.class.isAssignableFrom(type)) {
                        Object value = TypeSafeEnumerationFactory.factory(type).value(propertyName);
                        if (value != null) {
                            context.setPropertyResolved(true);
                            AuditELContext.this.usedReferences.put(propertyName, reference);
                            return type;
                        }
                    } else if (Enum.class.isAssignableFrom(type)) {
                        Enum[] values;
                        for (Enum value : values = (Enum[])type.getEnumConstants()) {
                            String name = value.name();
                            if (!propertyName.equalsIgnoreCase(name)) continue;
                            AuditELContext.this.usedReferences.put(propertyName, reference);
                            context.setPropertyResolved(true);
                            return type;
                        }
                    }
                }
            } else if (base == AuditELContext.this.rule) {
                Reference reference = (Reference)AuditELContext.this.getReferences().get(propertyName);
                if (reference instanceof ParameterReference) {
                    Class<?> type = reference.getType();
                    context.setPropertyResolved(true);
                    AuditELContext.this.usedReferences.put(propertyName, reference);
                    return type;
                }
            } else if ((base instanceof Collection || base instanceof Map || base instanceof Object[]) && ("size".equals(propertyName) || "length".equals(propertyName))) {
                context.setPropertyResolved(true);
                return Integer.class;
            }
            return null;
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            Reference reference;
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (property == null) {
                return;
            }
            String propertyName = property.toString();
            if (base == null ? AuditELContext.this.getReferences().containsKey(propertyName) : (base == AuditELContext.this.rule ? (reference = (Reference)AuditELContext.this.getReferences().get(propertyName)) instanceof ParameterReference : !(!(base instanceof Collection) && !(base instanceof Map) && !(base instanceof Object[]) || !"size".equals(propertyName) && !"length".equals(propertyName)))) {
                throw new PropertyNotWritableException();
            }
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (property == null) {
                return true;
            }
            String propertyName = property.toString();
            if (base == null) {
                if (AuditELContext.this.getReferences().containsKey(property.toString())) {
                    context.setPropertyResolved(true);
                }
            } else if (base == AuditELContext.this.rule) {
                Reference reference = (Reference)AuditELContext.this.getReferences().get(propertyName);
                if (reference instanceof ParameterReference) {
                    context.setPropertyResolved(true);
                }
            } else if ((base instanceof Collection || base instanceof Map || base instanceof Object[]) && ("size".equals(propertyName) || "length".equals(propertyName))) {
                context.setPropertyResolved(true);
            }
            return true;
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (base == null) {
                Map references = AuditELContext.this.getReferences();
                ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>(references.size());
                for (Map.Entry entry : references.entrySet()) {
                    FeatureDescriptor descriptor = new FeatureDescriptor();
                    descriptor.setName((String)entry.getKey());
                    descriptor.setValue("type", ((Reference)entry.getValue()).getType());
                    descriptor.setValue("resolvableAtDesignTime", true);
                    descriptors.add(descriptor);
                }
                return descriptors.iterator();
            }
            if (base == AuditELContext.this.rule) {
                Rule.Parameter[] parameters = AuditELContext.this.rule.parameters();
                ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>(parameters.length);
                for (Rule.Parameter parameter : parameters) {
                    FeatureDescriptor descriptor = new FeatureDescriptor();
                    descriptor.setName(parameter.getName());
                    descriptor.setValue("type", parameter.getType());
                    descriptor.setValue("resolvableAtDesignTime", false);
                    descriptors.add(descriptor);
                }
                return descriptors.iterator();
            }
            if (base instanceof Collection || base instanceof Map || base instanceof Object[]) {
                ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>(1);
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setName("size");
                descriptor.setValue("type", Integer.class);
                descriptor.setValue("resolvableAtDesignTime", true);
                descriptors.add(descriptor);
                return descriptors.iterator();
            }
            return null;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (base == null) {
                return String.class;
            }
            return null;
        }
    }

    private class UndeclaredParameterReference
    extends ParameterReference {
        private Object value;

        public UndeclaredParameterReference(Object value) {
            super(null);
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Class<?> getType() {
            return this.value.getClass();
        }
    }

    private class ParameterReference
    implements Reference {
        private Rule.Parameter parameter;

        public ParameterReference(Rule.Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object getValue() {
            if (AuditELContext.this.defer || AuditELContext.this.violation == null) {
                throw new PropertyDeferredException();
            }
            return AuditELContext.this.violation.getParameterValue(this.parameter.getName());
        }

        @Override
        public Class<?> getType() {
            return this.parameter.getType();
        }
    }

    private class BeanReference
    implements Reference {
        private Object bean;
        private Class<?> type;

        public BeanReference(Object bean, Class<?> type) {
            this.bean = bean;
            this.type = type;
        }

        @Override
        public Object getValue() {
            return this.bean;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }

    private class PropertyReference
    implements Reference {
        private Object bean;
        private PropertyDescriptor descriptor;

        public PropertyReference(Object bean, PropertyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.bean = bean;
        }

        @Override
        public Object getValue() {
            if (AuditELContext.this.defer) {
                throw new PropertyDeferredException();
            }
            try {
                return this.descriptor.getReadMethod().invoke(this.bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ELException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ELException((Throwable)e);
            }
        }

        @Override
        public Class<?> getType() {
            return this.descriptor.getPropertyType();
        }
    }

    private static interface Reference {
        public Object getValue();

        public Class<?> getType();
    }
}

