/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.awt.Dimension;
import java.awt.Font;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.JLabel;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.bean.AbstractTextField;
import oracle.jdevimpl.audit.AuditBundle;
import oracle.jdevimpl.audit.swing.MessageDialog;
import oracle.jdevimpl.audit.util.Strings;

public class PatternField
extends AbstractTextField {
    private static final FormatBundle BUNDLE = new FormatBundle(AuditBundle.class);

    @Override
    public Object getValue() {
        String text = (String)super.getValue();
        return text != null ? Pattern.compile(text) : null;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value != null ? ((Pattern)value).pattern() : null);
    }

    @Override
    public void handleException(Throwable e) {
        if (e instanceof PatternSyntaxException) {
            PatternSyntaxException exception = (PatternSyntaxException)e;
            int index = exception.getIndex();
            String description = exception.getDescription();
            int midpoint = description.length() / 2;
            if (midpoint < index) {
                description = Strings.fill(' ', index - midpoint) + description;
            }
            MessageDialog dialog = new MessageDialog(MessageDialog.WARNING);
            dialog.setTitle(BUNDLE.get("inspector.apply.exception.title"));
            String s1 = BUNDLE.get("inspector.apply.exception.message", new Object[]{this.getLabelText(), ""});
            JLabel j2 = new JLabel(exception.getPattern());
            JLabel j3 = new JLabel(Strings.fill(' ', index) + "^");
            JLabel j4 = new JLabel(description);
            Font font = new Font("Monospaced", 1, j4.getFont().getSize());
            j2.setFont(font);
            j3.setFont(font);
            j2.setPreferredSize(new Dimension(j2.getPreferredSize().width, font.getSize() + 2));
            j3.setPreferredSize(new Dimension(j3.getPreferredSize().width, font.getSize() + 2));
            j4.setPreferredSize(new Dimension(j4.getPreferredSize().width, font.getSize() + 2));
            dialog.setContent(new Object[]{s1, Box.createVerticalStrut(10), j2, j3, j4, Box.createVerticalStrut(10)});
            dialog.show(null);
        } else {
            super.handleException(e);
        }
    }
}

