/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import oracle.jdeveloper.audit.extension.DeferredExpression;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;

public abstract class Transform
extends ExtensionBean {
    public static final String BOUND_LABEL_KEY = "bound-label";
    private TransformAdapter adapter;
    private Localizer localizer;
    private boolean enabled = true;
    private DeferredExpression condition;

    protected Transform(TransformAdapter adapter) {
        this.adapter = adapter;
    }

    protected Transform(TransformAdapter adapter, String name) {
        super(name, null);
        this.adapter = adapter;
    }

    protected Transform(String id, String extensionId, TransformAdapter adapter) {
        super(id, extensionId);
        this.adapter = adapter;
    }

    protected Transform(TransformAdapter adapter, String name, Localizer localizer) {
        this(adapter, name);
        this.localizer = localizer;
        if (localizer != null) {
            this.setCompatibilityBundle(localizer.getBundle(), "transform." + name);
        }
    }

    @Override
    protected void copyInternalState(ExtensionBean bean, IdentityHashMap<Object, Object> context) throws InvocationTargetException {
        Transform transform = (Transform)bean;
        transform.adapter = this.adapter;
        transform.condition = this.condition;
        transform.localizer = this.localizer;
    }

    public TransformContext[] createContexts(Violation violation) {
        return new TransformContext[]{this.adapter().createContext(this, violation, violation.getLocation())};
    }

    public TransformAdapter adapter() {
        return this.adapter;
    }

    public DeferredExpression condition() {
        return this.condition;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Localizer localizer() {
        return this.localizer;
    }

    public String unboundLabel() {
        return Localizer.instantiate(this.string("label"), this, true);
    }

    public String boundLabel(TransformContext context) {
        String variation = context.getVariation();
        String string = this.formattedString(this.variationKey(BOUND_LABEL_KEY, variation), context);
        if (string == null && variation != null) {
            string = this.formattedString(this.variationKey(BOUND_LABEL_KEY, null), context);
        }
        if (string == null && (string = this.formattedString("label", context)) == null) {
            string = this.id();
        }
        return string;
    }

    private String variationKey(String key, String variation) {
        return variation != null ? variation + "." + key : key;
    }
}

