/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;

public final class ViolationHelper {
    private Object[] objects;
    private int bits;
    private static final Object[] EMPTY = new Object[0];
    private static final int TRANSFORM_OFFSET = 0;
    private static final int TRANSFORM_WIDTH = 15;
    private static final int TRANSFORM_MASK = Short.MAX_VALUE;
    private static final int DEFAULT_TRANSFORM_OFFSET = 15;
    private static final int DEFAULT_TRANSFORM_WIDTH = 4;
    private static final int DEFAULT_TRANSFORM_MASK = 15;
    private static final int PARAMETER_OFFSET = 19;
    private static final int PARAMETER_WIDTH = 8;
    private static final int PARAMETER_MASK = 255;
    private static final int FOCUS_OFFSET = 27;
    private static final int FOCUS_WIDTH = 1;
    private static final int FOCUS_BIT = 0x8000000;
    private static final int VARIATION_OFFSET = 28;
    private static final int VARIATION_WIDTH = 4;
    private static final int VARIATION_MASK = 15;

    public void pack(Violation violation, int transformMask) {
        Rule rule = violation.getRule();
        Location location = violation.getLocation();
        int defaultTransformIndex = -1;
        Transform defaultTransform = violation.getDefaultTransform();
        if (defaultTransform != null) {
            Transform[] transforms = rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (defaultTransform != transforms[i]) continue;
                defaultTransformIndex = i;
                break;
            }
        }
        int variationIndex = -1;
        String variation = violation.getVariation();
        if (variation != null) {
            String[] variations = rule.variations();
            for (int i = 0; i < variations.length; ++i) {
                if (!variations[i].equals(variation)) continue;
                variationIndex = i;
                break;
            }
        }
        int parameterCount = violation.getParameterCount();
        Location focusLocation = violation.getFocusLocation();
        int focusBit = focusLocation != null && !location.equals(focusLocation) ? 1 : 0;
        this.bits = ViolationHelper.packBits(transformMask, defaultTransformIndex, parameterCount, focusBit, variationIndex);
        int locationCount = 0;
        for (int i = 0; i < violation.getTransformCount(); ++i) {
            if (violation.getTransformFocusLocation(i) == null) continue;
            locationCount = i + 1;
        }
        int objectCount = parameterCount * 2 + focusBit + locationCount;
        if (objectCount > 0) {
            int i;
            this.objects = new Object[objectCount];
            int o = 0;
            for (i = 0; i < parameterCount; ++i) {
                this.objects[o++] = violation.getParameterName(i);
                this.objects[o++] = violation.getParameterValue(i);
            }
            if (focusBit != 0) {
                this.objects[o++] = focusLocation;
            }
            for (i = 0; i < locationCount; ++i) {
                this.objects[o++] = violation.getTransformFocusLocation(i);
            }
        } else {
            this.objects = EMPTY;
        }
        assert (parameterCount == ViolationHelper.unpackParameterCount(this.bits));
        assert (ViolationHelper.unpackDefaultTransform(this.bits, rule) == violation.getDefaultTransform());
        assert (ViolationHelper.unpackVariation(this.bits, rule) == violation.getVariation());
    }

    public int getBits() {
        return this.bits;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public static Location unpackFocusLocation(int bits, Object[] objects, Location location) {
        return ViolationHelper.focusCount(bits) == 0 ? location : ViolationHelper.focus(bits, objects);
    }

    public static String unpackVariation(int bits, Rule rule) {
        int index = ViolationHelper.variationIndex(bits);
        if (index < 0) {
            return null;
        }
        return rule.variations()[index];
    }

    public static int unpackParameterCount(int bits) {
        return ViolationHelper.parameterCount(bits);
    }

    public static String unpackParameterName(int bits, Object[] objects, int index) {
        assert (index < ViolationHelper.parameterCount(bits));
        return (String)objects[index *= 2];
    }

    public static Object unpackParameterValue(int bits, Object[] objects, int index) {
        assert (index < ViolationHelper.parameterCount(bits));
        index = index * 2 + 1;
        return objects[index];
    }

    public static Object unpackParameterValue(int bits, Object[] objects, String name) {
        int i = ViolationHelper.unpackParameterCount(bits);
        while (i-- > 0) {
            if (!name.equals(ViolationHelper.unpackParameterName(bits, objects, i))) continue;
            return ViolationHelper.unpackParameterValue(bits, objects, i);
        }
        return null;
    }

    public static int unpackTransformCount(int bits) {
        int mask = ViolationHelper.transformMask(bits);
        int count = 0;
        for (int i = 0; i < 15; ++i) {
            if ((mask & 1 << i) == 0) continue;
            ++count;
        }
        return count;
    }

    public static Transform unpackTransform(int bits, Rule rule, int index) {
        int mask = ViolationHelper.transformMask(bits);
        for (int i = 0; i < 15; ++i) {
            if ((mask & 1 << i) == 0 || index-- != 0) continue;
            return rule.getTransforms()[i];
        }
        throw new IndexOutOfBoundsException(index + " of " + ViolationHelper.unpackTransformCount(bits));
    }

    public static Location unpackTransformFocusLocation(int bits, Object[] objects, int index) {
        int locationIndex = ViolationHelper.parameterCount(bits) * 2 + ViolationHelper.focusCount(bits) + index;
        if (locationIndex >= objects.length) {
            return null;
        }
        Location location = (Location)objects[locationIndex];
        return location;
    }

    public static Transform unpackDefaultTransform(int bits, Rule rule) {
        int index = ViolationHelper.defaultTransformIndex(bits);
        if (index < 0) {
            return null;
        }
        return rule.getTransforms()[index];
    }

    private static int packBits(int transformMask, int defaultTransformIndex, int parameterCount, int focusBit, int variationIndex) {
        assert (transformMask <= Short.MAX_VALUE);
        assert (defaultTransformIndex + 1 <= 15);
        assert (defaultTransformIndex < 0 || (1 << defaultTransformIndex & transformMask) != 0);
        assert (parameterCount <= 255);
        assert (variationIndex + 1 <= 15);
        int bits = transformMask << 0 | defaultTransformIndex + 1 << 15 | parameterCount << 19 | focusBit << 27 | variationIndex + 1 << 28;
        assert (parameterCount == ViolationHelper.parameterCount(bits)) : "parameter count " + parameterCount + ", computed " + ViolationHelper.parameterCount(bits);
        return bits;
    }

    private static int transformMask(int bits) {
        return bits >> 0 & Short.MAX_VALUE;
    }

    private static int defaultTransformIndex(int bits) {
        int index = (bits >> 15 & 0xF) - 1;
        return index;
    }

    private static int parameterCount(int bits) {
        return bits >> 19 & 0xFF;
    }

    private static Location focus(int bits, Object[] objects) {
        if ((bits & 0x8000000) == 0) {
            return null;
        }
        return (Location)objects[ViolationHelper.parameterCount(bits) * 2];
    }

    private static int focusCount(int bits) {
        return bits >> 27 & 1;
    }

    private static int variationIndex(int bits) {
        int index = (bits >> 28 & 0xF) - 1;
        return index;
    }
}

