/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.ChangeListener;
import oracle.javatools.util.ChangeSupport;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.bean.PropertyChange;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.DefaultProfile;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.util.Beans;

public class ProfileTransaction
implements PropertyChangeListener {
    private DefaultProfile profile;
    private Profile.Instances instances;
    private MultiMap<String, PropertyChange> changes;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Thread thread;
    private static final Log LOG = new Log("profile", "profile-detail");

    private void preconditions() {
        assert (this.thread == Thread.currentThread()) : "transaction for profile '" + this.profile.getName() + "' created in thread '" + this.thread.getName() + "' but accessed in thread '" + Thread.currentThread().getName() + "'";
        assert (this.changes != null) : "transaction for profile '" + this.profile.getName() + "' already comitted";
    }

    public ProfileTransaction(DefaultProfile profile) {
        LOG.trace("transaction created for {0}", (Object)profile);
        this.profile = profile;
        this.changes = new MultiMap();
        this.thread = Thread.currentThread();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Profile getProfile() {
        return this.profile;
    }

    private Profile.Instances getInstances() {
        this.preconditions();
        if (this.instances == null) {
            this.instances = this.profile.createInstances();
            for (ExtensionBean bean : this.instances.getBeans()) {
                bean.addPropertyChangeListener(this);
            }
        }
        return this.instances;
    }

    public Collection<ExtensionBean> getBeans() {
        return this.getInstances().getBeans();
    }

    public ExtensionBean getBean(String id) {
        return this.getInstances().getBean(id);
    }

    public boolean isModified() {
        this.preconditions();
        return !this.changes.isEmpty();
    }

    public boolean isModified(String id) {
        return this.changes.containsKey((Object)id);
    }

    public void apply() {
        LOG.trace("applying {0}", (Object)this);
        if (!this.changes.isEmpty()) {
            this.profile.applyChanges(this.getBeans());
            this.changes.clear();
            this.changeSupport.fireStateChanged();
        }
        LOG.trace("completed applying {0}", (Object)this);
    }

    public Profile create(String name) {
        LOG.trace("copying {0}", (Object)this);
        return new DefaultProfile(name, this.getBeans());
    }

    public void revert() {
        LOG.trace("reverting {0}", (Object)this);
        MultiMap copy = new MultiMap(this.changes);
        for (Map.Entry entry : copy.entrySet()) {
            String id = (String)entry.getKey();
            ExtensionBean bean = this.getBean(id);
            for (PropertyChange change : (Collection)entry.getValue()) {
                try {
                    change.getProperty().getWriteMethod().invoke((Object)bean, change.getOldValue());
                }
                catch (Throwable e) {
                    Log.error((String)"Exception introspecting changes for bean '{0}': {1}", (Object)bean.id(), (Object)e);
                }
            }
        }
        assert (this.changes.isEmpty()) : "expected {}, actual " + this.changes;
        LOG.trace("completed reverting {0}", (Object)this);
    }

    public void setProperties(Profile profile) {
        LOG.trace("setting properties of {0} from {1}", (Object)this, (Object)profile);
        this.preconditions();
        Profile.Instances fromInstances = profile.createInstances();
        Profile.Instances toInstances = this.getInstances();
        for (ExtensionBean fromBean : fromInstances.getBeans()) {
            String id = fromBean.id();
            ExtensionBean toBean = toInstances.getBean(id);
            try {
                for (PropertyDescriptor property : Introspector.getBeanInfo(fromBean.getClass()).getPropertyDescriptors()) {
                    Method getter;
                    Method setter = property.getWriteMethod();
                    if (setter == null || (getter = property.getReadMethod()) == null) continue;
                    setter.invoke((Object)toBean, getter.invoke((Object)fromBean, new Object[0]));
                }
            }
            catch (Throwable e) {
                Log.error((String)"Exception introspecting changes for bean '{0}': {1}", (Object)id, (Object)e);
            }
        }
        LOG.trace("completed setting properties of {0} from {1}", (Object)this, (Object)profile);
    }

    public void setProperties(ProfileTransaction transaction) {
        LOG.trace("setting properties of {0} from {1}", (Object)this, (Object)transaction);
        this.preconditions();
        if (transaction == this) {
            throw new IllegalArgumentException("transaction = this");
        }
        Profile.Instances fromInstances = transaction.getInstances();
        Profile.Instances toInstances = this.getInstances();
        for (ExtensionBean fromBean : fromInstances.getBeans()) {
            String id = fromBean.id();
            ExtensionBean toBean = toInstances.getBean(id);
            try {
                for (PropertyDescriptor property : Introspector.getBeanInfo(fromBean.getClass()).getPropertyDescriptors()) {
                    Method getter;
                    Method setter = property.getWriteMethod();
                    if (setter == null || (getter = property.getReadMethod()) == null) continue;
                    setter.invoke((Object)toBean, getter.invoke((Object)fromBean, new Object[0]));
                }
            }
            catch (Throwable e) {
                Log.error((String)"Exception introspecting changes for bean '{0}': {1}", (Object)id, (Object)e);
            }
        }
        LOG.trace("completed setting properties of {0} from {1}", (Object)this, (Object)transaction);
    }

    public void setProperty(String id, String propertyName, Object value) {
        LOG.trace("setting property {0} of {1} in {2} to {3}", (Object)propertyName, (Object)id, (Object)this, value);
        this.preconditions();
        ExtensionBean bean = this.getInstances().getBean(id);
        if (bean == null) {
            throw new IllegalArgumentException("bean '" + id + "' not found");
        }
        try {
            PropertyDescriptor property = Beans.getProperty(bean, propertyName);
            property.getWriteMethod().invoke((Object)bean, value);
        }
        catch (Throwable e) {
            Log.error((String)"Exception introspecting changes for bean '{0}': {1}", (Object)bean.id(), (Object)e);
        }
        LOG.trace("completed setting property {0} of {1} in {2} to {3}", (Object)propertyName, (Object)id, (Object)this, value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        ExtensionBean bean = (ExtensionBean)event.getSource();
        String id = bean.id();
        String propertyName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        LOG.trace("handling property '{0}:{1}' in {2} changed from '{3}' to '{4}'", (Object)id, (Object)propertyName, (Object)this, oldValue, newValue);
        if (bean != this.getBean(id)) {
            throw new IllegalArgumentException("changed bean not in transaction");
        }
        if (oldValue == newValue) {
            return;
        }
        try {
            PropertyDescriptor property = Beans.getProperty(bean, propertyName);
            if (property != null) {
                this.mergeChange(id, new PropertyChange(property, oldValue, newValue));
            } else {
                LOG.trace("ignoring unconventional property {0} change in bean {1}", (Object)propertyName, (Object)id);
            }
        }
        catch (Throwable e) {
            Log.error((String)"Exception introspecting changes for bean '{0}': {1}", (Object)id, (Object)e);
        }
        this.propertyChangeSupport.firePropertyChange(event);
    }

    private void mergeChange(String id, PropertyChange change) {
        boolean isModified;
        LOG.trace("merging {0} to {1} in {2}: {3}", (Object)change, (Object)id, (Object)this, this.changes);
        this.preconditions();
        if (this.changes == null) {
            this.changes = new MultiMap();
        }
        boolean wasModified = !this.changes.isEmpty();
        boolean newChange = true;
        Collection oldChanges = this.changes.get((Object)id);
        if (oldChanges != null) {
            for (PropertyChange oldChange : oldChanges) {
                if (!change.getPropertyName().equals(oldChange.getPropertyName())) continue;
                newChange = false;
                Object oldValue = oldChange.getOldValue();
                Object newValue = change.getNewValue();
                this.changes.remove((Object)id, (Object)oldChange);
                if (ProfileTransaction.equals(oldValue, newValue)) break;
                this.changes.add((Object)id, (Object)new PropertyChange(change.getProperty(), oldValue, newValue));
                break;
            }
        }
        if (newChange) {
            this.changes.add((Object)id, (Object)change);
        }
        boolean bl = isModified = !this.changes.isEmpty();
        if (wasModified != isModified) {
            this.changeSupport.fireStateChanged();
        }
        LOG.trace("completed merging {0} to {1}: {2}", (Object)change, (Object)id, this.changes);
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? null == o2 : o1.equals(o2);
    }

    public String toString() {
        return "transaction " + this.profile.getName() + " (" + this.changes.size() + ")}";
    }
}

