/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.ChangeListener;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.ProfileTransaction;

public abstract class Profile {
    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public abstract String getName();

    public abstract boolean isDefault();

    public abstract String getKey();

    public abstract URL getURL();

    public abstract Collection<Class<? extends Analyzer>> getAnalyzerClasses();

    public abstract Instances createInstances();

    public abstract ProfileTransaction createTransaction();

    public abstract void save(URL var1) throws IOException;

    public static class Setter {
        protected Object[] value;
        protected Method method;

        public Setter(Method method, Object value) {
            this.method = method;
            this.value = new Object[]{value};
        }

        public Object getValue() {
            return this.value[0];
        }

        public void invoke(Object target) {
            try {
                this.method.invoke(target, this.value);
            }
            catch (IllegalAccessException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new UnexpectedExceptionError((Throwable)e);
            }
        }

        public String toString() {
            return this.method.getName() + '(' + String.valueOf(this.value[0]) + ')';
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public static class Instances {
        private Map<Class<? extends Analyzer>, Analyzer> analyzers;
        private Map<String, ExtensionBean> beans;
        private Map<Analyzer, Collection<ExtensionBean>> beansPerAnalyzer;

        public Instances(Map<Class<? extends Analyzer>, Analyzer> analyzers, Map<String, ExtensionBean> beans, Map<Analyzer, Collection<ExtensionBean>> beansPerAnalyzer) {
            this.analyzers = analyzers;
            this.beans = beans;
            this.beansPerAnalyzer = beansPerAnalyzer;
        }

        public Analyzer getAnalyzer(Class<? extends Analyzer> analyzerClass) {
            return this.analyzers.get(analyzerClass);
        }

        public Collection<Analyzer> getAnalyzers() {
            return this.analyzers.values();
        }

        public Collection<ExtensionBean> getBeans() {
            return this.beans.values();
        }

        public ExtensionBean getBean(String id) {
            return this.beans.get(id);
        }

        public Map<Analyzer, Collection<ExtensionBean>> getBeansByAnalyzer() {
            return this.beansPerAnalyzer;
        }
    }
}

