/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.javatools.util.NullResourceBundle;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import oracle.jdeveloper.audit.service.Violation;

public class Localizer {
    private static final Map<CacheKey, Localizer> localizers = new HashMap<CacheKey, Localizer>();
    private String bundleName;
    private ResourceBundle bundle;
    private static final int SPACES = 0x200020;
    private static final int QUOTES = 0x220022;
    private static final int APOSTROPHES = 0x270027;

    public static synchronized Localizer instance(String bundleName) {
        return Localizer.instance(bundleName, null);
    }

    public static synchronized Localizer instance(String bundleName, ClassLoader loader) {
        CacheKey cacheKey = new CacheKey(bundleName, loader);
        Localizer localizer = localizers.get(cacheKey);
        if (localizer != null) {
            return localizer;
        }
        localizer = new Localizer(bundleName, loader);
        localizers.put(cacheKey, localizer);
        return localizer;
    }

    public static synchronized Localizer instance(Class bundleClass) {
        return Localizer.instance(bundleClass.getName(), bundleClass.getClassLoader());
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public String localize(String key, Object object) {
        try {
            return Localizer.instantiate(this.bundle.getString(key), object);
        }
        catch (MissingResourceException e) {
            return "?" + key + ": " + String.valueOf(object);
        }
    }

    public String localize(String key1, String key2, Object object) {
        try {
            return Localizer.instantiate(this.bundle.getString(key1), object);
        }
        catch (MissingResourceException e) {
            try {
                return Localizer.instantiate(this.bundle.getString(key2), object);
            }
            catch (MissingResourceException f) {
                return "?" + key1 + ": " + String.valueOf(object);
            }
        }
    }

    protected Localizer(String bundleName, ClassLoader loader) {
        this.bundleName = bundleName;
        try {
            this.bundle = this.getBundle(bundleName, loader);
        }
        catch (MissingResourceException e) {
            this.bundle = NullResourceBundle.instance();
        }
    }

    protected ResourceBundle getBundle(String bundleName, ClassLoader loader) throws MissingResourceException {
        if (loader == null) {
            return ResourceBundle.getBundle(bundleName);
        }
        return ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
    }

    public static String instantiate(String message, Object bean) {
        return Localizer.instantiate(message, bean, false);
    }

    public static String instantiate(String message, Object bean, boolean erase) {
        if (message == null) {
            return null;
        }
        int length = message.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        int i = 0;
        while (true) {
            int bufferLength;
            int pair;
            int i0 = i;
            while (true) {
                if (i == length) {
                    buffer.append(message.substring(i0));
                    return buffer.toString();
                }
                char c = message.charAt(i);
                if (c == '{') break;
                ++i;
            }
            buffer.append(message.substring(i0, i));
            int brace = i++;
            i0 = i;
            while (true) {
                if (i == length) {
                    buffer.append(message.substring(brace));
                    return buffer.toString();
                }
                char c = message.charAt(i);
                if (c == '}') break;
                ++i;
            }
            Object parameter = Localizer.getValue(message, i0, i++, bean);
            boolean missing = false;
            boolean empty = false;
            if (parameter instanceof Object[]) {
                Object[] array = (Object[])parameter;
                if (array.length > 0) {
                    buffer.append(array[0]);
                    for (int j = 1; j < array.length; ++j) {
                        buffer.append(", ");
                        buffer.append(array[j]);
                    }
                } else {
                    empty = true;
                }
            } else if (parameter instanceof TypeSafeEnumeration) {
                TypeSafeEnumerationFactory factory = TypeSafeEnumerationFactory.factory(parameter.getClass());
                if (factory != null) {
                    buffer.append(factory.label(parameter));
                } else {
                    buffer.append(parameter);
                }
            } else if (parameter != null) {
                String string = String.valueOf(parameter);
                buffer.append(string);
                empty = string.isEmpty();
            } else {
                missing = true;
            }
            if (missing) {
                if (erase) {
                    int bufferLength2 = buffer.length();
                    if (bufferLength2 <= 0 || i >= length) continue;
                    pair = buffer.charAt(bufferLength2 - 1) << 16 | message.charAt(i);
                    if (pair == 0x220022 || pair == 0x270027) {
                        buffer.setLength(--bufferLength2);
                        if (bufferLength2 > 0 && ++i < length) {
                            pair = buffer.charAt(bufferLength2 - 1) << 16 | message.charAt(i);
                        }
                    }
                    if (pair != 0x200020) continue;
                    ++i;
                    continue;
                }
                buffer.append(message, i0 - 1, i);
                continue;
            }
            if (!empty || (bufferLength = buffer.length()) <= 0 || i >= length || (pair = buffer.charAt(bufferLength - 1) << 16 | message.charAt(i)) != 0x200020) continue;
            ++i;
        }
    }

    protected static Object getValue(String string, int first, int last, Object bean) {
        if (bean instanceof Violation) {
            char c;
            Violation context = (Violation)bean;
            int dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            if (dot - first == 1 && Character.isDigit(c = string.charAt(first))) {
                int index = c - 48;
                if (index >= context.getParameterCount()) {
                    return null;
                }
                return context.getParameterValue(index);
            }
            bean = context.getParameterValue(string.substring(first, dot));
            if (bean == null) {
                return null;
            }
            first = dot + 1;
        }
        while (first < last && bean != null) {
            int dot = string.indexOf(46, first);
            if (dot < 0 || dot > last) {
                dot = last;
            }
            int nameLength = dot - first;
            if (bean instanceof Map) {
                bean = ((Map)bean).get(string.substring(first, dot));
            } else {
                StringBuffer methodName = new StringBuffer(3 + nameLength);
                methodName.append("get");
                if (nameLength <= 1) {
                    methodName.append(string.charAt(first));
                } else {
                    methodName.append(Character.toUpperCase(string.charAt(first)));
                    methodName.append(string.substring(first + 1, dot));
                }
                try {
                    Method method;
                    if (bean instanceof Object[]) {
                        method = bean.getClass().getComponentType().getMethod(methodName.toString(), null);
                        Object[] array = bean;
                        Object[] newArray = (Object[])Array.newInstance(method.getReturnType(), array.length);
                        for (int j = 0; j < array.length; ++j) {
                            newArray[j] = method.invoke(bean, null);
                        }
                        bean = newArray;
                    } else {
                        method = bean.getClass().getMethod(methodName.toString(), null);
                        bean = method.invoke(bean, null);
                    }
                }
                catch (Throwable e) {
                    return null;
                }
            }
            first = dot + 1;
        }
        return bean;
    }

    private static final class CacheKey
    implements Cloneable {
        private String name;
        private ClassLoader loader;
        private int hashCodeCache;

        CacheKey(String baseName, ClassLoader loader) {
            this.name = baseName;
            this.loader = loader;
            this.hashCodeCache = this.name.hashCode() * 31;
            if (loader != null) {
                this.hashCodeCache ^= loader.hashCode();
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && other instanceof CacheKey) {
                CacheKey otherEntry = (CacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.name.equals(otherEntry.name)) {
                    return false;
                }
                if (this.loader == null) {
                    return otherEntry.loader == null;
                }
                return otherEntry.loader != null && this.loader == otherEntry.loader;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public String toString() {
            return "CacheKey[" + this.name + ", lc=" + Locale.getDefault() + ", ldr=" + this.loader + "]";
        }
    }
}

