/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Log;

public class Editors {
    private static final Log LOG = new Log("editors");

    public static boolean editNode(Workspace workspace, Project project, Node node, int offset, int length, boolean spanLines) {
        Class editorClass;
        Editor editor;
        LineMap map;
        int lengthToEOL;
        TextBuffer buffer;
        Ide.setActiveProject((Project)project);
        Ide.setActiveWorkspace((Workspace)workspace);
        if (offset < 0) {
            offset = 0;
        }
        if (length < 0) {
            length = 0;
        } else if (!spanLines && node instanceof TextNode && (buffer = ((TextNode)node).acquireTextBuffer()) != null && (lengthToEOL = (map = buffer.getLineMap()).getLineEndOffset(map.getLineFromOffset(offset)) - offset) > 1 && lengthToEOL < length) {
            length = lengthToEOL;
        }
        Context context = Context.newIdeContext((Node)node);
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager == null) {
            return false;
        }
        EditorPath path = editorManager.searchEditor(node);
        Editor editor2 = editor = path instanceof EditorPathImpl ? ((EditorPathImpl)path).getTabGroupState().getCurrentEditor() : null;
        if (editor != null) {
            editorClass = editor.getClass();
            LOG.trace("");
        } else {
            EditorAddin editorAddin = editorManager.getBestEditorAddin(node);
            editorClass = editorAddin != null ? editorAddin.getEditorClass() : CodeEditor.class;
        }
        try {
            if (editorClass == CodeEditor.class) {
                NavigationManager navigator = NavigationManager.getNavigationManager();
                if (navigator == null) {
                    return false;
                }
                OffsetNavigationPoint point = new OffsetNavigationPoint(context, offset, length);
                navigator.navigateTo((NavigationPoint)point);
            } else {
                editorManager.openEditor(new OpenEditorOptions(context, editorClass));
            }
        }
        catch (Exception e) {
            Log.error((String)"opening {0} failed: {1}", (Object)node, (Object)e);
            return false;
        }
        return true;
    }
}

