/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AuditLogger {
    private static final Logger LOGGER = Logger.getLogger("oracle.ide.audit");

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void error(String message, Object ... arguments) {
        int length;
        LogRecord record = new LogRecord(Level.SEVERE, message);
        if (arguments != null && (length = arguments.length) > 0) {
            record.setParameters(arguments);
            Object lastArgument = arguments[length - 1];
            if (lastArgument instanceof Throwable) {
                record.setThrown((Throwable)lastArgument);
            }
        }
        LOGGER.log(record);
    }

    public static void error(String message, Throwable exception, Object ... arguments) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        if (exception != null) {
            record.setThrown(exception);
        }
        if (arguments != null && arguments.length > 0) {
            record.setParameters(arguments);
        }
        LOGGER.log(record);
    }

    public static void warning(String message, Object ... arguments) {
        LOGGER.log(Level.WARNING, message, arguments);
    }

    public static void informational(String message, Object ... arguments) {
        LOGGER.log(Level.INFO, message, arguments);
    }

    public static void log(Level level, String message, Object ... arguments) {
        LOGGER.log(level, message, arguments);
    }
}

