/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.lang.reflect.Method;
import java.net.URL;
import java.text.CollationKey;
import java.text.Collator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileModelAdapter;
import oracle.jdeveloper.audit.model.Located;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public abstract class ModelAdapter
implements Comparable,
Located {
    protected static final Log log = new Log("node");
    private final ModelFactory factory;
    private final ModelType type;
    private final Element element;
    private final ContainerModelAdapter workspaceKey;
    private final ContainerModelAdapter projectKey;
    private final ContainerModelAdapter directoryKey;
    private final CollationKey shortKey;
    private CollationKey longKey;
    protected int index = 0;
    private Location location;
    private Map<Object, Object> attributes;
    private ReadWriteLock nodeLock;
    private volatile Context ideContext;
    private static Method lockMethod;

    protected ModelAdapter(ModelFactory factory, ModelType type) {
        this.factory = factory;
        this.type = type;
        this.element = Ide.getWorkspaces();
        this.workspaceKey = null;
        this.projectKey = null;
        this.directoryKey = null;
        this.shortKey = Collator.getInstance().getCollationKey(this.element.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, Workspace workspace) {
        this.factory = factory;
        this.type = type;
        this.element = workspace;
        this.workspaceKey = (ContainerModelAdapter)this;
        this.projectKey = null;
        this.directoryKey = null;
        this.shortKey = Collator.getInstance().getCollationKey(workspace.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, Project project) {
        this.factory = factory;
        this.type = type;
        this.element = project;
        this.workspaceKey = workspace;
        this.projectKey = (ContainerModelAdapter)this;
        this.directoryKey = null;
        this.shortKey = Collator.getInstance().getCollationKey(project.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, ContentDirectory element, URL url) {
        assert (URLFileSystem.equals((URL)url, (URL)element.getURL()));
        this.factory = factory;
        this.type = type;
        this.element = element;
        this.workspaceKey = workspace;
        this.projectKey = project;
        this.directoryKey = (ContainerModelAdapter)this;
        this.shortKey = Collator.getInstance().getCollationKey(element.getShortLabel());
        this.location = this.getLocation(0, Integer.MAX_VALUE);
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url) {
        this(factory, type, workspace, project, directory, node, url, URLFileSystem.getFileName((URL)url));
    }

    protected ModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url, String primaryCollationString) {
        assert (URLFileSystem.equals((URL)url, (URL)node.getURL()));
        this.factory = factory;
        this.type = type;
        this.element = node;
        this.workspaceKey = workspace;
        this.projectKey = project;
        this.directoryKey = directory;
        this.shortKey = Collator.getInstance().getCollationKey(primaryCollationString);
    }

    public ContentDirectory getDirectory() {
        return this.directoryKey != null ? this.directoryKey.getDirectory() : null;
    }

    public Element getElement() {
        return this.element;
    }

    public Location getEndLocation() {
        return this.getLocation(Integer.MAX_VALUE, 0);
    }

    public final ModelFactory getFactory() {
        return this.factory;
    }

    public Context getIdeContext() {
        if (this.ideContext == null) {
            Workspace workspace = this.getWorkspace();
            Project project = this.getProject();
            Node node = this.getNode();
            if (node == workspace) {
                project = null;
                workspace = null;
            } else if (node == project) {
                project = null;
            }
            Context context = new Context(workspace, project);
            context.setNode(node);
            context.setBoolean("Context.INTENTIONAL_NULL", true);
            this.ideContext = context;
        }
        return this.ideContext;
    }

    public int getInitialLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Location getLocation() {
        if (this.location == null) {
            this.location = this.getLocation(0, Integer.MAX_VALUE);
        }
        return this.location;
    }

    public Location getLocation(int offset, int length) {
        if (offset <= Short.MAX_VALUE && length <= Short.MAX_VALUE) {
            return new LocationShort(this, (short)offset, (short)length);
        }
        return new LocationInt(this, offset, length);
    }

    public Node getNode() {
        return this.element instanceof Node ? (Node)this.element : null;
    }

    public Project getProject() {
        return this.projectKey != null ? this.projectKey.getProject() : null;
    }

    public String getShortLabel() {
        return this.shortKey.getSourceString();
    }

    public final ModelType getType() {
        return this.type;
    }

    public abstract URL getUrl();

    public final URL getURL() {
        return this.getUrl();
    }

    public Workspace getWorkspace() {
        return this.workspaceKey.getWorkspace();
    }

    public abstract boolean isFile();

    public boolean isModifiable() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isModified(Location location) {
        return false;
    }

    public final void beginRead() {
        this.beginRead(null);
    }

    public final boolean beginRead(WriteLockRequestListener listener) {
        log.trace("begin read on {0}", (Object)this);
        boolean waiting = this.acquireReadLock(listener);
        this.beginReadHook();
        return waiting;
    }

    public final void endRead() {
        this.endRead(null);
    }

    public final void endRead(WriteLockRequestListener listener) {
        log.trace("end read on {0}", (Object)this);
        this.endReadHook();
        this.releaseReadLock(listener);
    }

    public void cancelRead() {
    }

    protected boolean acquireReadLock(WriteLockRequestListener listener) {
        return false;
    }

    protected void releaseReadLock(WriteLockRequestListener listener) {
    }

    protected void beginReadHook() {
    }

    protected void endReadHook() {
    }

    protected synchronized ReadWriteLock getLock() {
        if (this.nodeLock == null) {
            Node node = this.getNode();
            if (node != null) {
                try {
                    if (lockMethod == null) {
                        lockMethod = Node.class.getDeclaredMethod("nodeLock", null);
                        lockMethod.setAccessible(true);
                    }
                    this.nodeLock = (ReadWriteLock)lockMethod.invoke((Object)node, (Object[])null);
                }
                catch (Throwable e) {
                    throw new UnexpectedExceptionError(e);
                }
            } else {
                this.nodeLock = new ReadWriteLock(this.shortKey.getSourceString());
            }
        }
        return this.nodeLock;
    }

    public final void verifyReadTransaction() {
    }

    public boolean isEditable(Location location) {
        return false;
    }

    public boolean edit(Location location) {
        return false;
    }

    public char getCharacter(int offset) {
        return '\u0000';
    }

    public int getColumnOffset(int offset) {
        return offset;
    }

    public Object getConstruct(Location location) {
        Object containingConstruct = this.getRoot();
        log.trace("getting construct for {0}", (Object)location);
        assert (this == location.getModel());
        if (location.isRoot()) {
            return this.getRoot();
        }
        block0: while (true) {
            Iterator i = this.getContainedConstructs(containingConstruct);
            while (i.hasNext()) {
                Object construct = i.next();
                if (!this.contains(construct, location)) continue;
                containingConstruct = construct;
                continue block0;
            }
            break;
        }
        return containingConstruct;
    }

    public Object getConstruct(Location location, Object parentConstruct) {
        log.trace("getting construct for {0} relative to {1}", (Object)location, parentConstruct);
        assert (this.contains(parentConstruct, location));
        Iterator i = this.getContainedConstructs(parentConstruct);
        while (i.hasNext()) {
            Object childConstruct = i.next();
            if (!this.contains(childConstruct, location)) continue;
            return childConstruct;
        }
        return null;
    }

    public abstract Iterator getContainedConstructs(Object var1);

    public Dependency getDependency() {
        return new NullDependency();
    }

    public abstract Location[] getElementLocations(Element var1);

    public Location getFocusLocation(Object construct, Location location) {
        assert (location != null);
        assert (!location.isRoot() ? location.equals(this.getLocation(construct)) : this.getLocation(location.getModel().getRoot()).equals(this.getLocation(construct)));
        return location;
    }

    public Location getFocusLocation(Location location) {
        return location;
    }

    public String getLine(int offset) {
        return null;
    }

    public int getLineOffset(int offset) {
        return 0;
    }

    public abstract Location getLocation(Object var1);

    public abstract Object getRoot();

    public String getText(int offset, int length) {
        return null;
    }

    public boolean equals(Object object) {
        assert (!(object instanceof ModelAdapter) || this.getFactory() == ((ModelAdapter)object).getFactory()) : "generation mismatch: " + this + " - " + object;
        return super.equals(object);
    }

    public abstract int compareTo(Object var1);

    protected static int compareSiblings(ModelAdapter d1, ModelAdapter d2) {
        if (d1 == null) {
            return d2 != null ? -1 : 0;
        }
        if (d2 == null) {
            return 1;
        }
        if (d1.index > 0) {
            return d1.index - d2.index;
        }
        int comparison = d1.shortKey.compareTo(d2.shortKey);
        if (comparison != 0) {
            return comparison;
        }
        return d1.getSecondaryCollationKey().compareTo(d2.getSecondaryCollationKey());
    }

    public boolean contains(Location location) {
        ModelAdapter model = location.getModel();
        return this.contains(model);
    }

    public abstract boolean contains(ModelAdapter var1);

    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location.getModel();
        assert (this == location.getModel());
        return this.getLocation(construct).contains(location);
    }

    protected String getSecondaryCollationString() {
        return URLFileSystem.getPlatformPathName((URL)this.getUrl());
    }

    public String toString() {
        return this.shortKey.getSourceString();
    }

    protected final CollationKey getPrimaryCollationKey() {
        return this.shortKey;
    }

    protected CollationKey getSecondaryCollationKey() {
        if (this.longKey == null) {
            this.longKey = Collator.getInstance().getCollationKey(this.getSecondaryCollationString());
        }
        return this.longKey;
    }

    public ContainerModelAdapter getWorkspaceAdapter() {
        return this.workspaceKey;
    }

    public ContainerModelAdapter getProjectAdapter() {
        return this.projectKey;
    }

    public ContainerModelAdapter getDirectoryAdapter() {
        return this.directoryKey;
    }

    public FileModelAdapter getFileAdapter() {
        return null;
    }

    public abstract ContainerModelAdapter getContainingAdapter();

    public abstract Object label(Object var1);

    public abstract Object summary(Object var1);

    public abstract Icon icon(Object var1);

    public Object label(Location location) {
        return this.label(location.getModel().getConstruct(location));
    }

    public Object summary(Location location) {
        return this.summary(location.getModel().getConstruct(location));
    }

    public Icon icon(Location location) {
        return this.icon(location.getModel().getConstruct(location));
    }

    public void setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public void release() {
    }

    public String contextDescription(Location location) {
        return location.toString();
    }

    public void enter(AuditContext context) {
    }

    public void exit(AuditContext context) {
    }

    private class NullDependency
    extends Dependency {
        private NullDependency() {
        }

        @Override
        protected void attach() {
        }

        @Override
        protected void detach() {
        }

        @Override
        protected String getShortDescription() {
            return ModelAdapter.this.getShortLabel();
        }

        @Override
        protected String getLongDescription() {
            return ModelAdapter.this.getSecondaryCollationString();
        }
    }

    static class LocationShort
    extends Location {
        private final short offset;
        private final short length;

        LocationShort(ModelAdapter model, short offset, short length) {
            super(model);
            this.offset = offset;
            this.length = length;
        }

        @Override
        int offset() {
            return this.offset;
        }

        @Override
        int length() {
            return this.length;
        }
    }

    static class LocationInt
    extends Location {
        private final int offset;
        private final int length;

        LocationInt(ModelAdapter model, int offset, int length) {
            super(model);
            assert (offset == 0 || length < Integer.MAX_VALUE);
            this.offset = offset;
            this.length = length;
        }

        @Override
        int offset() {
            return this.offset;
        }

        @Override
        int length() {
            return this.length;
        }
    }
}

