/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.model.Located;
import oracle.jdeveloper.audit.model.ModelAdapter;

public abstract class Location
implements Comparable<Location>,
Located {
    private final ModelAdapter model;

    public Location(ModelAdapter model) {
        this.model = model;
    }

    @Override
    public final Location getLocation() {
        return this;
    }

    public boolean isRoot() {
        return this.offset() == 0 && this.length() == Integer.MAX_VALUE;
    }

    public Workspace getWorkspace() {
        return this.model.getWorkspace();
    }

    public Project getProject() {
        return this.model.getProject();
    }

    public ModelAdapter getModel() {
        return this.model;
    }

    public int getOffset() {
        int offset = this.offset();
        if (offset == Integer.MAX_VALUE) {
            offset = this.model.getInitialLength();
        }
        return offset;
    }

    public int getLength() {
        int length = this.length();
        if (length == Integer.MAX_VALUE) {
            length = this.model.getInitialLength();
        }
        return length;
    }

    public int getEndOffset() {
        return this.getOffset() + this.getLength();
    }

    public Location getBeginning() {
        return this.getModel().getLocation(this.getOffset(), 0);
    }

    public Location getEnd() {
        return this.getModel().getLocation(this.getOffset() + this.getLength(), 0);
    }

    public boolean contains(Location that) {
        if (this.model == null) {
            return true;
        }
        ModelAdapter thatModel = that.getModel();
        if (thatModel == null) {
            return false;
        }
        if (this.model.equals(thatModel)) {
            int thatOffset;
            int thisOffset = this.getOffset();
            return thisOffset <= (thatOffset = that.getOffset()) && thisOffset + this.getLength() >= thatOffset + that.getLength();
        }
        return this.model.contains(that);
    }

    @Override
    public int compareTo(Location that) {
        ModelAdapter thatModel;
        ModelAdapter thisModel = this.getModel();
        int comparison = thisModel.compareTo(thatModel = that.getModel());
        if (comparison == 0) {
            comparison = this.getOffset() - that.getOffset();
            if (comparison == 0) {
                int thisOffset = this.offset();
                int thatOffset = that.offset();
                if (thisOffset == Integer.MAX_VALUE || thatOffset == Integer.MAX_VALUE) {
                    comparison = thisOffset - thatOffset;
                } else {
                    comparison = that.getLength() - this.getLength();
                    if (comparison == 0) {
                        int thisLength = this.length();
                        int thatLength = that.length();
                        if (thisLength == Integer.MAX_VALUE || thatLength == Integer.MAX_VALUE) {
                            comparison = thatLength - thisLength;
                        }
                    }
                }
            }
        } else if (comparison < 0) {
            if (this.offset() == Integer.MAX_VALUE && thisModel.contains(that)) {
                comparison = 1;
            }
        } else if (that.offset() == Integer.MAX_VALUE && thatModel.contains(this)) {
            comparison = -1;
        }
        return comparison;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Location)) {
            return false;
        }
        Location that = (Location)object;
        return this.model.equals(that.model) && this.offset() == that.offset() && this.length() == that.length();
    }

    public int hashCode() {
        int result = this.model.hashCode();
        result = 37 * result + this.offset();
        return 37 * result + this.length();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int offset = this.offset();
        int length = this.length();
        if (offset != 0 || length != Integer.MAX_VALUE) {
            builder.append(this.model);
            int adjustedOffset = this.getOffset();
            int adjustedLength = this.getLength();
            builder.append(" [");
            builder.append(adjustedOffset);
            builder.append(':');
            builder.append(adjustedOffset + adjustedLength);
            builder.append(')');
            if (offset != adjustedOffset || length != adjustedLength) {
                builder.append("[");
                builder.append(offset);
                builder.append(':');
                builder.append(offset + length);
                builder.append(")");
            }
        } else {
            builder.append(this.model);
            builder.append(" []");
        }
        return builder.toString();
    }

    int getInitialUnadjustedOffset() {
        int offset = this.offset();
        if (offset == Integer.MAX_VALUE) {
            offset = this.model.getInitialLength();
        }
        return offset;
    }

    int getInitialUnadjustedLength() {
        int length = this.length();
        if (length == Integer.MAX_VALUE) {
            length = this.model.getInitialLength();
        }
        return length;
    }

    abstract int offset();

    abstract int length();
}

