/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.util.CharArrayCharSequence;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;

class DependencyTextBufferListener
implements TextBufferListener {
    private static final Map<URL, DependencyTextBufferListener> listeners = new HashMap<URL, DependencyTextBufferListener>();
    private static final Log LOCK_LOG = new Log("status-lock");
    private URL file;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDependency(Dependency dependency, URL file) {
        DependencyTextBufferListener listener;
        Map<URL, DependencyTextBufferListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(file);
            if (listener == null) {
                listener = new DependencyTextBufferListener(file);
                listeners.put(file, listener);
            }
        }
        listener.addDependency(file, dependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDependency(Dependency dependency, URL file) {
        boolean removed;
        DependencyTextBufferListener listener;
        Map<URL, DependencyTextBufferListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(file);
        }
        if (listener != null && (removed = listener.removeDependency(file, dependency))) {
            Map<URL, DependencyTextBufferListener> map2 = listeners;
            synchronized (map2) {
                listeners.remove(file);
            }
        }
    }

    public DependencyTextBufferListener(URL file) {
        this.file = file;
    }

    public void nodeOpened(NodeEvent e) {
        Node node = e.getNode();
        if (node instanceof TextNode) {
            ((TextNode)node).addTextBufferListener((TextBufferListener)this);
        }
    }

    public void nodeWillClose(NodeEvent e) {
        Node node = e.getNode();
        if (node.isDirty()) {
            this.fireDependencyChanged();
        }
    }

    public synchronized boolean addDependency(URL file, Dependency dependency) {
        boolean added = this.dependencies.isEmpty();
        if (added) {
            LOG.trace("******** adding text buffer listener {0}", (Object)this);
            Node node = NodeFactory.find((URL)file);
            if (node instanceof TextNode) {
                ((TextNode)node).addTextBufferListener((TextBufferListener)this);
            }
        }
        this.dependencies.add(dependency);
        return added;
    }

    public synchronized boolean removeDependency(URL file, Dependency dependency) {
        this.dependencies.remove(dependency);
        boolean removed = this.dependencies.isEmpty();
        if (removed) {
            LOG.trace("******** removing text buffer listener {0}", (Object)this);
            Node node = NodeFactory.find((URL)file);
            if (node instanceof TextNode) {
                ((TextNode)node).removeTextBufferListener((TextBufferListener)this);
            }
        }
        return removed;
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        LOCK_LOG.trace("text inserted in {0}: \"{1}\"", (Object)this, (Object)new CharArrayCharSequence(text, 0, Math.min(count, 16)));
        this.fireDependencyChanged();
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] text) {
        LOCK_LOG.trace("text removed in {0}: \"{1}\"", (Object)this, (Object)new CharArrayCharSequence(text, 0, Math.min(count, 16)));
        this.fireDependencyChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDependencyChanged() {
        Dependency[] array;
        DependencyTextBufferListener dependencyTextBufferListener = this;
        synchronized (dependencyTextBufferListener) {
            array = this.dependencies.toArray(new Dependency[this.dependencies.size()]);
        }
        for (Dependency dependency : array) {
            dependency.fireDependencyChanged(dependency, true);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + URLFileSystem.getFileName((URL)this.file);
    }

    static {
        Node.addNodeListenerForTypeHierarchy(TextNode.class, (NodeListener)new NodeListener(){

            public void nodeOpened(NodeEvent e) {
                DependencyTextBufferListener listener = (DependencyTextBufferListener)listeners.get(e.getNode().getURL());
                if (listener != null) {
                    listener.nodeOpened(e);
                }
            }

            public void nodeWillClose(NodeEvent e) {
                DependencyTextBufferListener listener;
                Node node = e.getNode();
                if (node.isDirty() && (listener = (DependencyTextBufferListener)listeners.get(node.getURL())) != null) {
                    listener.nodeWillClose(e);
                }
            }
        });
        LOG = new Log("dependency");
    }
}

