/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.model.DataContainer;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.Structure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.Dependency;

public class DependencyStructureListener
extends StructureChangeListener {
    private static final Map<DataContainer, DependencyStructureListener> listeners = new IdentityHashMap<DataContainer, DependencyStructureListener>();
    private static final Log LOCK_LOG = new Log("status-lock");
    private final DataContainer container;
    private final Structure structure;
    private final Structure secondaryStructure;
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private static final Log LOG = new Log("dependency");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDependency(Dependency dependency, DataContainer container) {
        DependencyStructureListener listener;
        Map<DataContainer, DependencyStructureListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(container);
            if (listener == null) {
                listener = new DependencyStructureListener(container);
                listeners.put(container, listener);
            }
        }
        listener.addDependency(dependency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDependency(Dependency dependency, DataContainer container) {
        boolean removed;
        DependencyStructureListener listener;
        Map<DataContainer, DependencyStructureListener> map = listeners;
        synchronized (map) {
            listener = listeners.get(container);
        }
        if (listener != null && (removed = listener.removeDependency(dependency))) {
            Map<DataContainer, DependencyStructureListener> map2 = listeners;
            synchronized (map2) {
                listeners.remove(container);
            }
        }
    }

    public DependencyStructureListener(DataContainer container) {
        this.container = container;
        this.structure = container.getSharedPropertiesOnly();
        HashStructure user = container.getUserPropertiesOnly();
        this.secondaryStructure = user != this.structure ? user : null;
    }

    public synchronized boolean addDependency(Dependency dependency) {
        boolean added = this.dependencies.isEmpty();
        if (added) {
            LOG.trace("******** adding structure listener {0}", (Object)this);
            this.structure.addStructureChangeListener((StructureChangeListener)this);
            if (this.secondaryStructure != null) {
                this.secondaryStructure.addStructureChangeListener((StructureChangeListener)this);
            }
        }
        this.dependencies.add(dependency);
        return added;
    }

    public synchronized boolean removeDependency(Dependency dependency) {
        this.dependencies.remove(dependency);
        boolean removed = this.dependencies.isEmpty();
        if (removed) {
            LOG.trace("******** removing structure listener {0}", (Object)this);
            this.structure.removeStructureChangeListener((StructureChangeListener)this);
            if (this.secondaryStructure != null) {
                this.secondaryStructure.removeStructureChangeListener((StructureChangeListener)this);
            }
        }
        return removed;
    }

    public void structureValuesChanged(StructureChangeEvent e) {
        boolean isOpen = this.container.isOpen();
        boolean isChange = false;
        for (ChangeInfo change : e.getChangeDetails()) {
            if (change.getChangeType() == 2) continue;
            isChange = true;
            break;
        }
        LOCK_LOG.trace("structure changed in {0}, open {1}, change {2}: \"{3}\"", (Object)this, (Object)isOpen, (Object)isChange, (Object)e);
        if (isOpen && isChange) {
            this.fireDependencyChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDependencyChanged() {
        Dependency[] array;
        DependencyStructureListener dependencyStructureListener = this;
        synchronized (dependencyStructureListener) {
            array = this.dependencies.toArray(new Dependency[this.dependencies.size()]);
        }
        for (Dependency dependency : array) {
            dependency.fireDependencyChanged(dependency, true);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.structure + " (" + this.container.getShortLabel() + ")";
    }
}

