/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.index.file.FileChange;
import oracle.ide.index.file.FileChangeListener;
import oracle.ide.index.file.FileChangeManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.model.PathsConfiguration;

public class DependencyFileChangeListener
implements FileChangeListener {
    private static final Map<Workspace, Map<Project, DependencyFileChangeListener>> listeners = new HashMap<Workspace, Map<Project, DependencyFileChangeListener>>();
    private Project project;
    private Workspace workspace;
    private Project[] dependentProjects;
    private final MultiMap<URL, Dependency> fileDependencies = new MultiMap();
    private final MultiMap<String, Dependency> nameDependencies = new MultiMap();
    private static final Log LOG = new Log("dependency");

    public static void addDependency(Dependency dependency, URL file, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getOrCreateListener(project, workspace);
        if (listener != null) {
            listener.addDependency(file, dependency);
        }
    }

    public static void addDependency(Dependency dependency, String name, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getOrCreateListener(project, workspace);
        if (listener != null) {
            listener.addDependency(name, dependency);
        }
    }

    public static void addDependency(Dependency dependency, Collection<String> names, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getOrCreateListener(project, workspace);
        if (listener != null) {
            listener.addDependency(names, dependency);
        }
    }

    public static void removeDependency(Dependency dependency, URL file, Project project, Workspace workspace) {
        boolean listenerRemoved;
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener != null && (listenerRemoved = listener.removeDependency(file, dependency))) {
            DependencyFileChangeListener.removeListener(project, workspace);
        }
    }

    public static void removeDependency(Dependency dependency, String name, Project project, Workspace workspace) {
        boolean listenerRemoved;
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener != null && (listenerRemoved = listener.removeDependency(name, dependency))) {
            DependencyFileChangeListener.removeListener(project, workspace);
        }
    }

    public static void removeDependency(Dependency dependency, Collection<String> names, Project project, Workspace workspace) {
        boolean listenerRemoved;
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener != null && (listenerRemoved = listener.removeDependency(names, dependency))) {
            DependencyFileChangeListener.removeListener(project, workspace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependencyFileChangeListener getOrCreateListener(Project project, Workspace workspace) {
        if (project == null) {
            return null;
        }
        Map<Workspace, Map<Project, DependencyFileChangeListener>> map = listeners;
        synchronized (map) {
            DependencyFileChangeListener listener;
            Map<Project, DependencyFileChangeListener> projects = listeners.get(workspace);
            if (projects == null) {
                projects = new HashMap<Project, DependencyFileChangeListener>();
                listeners.put(workspace, projects);
            }
            if ((listener = projects.get(project)) == null) {
                listener = new DependencyFileChangeListener(project, workspace);
                projects.put(project, listener);
            }
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependencyFileChangeListener getListener(Project project, Workspace workspace) {
        if (project == null) {
            return null;
        }
        Map<Workspace, Map<Project, DependencyFileChangeListener>> map = listeners;
        synchronized (map) {
            Map<Project, DependencyFileChangeListener> projects = listeners.get(workspace);
            if (projects == null) {
                return null;
            }
            return projects.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeListener(Project project, Workspace workspace) {
        Map<Workspace, Map<Project, DependencyFileChangeListener>> map = listeners;
        synchronized (map) {
            Map<Project, DependencyFileChangeListener> projects = listeners.get(workspace);
            projects.remove(project);
            if (projects.isEmpty()) {
                listeners.remove(workspace);
            }
        }
    }

    public DependencyFileChangeListener(Project project, Workspace workspace) {
        this.project = project;
        this.workspace = workspace;
        LOG.trace("created {0}", (Object)this);
    }

    private synchronized void addDependency(URL file, Dependency dependency) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.addListener();
        this.fileDependencies.add((Object)file, (Object)dependency);
    }

    private synchronized void addDependency(String name, Dependency dependency) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.addListener();
        this.nameDependencies.add((Object)name, (Object)dependency);
    }

    private synchronized void addDependency(Collection<String> names, Dependency dependency) {
        LOG.trace("adding {0} to {1}", (Object)dependency, (Object)this);
        this.addListener();
        for (String name : names) {
            this.nameDependencies.add((Object)name, (Object)dependency);
        }
    }

    private synchronized boolean removeDependency(URL file, Dependency dependency) {
        LOG.trace("removing {0} from {1}", (Object)dependency, (Object)this);
        this.fileDependencies.remove((Object)file, (Object)dependency);
        return this.removeListener();
    }

    private synchronized boolean removeDependency(String name, Dependency dependency) {
        LOG.trace("removing {0} from {1}", (Object)dependency, (Object)this);
        this.nameDependencies.remove((Object)name, (Object)dependency);
        return this.removeListener();
    }

    private synchronized boolean removeDependency(Collection<String> names, Dependency dependency) {
        LOG.trace("removing {0} from {1}", (Object)dependency, (Object)this);
        for (String name : names) {
            this.nameDependencies.remove((Object)name, (Object)dependency);
        }
        return this.removeListener();
    }

    private boolean addListener() {
        if (this.fileDependencies.isEmpty() && this.nameDependencies.isEmpty()) {
            LOG.trace("******** adding file change listener {0}", (Object)this);
            FileChangeManager fileChangeManager = FileChangeManager.getFileChangeManager();
            fileChangeManager.addFileChangeListener(this.workspace, this.project, (FileChangeListener)this);
            for (Project dependentProject : this.dependentProjects = PathsConfiguration.getDependentProjects((Context)new Context(this.workspace, this.project))) {
                fileChangeManager.addFileChangeListener(this.workspace, dependentProject, (FileChangeListener)this);
            }
            return true;
        }
        return false;
    }

    private boolean removeListener() {
        if (this.fileDependencies.isEmpty() && this.nameDependencies.isEmpty()) {
            LOG.trace("******** removing file change listener {0}", (Object)this);
            FileChangeManager fileChangeManager = FileChangeManager.getFileChangeManager();
            fileChangeManager.removeFileChangeListener(this.workspace, this.project, (FileChangeListener)this);
            for (Project dependencyProject : this.dependentProjects) {
                fileChangeManager.removeFileChangeListener(this.workspace, dependencyProject, (FileChangeListener)this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesChanged(Workspace workspace, Project project, Collection<FileChange> changes) {
        if (changes.size() == 1 && changes.iterator().next().getType() == FileChange.Type.TEXT_BUFFER_MODIFIED) {
            return;
        }
        LOG.trace("files {0} changed in {1}", changes, (Object)this);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        DependencyFileChangeListener dependencyFileChangeListener = this;
        synchronized (dependencyFileChangeListener) {
            block6: for (FileChange change : changes) {
                switch (change.getType()) {
                    case TEXT_BUFFER_MODIFIED: {
                        continue block6;
                    }
                }
                this.collectDependencies(change.getURL(), dependencies);
            }
        }
        for (Dependency dependency : dependencies) {
            dependency.fireDependencyChanged(dependency, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filesChanged(Collection<URL> files, Project project, Workspace workspace) {
        DependencyFileChangeListener listener = DependencyFileChangeListener.getListener(project, workspace);
        if (listener == null) {
            return;
        }
        LOG.trace("files {0} changed in {1}", files, (Object)listener);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        DependencyFileChangeListener dependencyFileChangeListener = listener;
        synchronized (dependencyFileChangeListener) {
            for (URL file : files) {
                listener.collectDependencies(file, dependencies);
            }
        }
        for (Dependency dependency : dependencies) {
            dependency.fireDependencyChanged(dependency, false);
        }
    }

    private void collectDependencies(URL file, List<Dependency> dependencies) {
        Collection nameDependencies;
        Collection fileDependencies = this.fileDependencies.get((Object)file);
        if (fileDependencies != null) {
            dependencies.addAll(fileDependencies);
        }
        if ((nameDependencies = this.nameDependencies.get((Object)URLFileSystem.getName((URL)file))) != null) {
            dependencies.addAll(nameDependencies);
        }
    }

    public String toString() {
        return "DependencyFileChangeListener[" + this.project.getShortLabel() + ", " + this.fileDependencies + " " + this.nameDependencies + "]";
    }
}

