/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.DependencyListener;

public abstract class Dependency {
    private boolean changed;
    private DependencyListener listener;
    private static final Log LOG = new Log("dependency");

    public void addChangeListener(DependencyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        if (this.listener != null) {
            throw new IllegalStateException("listener already added");
        }
        this.listener = listener;
        this.attach();
    }

    public void removeChangeListener(DependencyListener listener) {
        this.detach();
        this.listener = null;
    }

    public DependencyListener getChangeListener() {
        return this.listener;
    }

    protected boolean isAttached() {
        return this.listener != null;
    }

    protected abstract void attach();

    protected abstract void detach();

    protected abstract String getShortDescription();

    protected abstract String getLongDescription();

    public boolean hasChanged() {
        return this.changed;
    }

    public void fireDependencyChanged(Dependency dependency, boolean possibleSequence) {
        LOG.trace("firing {0} changed to {1}", (Object)this, (Object)this.listener);
        this.changed = true;
        if (this.listener != null) {
            this.listener.dependencyChanged(dependency, possibleSequence);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + ", " + this.getShortDescription() + "]";
    }

    protected String listenerDescription() {
        if (this.listener != null) {
            return this.listener.getClass().getSimpleName() + "#" + Integer.toHexString(System.identityHashCode(this.listener));
        }
        return "null";
    }
}

