/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.ArraySortedSet;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public abstract class ContainerModelAdapter
extends ModelAdapter {
    private volatile Set<ModelAdapter> containedModels;
    private boolean modelIndexed;
    private static final Comparator<ModelAdapter> SIBLING_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            ModelAdapter d1 = (ModelAdapter)o1;
            ModelAdapter d2 = (ModelAdapter)o2;
            int comparison = d1.getPrimaryCollationKey().compareTo(d2.getPrimaryCollationKey());
            if (comparison != 0) {
                return comparison;
            }
            return d1.getSecondaryCollationKey().compareTo(d2.getSecondaryCollationKey());
        }
    };

    protected ContainerModelAdapter(ModelFactory factory, ModelType type) {
        super(factory, type);
    }

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, Workspace workspace) {
        super(factory, type, workspace);
    }

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, Project project) {
        super(factory, type, workspace, project);
    }

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, ContentDirectory element, URL url) {
        super(factory, type, workspace, project, directory, element, url);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public boolean addContainedModel(ModelAdapter model) {
        assert (this != model);
        if (this.containedModels == null) {
            this.containedModels = new ArraySortedSet(SIBLING_COMPARATOR);
        }
        return this.containedModels.add(model);
    }

    public boolean addContainedModels(ModelAdapter[] models) {
        if (this.containedModels == null) {
            this.containedModels = new ArraySortedSet(SIBLING_COMPARATOR);
        }
        boolean added = false;
        for (int i = 0; i < models.length; ++i) {
            ModelAdapter model = models[i];
            assert (this != model);
            if (!this.containedModels.add(model)) continue;
            added = true;
        }
        return added;
    }

    public boolean addContainedModels(Collection<ModelAdapter> models) {
        if (this.containedModels == null) {
            this.containedModels = new ArraySortedSet(SIBLING_COMPARATOR);
        }
        boolean added = false;
        for (ModelAdapter model : models) {
            assert (this != model);
            if (!this.containedModels.add(model)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public Iterator getContainedConstructs(Object construct) {
        if (this.containedModels == null) {
            this.createContainedModels(construct);
            if (this.containedModels == null) {
                this.containedModels = Collections.emptySet();
            }
        }
        if (!this.modelIndexed) {
            this.modelIndexed = true;
            int index = 0;
            Iterator<ModelAdapter> i = this.containedModels.iterator();
            while (i.hasNext()) {
                i.next().index = ++index;
            }
            log.trace("children of {0} are {1}", construct, this.containedModels);
        }
        return this.containedModels.iterator();
    }

    protected abstract void createContainedModels(Object var1);

    protected void removeContainedModel(Object construct) {
        Set<ModelAdapter> oldModels = this.containedModels;
        if (oldModels == null) {
            return;
        }
        ArraySortedSet newModels = new ArraySortedSet(SIBLING_COMPARATOR);
        for (ModelAdapter model : oldModels) {
            if (model.getRoot() == construct) continue;
            newModels.add(model);
        }
        this.containedModels = newModels;
    }
}

