/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.jdeveloper.audit.extension.DeferredSetter;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Localizer;

public abstract class ExtensionBean {
    private String extensionId;
    private int extensionLine;
    private ExtensionBundle extensionBundle;
    private String id;
    private Map<String, DeferredSetter> setters;
    private Map<String, String> strings;
    private PropertyChangeSupport support = null;
    public static final String LABEL_KEY = "label";
    public static final String SHORT_LABEL_KEY = "short-label";
    public static final String TIP_KEY = "tip";
    public static final String DESCRIPTION_KEY = "description";
    private ResourceBundle compatibilityBundle;
    private String compatibilityPrefix;

    protected ExtensionBean() {
    }

    public ExtensionBean createCopy(IdentityHashMap<Object, Object> context) throws InvocationTargetException {
        try {
            ExtensionBean copy = (ExtensionBean)context.get(this);
            if (copy != null) {
                return copy;
            }
            copy = (ExtensionBean)this.getClass().newInstance();
            copy.extensionId = this.extensionId;
            copy.extensionLine = this.extensionLine;
            copy.extensionBundle = this.extensionBundle;
            copy.id = this.id;
            copy.setters = this.setters;
            copy.strings = this.strings;
            copy.compatibilityBundle = this.compatibilityBundle;
            copy.compatibilityPrefix = this.compatibilityPrefix;
            this.copyInternalState(copy, context);
            for (PropertyDescriptor property : Introspector.getBeanInfo(copy.getClass()).getPropertyDescriptors()) {
                Method getter;
                Method setter = property.getWriteMethod();
                if (setter == null || (getter = property.getReadMethod()) == null) continue;
                setter.invoke((Object)copy, getter.invoke((Object)this, new Object[0]));
            }
            context.put(this, copy);
            return copy;
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void copyInternalState(ExtensionBean copy, IdentityHashMap<Object, Object> context) throws InvocationTargetException {
    }

    protected ExtensionBean(String id, String extensionId) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (id.endsWith(".null")) {
            throw new IllegalArgumentException("id.endsWith(\".null\")");
        }
        this.id = id;
        this.extensionId = extensionId;
    }

    public String id() {
        return this.id;
    }

    public String extensionId() {
        return this.extensionId;
    }

    public Map<String, DeferredSetter> setters() {
        return this.setters;
    }

    public void logError(String message, Object ... parameters) {
        this.log(Level.SEVERE, message, parameters);
    }

    public void logWarning(String message, Object ... parameters) {
        this.log(Level.WARNING, message, parameters);
    }

    private void log(Level level, String message, Object ... parameters) {
        if (this.extensionId != null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            ExtensionLogRecord record = new ExtensionLogRecord(level, message, registry.findExtension(this.extensionId), this.extensionLine);
            if (parameters != null && parameters.length > 0) {
                record.setParameters(parameters);
            }
            registry.getManifestLogger().log((LogRecord)record);
        } else {
            AuditLogger.log(level, message, parameters);
        }
    }

    public final String labelOrId() {
        String label = this.label();
        if (label == null) {
            label = this.id();
        }
        return label;
    }

    public String label() {
        return this.formattedString(LABEL_KEY);
    }

    public String shortLabel() {
        return this.string(SHORT_LABEL_KEY);
    }

    public String tip() {
        return this.formattedString(TIP_KEY);
    }

    public String description() {
        return this.string(DESCRIPTION_KEY);
    }

    public String propertyLabel(String propertyName) {
        return this.propertyString(propertyName, LABEL_KEY);
    }

    public String propertyTip(String propertyName) {
        String string = this.propertyString(propertyName, TIP_KEY);
        if (string == null) {
            string = this.propertyLabel(propertyName);
        }
        return string;
    }

    public String propertyDescription(String propertyName) {
        return this.propertyString(propertyName, DESCRIPTION_KEY);
    }

    public boolean equals(Object object) {
        return object instanceof ExtensionBean && this.id.equals(((ExtensionBean)object).id());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected void setCompatibilityBundle(ResourceBundle bundle, String prefix) {
        this.compatibilityBundle = bundle;
        this.compatibilityPrefix = prefix;
    }

    public String string(String key) {
        if (this.compatibilityBundle != null) {
            try {
                return this.compatibilityBundle.getString(this.compatibilityPrefix + "." + key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        if (this.strings == null) {
            return null;
        }
        String string = this.strings.get(key);
        if (string == null) {
            return null;
        }
        try {
            return this.extensionBundle.getBundle().getString(string);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String formattedString(String key) {
        return this.formattedString(key, this);
    }

    public String formattedString(String key, Object context) {
        return Localizer.instantiate(this.string(key), context);
    }

    public void setStrings(Map<String, String> strings) {
        this.strings = strings;
    }

    public Map<String, String> strings() {
        return this.strings;
    }

    public String propertyString(String propertyName, String kind) {
        return this.string(this.propertyKey(propertyName, kind));
    }

    private String propertyKey(String propertyName, String kind) {
        return propertyName + "." + kind;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            return;
        }
        this.support.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.support == null) {
            return;
        }
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object[] oldValue, Object[] newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        if (Arrays.equals(oldValue, newValue)) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (this.support == null || oldValue == newValue) {
            return;
        }
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }
}

