/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import oracle.jdeveloper.audit.extension.Converter;

public class EnumConverter
implements Converter<Enum> {
    @Override
    public Class<Enum> getType() {
        return Enum.class;
    }

    @Override
    public String getTypeDescription() {
        return "keyword";
    }

    @Override
    public Enum toValue(String string, Class<? extends Enum> type) {
        String description;
        Enum[] constants;
        for (Enum constant : constants = type.getEnumConstants()) {
            String name = constant.name();
            if (!string.equalsIgnoreCase(name)) continue;
            return constant;
        }
        if (constants.length == 1) {
            description = constants[0].name().toLowerCase();
        } else {
            StringBuilder buffer = new StringBuilder("one of ");
            String separator = "";
            for (Enum constant1 : constants) {
                buffer.append(separator);
                buffer.append('\"');
                buffer.append(constant1.name().toLowerCase());
                buffer.append('\"');
                separator = ", ";
            }
            description = buffer.toString();
        }
        throw new IllegalArgumentException("expected " + description);
    }

    @Override
    public String toString(Enum value, Class<? extends Enum> type) throws Exception {
        return value.name();
    }
}

