/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit;

import java.beans.PersistenceDelegate;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.AuditProvider;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.Transformer;

public abstract class AuditManager {
    private static AuditManager instance;

    public static AuditManager getAuditManager() {
        return instance;
    }

    public static void setAuditManager(AuditManager manager) {
        if (instance != null) {
            throw new IllegalStateException("audit manager already set");
        }
        instance = manager;
    }

    public abstract void register(AuditProvider var1);

    public abstract AuditPreferences getPreferences();

    public abstract ModelTypeFactory createModelTypeFactory(ModelType ... var1);

    public abstract ModelTypeFactory getDefaultModelTypeFactory();

    public abstract Profile createProfile(String var1, String var2, URL var3);

    public abstract Profile createProfile(String var1, Class<? extends Analyzer> ... var2);

    public abstract Auditor createAuditor(ModelTypeFactory var1);

    public abstract Auditor createAuditor();

    public abstract AuditModel createModel();

    public abstract AuditModel runShowLogPage(Auditor var1, String var2, Thread.UncaughtExceptionHandler var3);

    public abstract void showLogPage(Auditor var1, AuditModel var2, String var3);

    public abstract Transformer createTransformer();

    public abstract Map<String, ExtensionBean> getBeans();

    public abstract Collection<Class<? extends Analyzer>> getAnalyzers();

    public abstract Map<Class<?>, PersistenceDelegate> getPersistenceDelegates();

    public abstract Collection<Profile> getProfiles();

    public abstract Collection<URL> getStyleSheets();

    public abstract Collection<URL> getProfileStyleSheets();

    public abstract Map<Class<?>, BeanCustomizer> getBeanCustomizers();

    public abstract boolean isRegistered(Class<?> var1);
}

