/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.print.Pageable;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.view.View;

public class NavigatorPrintFactory
extends DocumentPrintFactory {
    public void create(Context context) {
        Element[] selection = context.getSelection();
        ArrayList<Pageable> pageableList = new ArrayList<Pageable>();
        for (int i = 0; i < selection.length; ++i) {
            Pageable pageable;
            Element elem = selection[i];
            if (!NavigatorPrintFactory.isPrintable(elem) || (pageable = this._printManager.createPageableForObject(context, (Object)((Node)elem))) == null) continue;
            pageableList.add(pageable);
        }
        if (pageableList.size() > 0) {
            Pageable[] pageables = pageableList.toArray(new Pageable[pageableList.size()]);
            this._printManager.setPageables(pageables);
        }
    }

    public boolean isPrintingEnabled(Context context) {
        Element[] selection;
        View view;
        if (context != null && (view = context.getView()) != null && (selection = view.getSelection()) != null) {
            for (int i = 0; i < selection.length; ++i) {
                if (!NavigatorPrintFactory.isPrintable(selection[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPrintable(Element elem) {
        return elem.getAttributes().isSet(ElementAttributes.PRINTABLE) && elem instanceof Node;
    }
}

