/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.ide.extension.ExtensionRegistry;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TNodeConstants;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.AbstractLayoutListener;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layout;
import oracle.ide.layout.URL2String;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.Extension;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.NavigatorArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.NavigatorController;
import oracle.ideri.navigator.NavigatorPrintFactory;
import oracle.ideri.util.Product;
import oracle.javatools.ui.ghost.GhostPointingPalette;

public class DefaultNavigatorWindow
extends NavigatorWindow {
    private static final String ROOT_PROP = ".root";
    private static final String EXPAND_DATA_COUNT_PROP = "expandData.count";
    private static final String EXPAND_DATA_PROP = "expandData{0}";
    private static final String EXPAND_DATA_NODE_PATH_PROP = ".nodePath";
    private static final String EXPAND_DATA_URL_PROP = ".url";
    private static final String NAVIGATOR_SELECTION_PROP = "selectionRow";
    private static ContextMenu _contextMenu;
    private static final HashMap _extensions;
    private final Element _rootFolder;
    private final Project _project;
    private final Workspace _workspace;
    private NavigatorController _controller;
    private BaseTreeExplorer _explorer;
    private PropertyAccess _properties;
    private Comparator _comparator;
    private boolean _comparatorSet;
    private boolean _rootVisible;
    private boolean _rootVisibleSet;
    private boolean _initSelection;
    private String _title;
    private JPanel _host;
    private Toolbar _toolbar;
    private boolean _toolbarVisible;
    private boolean _toolbarVisibleSet;
    private int _defaultVisibility;
    private boolean isPeeking = false;
    private NavigatorManager _manager;
    private JPanel _northPanel;

    protected DefaultNavigatorWindow(Context context, String viewId) {
        this(Ide.getMainWindow().getIdeMainWindowView(), context, viewId);
    }

    private DefaultNavigatorWindow(View owner, Context context, String viewId) {
        Element folder;
        this.setOwner(owner);
        this.setId(viewId);
        this.setType(32);
        this._rootFolder = folder = DefaultNavigatorManager.getFolderFromContext((Context)context);
        this._project = context.getProject();
        this._workspace = context.getWorkspace();
        PrintManager printManager = PrintManager.getPrintManager();
        if (printManager != null) {
            printManager.registerDocumentPrintFactory(NavigatorWindow.class, NavigatorPrintFactory.class);
        }
        this.addViewSelectionListener(new ViewSelectionListener(){

            public void viewSelectionChanged(ViewSelectionEvent e) {
                View activeView;
                View view = e.getView();
                if (view == (activeView = Ide.getMainWindow().getLastActiveView())) {
                    DefaultNavigatorWindow.this.updateActiveNode();
                    Element[] selection = e.getSelection();
                    if (selection != null && selection.length > 0) {
                        Element element = selection[0];
                        DefaultNavigatorWindow.this.updateStatusBar((Displayable)element);
                    }
                }
            }
        });
    }

    public void setRootVisible(boolean visible) {
        if (this.getTreeExplorer() == null) {
            this._rootVisibleSet = true;
            this._rootVisible = visible;
        } else {
            JTree tree = this.getTree();
            if (tree != null) {
                tree.setRootVisible(visible);
                tree.setShowsRootHandles(!visible);
            }
        }
    }

    public void collapse(TNode tnode, boolean all) {
        if (this._explorer != null) {
            this._explorer.collapse(tnode, all);
        }
    }

    public void expand(TNode tnode, boolean all) {
        if (this._explorer != null) {
            this._explorer.expand(tnode, all);
        }
    }

    public TNode findTNode(Element element, TNode root) {
        return this._explorer != null ? this._explorer.findTNode(element, root) : null;
    }

    public void refresh(TNode tnode) {
        if (this._explorer != null) {
            this._explorer.refresh(tnode);
        }
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void setComparator(Comparator comparator) {
        TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            treeExplorer.setComparator(comparator);
        } else {
            this._comparatorSet = true;
            this._comparator = comparator;
        }
    }

    public void setSelected(TNode tnode) {
        if (this._explorer != null) {
            this._explorer.setSelected(tnode);
        }
    }

    public TreeExplorer getTreeExplorer() {
        return this._explorer;
    }

    public NavigatorManager getManager() {
        return this._manager;
    }

    public void setManager(NavigatorManager manager) {
        this._manager = manager;
    }

    public Component getGUI() {
        if (this._host == null) {
            this._host = new JPanel(new BorderLayout());
            this._host.setOpaque(false);
            this.createTree();
            if (this._comparatorSet) {
                this.setComparator(this._comparator);
                this._comparator = null;
                this._comparatorSet = false;
            }
            if (this._rootVisibleSet) {
                this.setRootVisible(this._rootVisible);
                this._rootVisibleSet = false;
            }
            this.initCommonItems();
        }
        return this._host;
    }

    protected final void initCommonItems() {
        this.initToolbarArea();
        if (this._properties != null) {
            this.loadLayout(this._properties);
            this._properties = null;
        }
        if (this._initSelection) {
            this.initSelection();
            this._initSelection = false;
        }
    }

    protected void initToolbarArea() {
        if (this._toolbarVisibleSet) {
            this.setToolbarVisible(this._toolbarVisible);
            this._toolbarVisibleSet = false;
        }
    }

    protected void addToNorth(JComponent comp) {
        if (this._northPanel == null) {
            this._northPanel = new JPanel();
            this._northPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
            this._host.add((Component)this._northPanel, "North");
        }
        this._northPanel.add(comp);
    }

    protected final void removeFromNorth(Component comp) {
        if (this._northPanel != null) {
            this._northPanel.remove(comp);
            this._northPanel.revalidate();
        }
    }

    protected final Element[] getSelectionFromUI() {
        return this._explorer != null ? this._explorer.getSelection() : super.getSelectionFromUI();
    }

    public Context getContext(EventObject event) {
        Context context;
        if (this._explorer != null) {
            context = new Context(this._explorer.getContext(event));
        } else {
            context = Context.newIdeContext();
            context.setEvent(event);
        }
        context.setView((View)this);
        Extension extension = DefaultNavigatorWindow.findExtension(context.getElement());
        if (extension != null) {
            try {
                context = extension.updateContext(context, ExplorerContext.getTNodes((Context)context));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (context.getProject() == null) {
            context.setProject(this._project);
        }
        if (context.getWorkspace() == null) {
            context.setWorkspace(this.getCurrentWorkspace());
        }
        return context;
    }

    protected Workspace getCurrentWorkspace() {
        return this._workspace;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new NavigatorController();
        }
        return this._controller;
    }

    public ContextMenu getContextMenu() {
        return DefaultNavigatorWindow.getOrCreateContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return this.getManager().getHelpInfo();
    }

    public String getTabName() {
        if (Product.isJDeveloper() && NavigatorManager.getWorkspaceNavigatorManager().isSystemNavigator(new ViewId(this.getId()))) {
            return NavigatorArb.getString((int)7);
        }
        return this._rootFolder.getShortLabel();
    }

    public String getTitleName() {
        String title = !this.getTitle().equals(this.getTabName()) ? this.getTabName() + " " + this.getTitle() : this.getTitle();
        AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)title, (boolean)false);
        return title;
    }

    public Icon getTabIcon() {
        return this._rootFolder.getIcon();
    }

    public String getMenuTitle() {
        String viewId = this.getId();
        if (NavigatorManager.getWorkspaceNavigatorManager().isSystemNavigator(new ViewId(viewId))) {
            return IdeArb.getString((int)160);
        }
        return super.getMenuTitle();
    }

    public void saveLayout(PropertyAccess layout) {
        if (this._host == null) {
            return;
        }
        String strId = this.getId();
        DefaultNavigatorWindow.saveContext(strId, this._rootFolder, this._project, this._workspace);
        TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            treeExplorer.saveFilters(layout);
        }
        if (this.isSaveExpansionState() && Ide.getEnvironOptions().isRememberNavigatorExpansionState()) {
            this.saveExpansionState(layout);
            this.saveSelection(layout);
        }
    }

    public void loadLayout(PropertyAccess p) {
        if (this._host == null) {
            this._properties = p;
            return;
        }
        this.getId();
        this.getTreeExplorer().openFilters(p);
        if (Ide.isStarting() && Ide.getEnvironOptions().isRememberNavigatorExpansionState()) {
            try {
                this.restoreExpansionState(p);
                this.restoreSelection(p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        switch (newState) {
            case 1: {
                this.updateVisibleActions();
                break;
            }
            case 3: {
                if ((this.getType() & 1) == 0) break;
                this.removeToolbar();
                if (this._explorer == null) break;
                this._explorer.dispose();
            }
        }
    }

    public void setToolbarVisible(boolean visible) {
        if (this.getTreeExplorer() == null) {
            this._toolbarVisibleSet = true;
            this._toolbarVisible = visible;
            return;
        }
        if (visible) {
            this.createToolbar();
        } else {
            this.removeToolbar();
        }
    }

    public void setDefaultVisibility(int defaultVisibility) {
        this._defaultVisibility = defaultVisibility;
    }

    public int getDefaultVisibility(Layout layout) {
        return this._defaultVisibility;
    }

    protected boolean coalesceTreeExplorerUpdates() {
        return true;
    }

    protected void setTitle(String title) {
        this._title = title;
    }

    protected String getTitle() {
        if (this._title == null) {
            this._title = NavigatorArb.getString((int)6);
        }
        return this._title;
    }

    protected JTree getTree() {
        return this._explorer != null ? this._explorer.getJTree() : null;
    }

    protected boolean isSaveExpansionState() {
        return false;
    }

    protected static void registerExtension(Extension ext, Class cls) {
        _extensions.put(cls, ext);
    }

    protected static ContextMenu getOrCreateContextMenu() {
        if (_contextMenu == null) {
            _contextMenu = new ContextMenu(new MnemonicSolver());
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (hook != null) {
                _contextMenu.addContextMenuListener(hook.getListener("navigator"));
            }
        }
        return _contextMenu;
    }

    protected void initSelection() {
        if (this._explorer == null || this._explorer.getJTree() == null) {
            this._initSelection = true;
            return;
        }
        JTree tree = this._explorer.getJTree();
        int rowCount = tree.getRowCount();
        if (rowCount > 0) {
            if (tree.isRootVisible()) {
                tree.setSelectionRow(0);
            } else if (rowCount > 1) {
                tree.setSelectionRow(1);
            }
        }
    }

    private static void saveContext(String strId, Element element, Project project, Workspace workspace) {
        IdeProperties layout = Ide.getIdeProperties();
        String prop = strId + ROOT_PROP;
        Object dataObj = element.getData();
        if (dataObj instanceof Node) {
            URL url;
            Node node = (Node)dataObj;
            if (node.mayHaveChildren() && (url = node.getURL()) != null) {
                layout.setProperty(prop, URL2String.toString((URL)url));
            }
        } else {
            ViewId viewId = new ViewId(strId);
            layout.setProperty(prop, viewId.getName());
        }
        prop = strId + ".project";
        if (project != null) {
            layout.setProperty(prop, URL2String.toString((URL)project.getURL()));
        }
        prop = strId + ".workspace";
        if (workspace != null) {
            layout.setProperty(prop, URL2String.toString((URL)workspace.getURL()));
        }
    }

    static Context loadContext(String viewId) {
        IdeProperties layout = Ide.getIdeProperties();
        String prop = viewId + ROOT_PROP;
        Node node = AbstractLayoutListener.getNode((String)prop, (Layout)layout);
        Context context = Context.newIdeContext((Node)node);
        if (node != null && node.mayHaveChildren()) {
            context.setProject(AbstractLayoutListener.getProject((String)viewId, (Layout)layout));
            context.setWorkspace(AbstractLayoutListener.getWorkspace((String)viewId, (Layout)layout));
        }
        return context;
    }

    static void clearContext(String strId) {
        IdeProperties layout = Ide.getIdeProperties();
        String prop = strId + ROOT_PROP;
        layout.setProperty(prop, null);
        prop = strId + ".project";
        layout.setProperty(prop, null);
        prop = strId + ".workspace";
        layout.setProperty(prop, null);
    }

    private String getViewType() {
        return new ViewId(this.getId()).getType();
    }

    private void createToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            String toolbarId = this.getToolbarId();
            if (toolbarId != null) {
                DefaultNavigatorWindow.loadManifestToolbar((String)toolbarId, (Toolbar)this._toolbar, (View)this);
            }
            this.updateVisibleActions();
            this.addToNorth((JComponent)this._toolbar);
            this._host.revalidate();
        }
    }

    protected String getToolbarId() {
        return this.getViewType() + ".Toolbar";
    }

    private void removeToolbar() {
        if (this._toolbar != null) {
            this.removeFromNorth((Component)this._toolbar);
            this._toolbar.dispose();
            this._toolbar = null;
        }
    }

    private void updateActiveNode() {
        if (this._explorer == null) {
            return;
        }
        Context context = this.getContext();
        if (context.getView() != this) {
            return;
        }
        TNode[] selection = ExplorerContext.getTNodes((Context)context);
        if (selection == null || selection.length == 0) {
            return;
        }
        TNode newActiveProject = selection[0].getAncestorTNode(Project.class, true);
        if (newActiveProject == null) {
            TNode workspace = selection[0].getAncestorTNode(Workspace.class, false);
            if (workspace == null) {
                return;
            }
            newActiveProject = this.findActiveProjectTNode(workspace);
        }
        this._explorer.updateActiveNode(newActiveProject);
    }

    private TNode findActiveProjectTNode(TNode workspaceTNode) {
        if (!workspaceTNode.isSet(TNodeConstants.IS_OPENED)) {
            return null;
        }
        Enumeration children = workspaceTNode.children();
        Workspace workspace = (Workspace)workspaceTNode.getData();
        Project project = workspace.currentActiveProject();
        while (children.hasMoreElements()) {
            TNode child = (TNode)children.nextElement();
            if (child.getData() != project) continue;
            return child;
        }
        return null;
    }

    private void createTree() {
        Context context = Context.newIdeContext((Element)this._rootFolder);
        context.setView((View)this);
        context.setProject(this._project);
        context.setWorkspace(this._workspace);
        final boolean coalesceObserverUpdates = this.coalesceTreeExplorerUpdates();
        class NavigatorTreeExplorer
        extends BaseTreeExplorer {
            NavigatorTreeExplorer(View owner) {
                this.setOwner(owner);
            }

            @Override
            public String getDFTName() {
                NavigatorManager manager = DefaultNavigatorWindow.this.getManager();
                String dftName = manager != null ? "nav-" + manager.getClass().getSimpleName() : "nnav-" + ((Object)((Object)DefaultNavigatorWindow.this)).getClass().getSimpleName();
                return dftName;
            }

            @Override
            protected void nodeExpanded(TNode tnode, boolean expansionAlsoTriggeredOpen) {
                if (expansionAlsoTriggeredOpen) {
                    DefaultNavigatorWindow.this.updateActiveNode();
                }
            }

            @Override
            protected boolean coalesceObserverUpdates() {
                return coalesceObserverUpdates;
            }

            @Override
            protected void initializeContextNode(Context context, TNode[] tnodes) {
                context.setNode(this.findNodeInSelection(tnodes));
            }

            private Node findNodeInSelection(TNode[] tnodes) {
                Element data;
                if (tnodes.length == 1 && (data = tnodes[0].getData()) instanceof Node) {
                    return (Node)data;
                }
                return null;
            }

            @Override
            protected void tryPopupInBlankSpace(ContextMenu contextMenu, MouseEvent e) {
                DefaultNavigatorWindow.this.showPopupInBlankSpace(contextMenu, e);
            }

            @Override
            protected CustomTree createCustomTree() {
                return new PeekableTree();
            }
        }
        this._explorer = new NavigatorTreeExplorer((View)this);
        this._explorer.setOverlayCache(IconOverlayCache.getInstance());
        this._explorer.getOverlayCache().registerOverlayConsumer((IconOverlayConsumer)this._explorer);
        ViewSelectionListener proxyListener = new ViewSelectionListener(){

            public void viewSelectionChanged(ViewSelectionEvent e) {
                DefaultNavigatorWindow.this.updateSelection();
            }
        };
        this._explorer.addViewSelectionListener(proxyListener);
        this._explorer.setContext(context);
        this._explorer.getJTree();
        JComponent gui = (JComponent)this._explorer.getGUI();
        this._host.add((Component)gui, "Center");
        this.initSelection();
    }

    protected void showPopupInBlankSpace(ContextMenu contextMenu, MouseEvent e) {
    }

    private void updateStatusBar(Displayable displayable) {
        String title = displayable.getLongLabel();
        Ide.getStatusBar().setText(title);
    }

    private static Extension findExtension(Element element) {
        if (element == null) {
            return null;
        }
        Class<?> elemClass = element.getClass();
        Extension ext = (Extension)_extensions.get(elemClass);
        if (ext != null) {
            return ext;
        }
        for (Class cls : _extensions.keySet()) {
            if (!cls.isAssignableFrom(elemClass)) continue;
            ext = (Extension)_extensions.get(cls);
            break;
        }
        return ext;
    }

    private void restoreExpansionState(PropertyAccess layout) {
        if (this.getTreeExplorer() == null) {
            return;
        }
        String prop = EXPAND_DATA_COUNT_PROP;
        String countStr = layout.getProperty(EXPAND_DATA_COUNT_PROP, "0");
        int count = Integer.parseInt(countStr);
        if (count <= 0) {
            return;
        }
        ArrayList<ExplorerContext.ExpandInfo> expandDataList = new ArrayList<ExplorerContext.ExpandInfo>();
        for (int i = 0; i < count; ++i) {
            String baseProp = MessageFormat.format(EXPAND_DATA_PROP, i);
            try {
                String path = layout.getProperty(baseProp + EXPAND_DATA_NODE_PATH_PROP, null);
                if (path == null || path.length() <= 0) continue;
                ExplorerContext.ExpandInfo info = new ExplorerContext.ExpandInfo(path);
                String urlStr = layout.getProperty(baseProp + EXPAND_DATA_URL_PROP, null);
                if (urlStr != null && urlStr.length() > 0) {
                    info._url = URL2String.toURL((String)urlStr);
                }
                expandDataList.add(info);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (expandDataList.size() == 0) {
            return;
        }
        this.openDataNodes(expandDataList);
        this.restoreExpansionStateLater(this.getTreeExplorer(), expandDataList);
    }

    private void openDataNodes(List expandDataList) {
        for (int i = 0; i < expandDataList.size(); ++i) {
            Node node;
            ExplorerContext.ExpandInfo info = (ExplorerContext.ExpandInfo)expandDataList.get(i);
            if (info._url == null || (node = NodeFactory.find((URL)info._url)) == null) continue;
            try {
                node.open();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void restoreExpansionStateLater(final TreeExplorer treeExplorer, final List expandDataList) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplorerContext.restoreExpansionState((TNode)treeExplorer.getRoot(), (TreeExplorer)treeExplorer, (List)expandDataList);
            }
        });
    }

    private void saveExpansionState(PropertyAccess layout) {
        TreeExplorer explorer = this.getTreeExplorer();
        if (explorer != null) {
            List expandedSet = ExplorerContext.storeExpansionState((TNode)explorer.getRoot(), (TreeExplorer)explorer);
            String prop = EXPAND_DATA_COUNT_PROP;
            layout.setProperty(EXPAND_DATA_COUNT_PROP, Integer.toString(expandedSet.size()));
            Iterator iter = expandedSet.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ExplorerContext.ExpandInfo info = (ExplorerContext.ExpandInfo)iter.next();
                String tpStr = info._nodePath;
                String baseProp = MessageFormat.format(EXPAND_DATA_PROP, i++);
                layout.setProperty(baseProp + EXPAND_DATA_NODE_PATH_PROP, tpStr);
                if (info._url == null) continue;
                layout.setProperty(baseProp + EXPAND_DATA_URL_PROP, URL2String.toString((URL)info._url));
            }
        }
    }

    private void saveSelection(PropertyAccess layout) {
        int selRow;
        TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null && (selRow = this.getTreeExplorer().getJTree().getMinSelectionRow()) >= 0) {
            String prop = NAVIGATOR_SELECTION_PROP;
            layout.setProperty(NAVIGATOR_SELECTION_PROP, Integer.toString(selRow));
        }
    }

    private void restoreSelection(PropertyAccess layout) {
        TreeExplorer treeExplorer = this.getTreeExplorer();
        if (treeExplorer != null) {
            String prop = NAVIGATOR_SELECTION_PROP;
            String value = layout.getProperty(NAVIGATOR_SELECTION_PROP, "-1");
            final int selRow = Integer.parseInt(value);
            if (selRow >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TreeExplorer explorer = DefaultNavigatorWindow.this.getTreeExplorer();
                        explorer.getJTree().setSelectionRow(selRow);
                        explorer.getJTree().scrollRowToVisible(selRow);
                        DefaultNavigatorWindow.this.updateActiveNode();
                    }
                });
            }
        }
    }

    protected void addFirstHostedWindow(DockableWindow toHost) {
    }

    public void addHostedWindow(DockableWindow toHost) {
    }

    public JComponent topComponent() {
        return null;
    }

    private Peek showPeek(Point p) {
        Rectangle pathBounds;
        JTree tree = this.getTree();
        if (!tree.getVisibleRect().contains(p)) {
            return null;
        }
        TreePath tp = tree.getPathForLocation(p.x, p.y);
        if (tp != null && (pathBounds = tree.getPathBounds(tp)).contains(p)) {
            Node node;
            Peek peek;
            Rectangle rect = tree.getVisibleRect().intersection(pathBounds);
            Object obj = ((ExplorerNode)tp.getLastPathComponent()).getUserObject();
            if (obj instanceof Node && (peek = PeekHelper.createPeek((URL)(node = (Node)obj).getURL(), (JComponent)this.getTree(), (Rectangle)rect)) != null) {
                peek.showPeek();
                this.isPeeking = true;
                final GhostPointingPalette gpp = peek.getGhostPointingPalette();
                peek.getGhostPointingPalette().addAncestorListener(new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                        gpp.removeAncestorListener((AncestorListener)this);
                        DefaultNavigatorWindow.this.isPeeking = false;
                    }
                });
                return peek;
            }
        }
        return null;
    }

    static {
        _extensions = new HashMap();
    }

    private class PeekableTree
    extends CustomTree
    implements Peekable {
        private PeekableTree() {
        }

        public Peek peek(Point p) {
            SwingUtilities.convertPointFromScreen(p, this);
            return DefaultNavigatorWindow.this.showPeek(p);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            if (DefaultNavigatorWindow.this.isPeeking) {
                return null;
            }
            return super.getToolTipText(event);
        }

        @Override
        public String getToolTipText() {
            if (DefaultNavigatorWindow.this.isPeeking) {
                return null;
            }
            return super.getToolTipText();
        }
    }

    private static final class CleanUpIdeAdapter
    extends IdeAdapter {
        private final WeakReference navigatorWindowImplWeakReference;

        public CleanUpIdeAdapter(DefaultNavigatorWindow navigatorWindowImpl) {
            this.navigatorWindowImplWeakReference = new WeakReference<DefaultNavigatorWindow>(navigatorWindowImpl);
        }

        public void mainWindowClosing(IdeEvent e) {
            DefaultNavigatorWindow navigatorWindowImpl = (DefaultNavigatorWindow)((Object)this.navigatorWindowImplWeakReference.get());
            if (navigatorWindowImpl._toolbar != null) {
                navigatorWindowImpl._toolbar.dispose();
            }
        }
    }
}

