/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComboBoxUI;
import oracle.ideimpl.navigator.AppPickerButtonUI;
import oracle.ideimpl.navigator.AppPickerComboBoxUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

public final class AppPickerUI {
    private JComboBox _comboBox;
    private AbstractButton _button;
    private boolean _active;
    private boolean _mouseOverComboBox;
    private boolean _mouseOverButton;

    public void setComboBox(JComboBox box) {
        if (!Themes.isThemed()) {
            return;
        }
        this._comboBox = box;
        this._comboBox.putClientProperty("apui", this);
        this._comboBox.setUI((ComboBoxUI)((Object)new AppPickerComboBoxUI()));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AppPickerUI.this._mouseOverComboBox = true;
                AppPickerUI.this.repaintAll();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AppPickerUI.this._mouseOverComboBox = false;
                AppPickerUI.this.repaintAll();
            }
        };
        for (int i = 0; i < this._comboBox.getComponentCount(); ++i) {
            this._comboBox.getComponent(i).addMouseListener(ml);
        }
        this._comboBox.addMouseListener(ml);
    }

    public void setButton(AbstractButton button) {
        if (!Themes.isThemed()) {
            return;
        }
        this._button = button;
        this._button.putClientProperty("apui", this);
        this._button.setUI((ButtonUI)((Object)new AppPickerButtonUI()));
        this._button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AppPickerUI.this._mouseOverButton = true;
                AppPickerUI.this.repaintAll();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AppPickerUI.this._mouseOverButton = false;
                AppPickerUI.this.repaintAll();
            }
        });
    }

    private void repaintAll() {
        if (this._comboBox != null) {
            this._comboBox.repaint();
        }
        if (this._button != null) {
            this._button.repaint();
        }
    }

    public void setInActiveView(boolean active) {
        if (!Themes.isThemed()) {
            return;
        }
        this._active = active;
    }

    private String getState() {
        if (!this._mouseOverButton && !this._mouseOverComboBox) {
            return this._active ? "active" : "inactive";
        }
        String state = "";
        if (!this._active) {
            state = "i";
        }
        if (this._mouseOverComboBox) {
            state = state + "mol";
        } else if (this._mouseOverButton) {
            state = state + "mor";
        }
        return state;
    }

    Painter getButtonPainter() {
        Theme theme = Themes.getActiveTheme();
        return theme.getStateProperties("apppkbtn", this.getState()).getPainter("bg");
    }

    Painter getComboBoxPainter() {
        Theme theme = Themes.getActiveTheme();
        return theme.getStateProperties("apppkcmb", this.getState()).getPainter("bg");
    }

    static AppPickerUI get(JComponent component) {
        return (AppPickerUI)component.getClientProperty("apui");
    }
}

