/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.navigator;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerWindow;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.navigator.ApplicationChangeNotifier;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.Res;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullIcon;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ideimpl.navigator.AppPickerUI;
import oracle.ideimpl.navigator.NavigatorArb;
import oracle.ideimpl.navigator.TaskButton;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.layout.VerticalFlowLayout;

final class ApplicationNavigatorWindow
extends DefaultNavigatorWindow
implements ApplicationChangeNotifier {
    private static final Logger LOG = Logger.getLogger(ApplicationNavigatorWindow.class.getName());
    private static final String ACTION_INVOKED_FROM_VALUE = "navigatorShortcut";
    private static final String INITIAL_WORKSPACE = "initial-workspace-url";
    private static final Icon NULL_ICON = new NullIcon();
    private URL _initialWorkspaceURL;
    private final ArrayList _applicationChangeListeners = new ArrayList();
    private JComboBox _appPicker = new JComboBox();
    boolean removingApplication6674339 = false;
    private Workspace _currentWorkspace = null;
    private DrawerWindow _drawerWindow;
    private DockableWindow _firstDrawer;
    private final AppPickerUI _pickerUI = new AppPickerUI();
    private JComponent topComponent = new Toolbar(){
        {
            this.forcePrimaryViewToolbar(true);
        }

        protected boolean isActiveViewToolbar() {
            return ApplicationNavigatorWindow.this._activeView;
        }
    };
    private boolean enabledNewApplication = true;
    private CardLayout guiCardLayout;
    private JPanel gui;
    final List<DockableWindow> hostedWindows = new ArrayList<DockableWindow>();
    private boolean drawerLayoutLoaded;
    private boolean drawerLayoutSaved;
    private boolean doneLoadLayout;
    private boolean _activeView = false;

    @Override
    public Controller getController() {
        return this._drawerWindow != null ? this._drawerWindow.getController() : super.getController();
    }

    private void createDrawerWindow() {
        DrawerWindowConfig c = new DrawerWindowConfig();
        c.icon(this.getTabIcon());
        c.tabName(this.getTabName());
        c.titleName(this.getTitleName());
        c.topComponent(this.topComponent());
        c.type(this.getType());
        this._drawerWindow = new DrawerWindow(this.getId(), (View)this, c);
    }

    ApplicationNavigatorWindow(Context context, String viewId) {
        super(context, viewId);
        this.registerActivationListener();
        this._pickerUI.setComboBox(this._appPicker);
        this._appPicker.setSelectedItem(null);
        this._appPicker.addItem(Res.getString(0));
        this._appPicker.addItem(Res.getString(1));
        this._appPicker.setName(viewId + ".applicationPicker");
        this.topComponent.setLayout(new LayoutManager(){

            private <T extends Component> T getFirst(Container parent, Class<T> type) {
                for (int i = 0; i < parent.getComponentCount(); ++i) {
                    if (!type.isInstance(parent.getComponent(i))) continue;
                    return (T)((Component)type.cast(parent.getComponent(i)));
                }
                return null;
            }

            @Override
            public void layoutContainer(Container parent) {
                JComboBox box = this.getFirst(parent, JComboBox.class);
                AbstractButton button = this.getFirst(parent, AbstractButton.class);
                Dimension buttonPS = button.getPreferredSize();
                Insets insets = parent.getInsets();
                int w = parent.getWidth() - (insets.left + insets.right);
                int h = parent.getHeight() - (insets.top + insets.bottom);
                int buttonWidth = Math.max(34, buttonPS.width);
                box.setBounds(insets.left, insets.top, w - buttonWidth, h);
                button.setBounds(insets.left + box.getWidth(), insets.top, buttonWidth, h);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(0, 0);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                JComboBox box = this.getFirst(parent, JComboBox.class);
                AbstractButton button = this.getFirst(parent, AbstractButton.class);
                Dimension d = new Dimension();
                Insets insets = parent.getInsets();
                d.width = insets.left + insets.right;
                d.height = insets.top + insets.bottom;
                d.width += box.getPreferredSize().width;
                d.width += Math.max(button.getPreferredSize().width, 34);
                d.height = Math.max(d.height, box.getPreferredSize().height);
                d.height = Math.max(d.height, button.getPreferredSize().height);
                d.height = Math.max(d.height, 26);
                return d;
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }
        });
        Dimension minSize = this._appPicker.getMinimumSize();
        minSize.width = 0;
        this._appPicker.setMinimumSize(minSize);
        class L
        extends NodeListener
        implements ItemListener,
        ActionListener,
        PopupMenuListener {
            boolean ignoreStateChangedEvent = false;
            boolean removing = false;
            private boolean _canceled = false;

            L() {
            }

            public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
                ApplicationNavigatorWindow.this._appPicker.repaint();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (this.ignoreStateChangedEvent) {
                    return;
                }
                Object item = e.getItem();
                int stateChange = e.getStateChange();
                if (item instanceof DisplayURL) {
                    DisplayURL display = (DisplayURL)item;
                    try {
                        Workspace workspace = (Workspace)display._node;
                        if (stateChange == 2 && ApplicationNavigatorWindow.this.removingApplication6674339 && ApplicationNavigatorWindow.this._appPicker.getItemCount() == 3) {
                            ApplicationNavigatorWindow.this.fireApplicationChangeEvent(new ApplicationChangeEvent(1, workspace));
                        }
                        if (stateChange == 1 && ApplicationNavigatorWindow.this._currentWorkspace != workspace) {
                            ApplicationNavigatorWindow.this.fireApplicationChangeEvent(new ApplicationChangeEvent(1, ApplicationNavigatorWindow.this._currentWorkspace));
                            ApplicationNavigatorWindow.this._currentWorkspace = workspace;
                            if (workspace != null) {
                                workspace.ensureOpen();
                            }
                            ApplicationNavigatorWindow.this.fireApplicationChangeEvent(new ApplicationChangeEvent(2, workspace));
                            ViewSelectionEvent event = new ViewSelectionEvent((View)ApplicationNavigatorWindow.this);
                            ApplicationNavigatorWindow.this.fireViewSelectionChanged(event);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Object item;
                if (ApplicationNavigatorWindow.this._appPicker.getItemCount() > 2 && (item = ApplicationNavigatorWindow.this._appPicker.getSelectedItem()) != null) {
                    if (item.equals(Res.getString(0))) {
                        this.ignoreStateChangedEvent = true;
                        ApplicationNavigatorWindow.this._appPicker.setSelectedItem(new DisplayURL((Node)ApplicationNavigatorWindow.this._currentWorkspace));
                        this.ignoreStateChangedEvent = false;
                        if (!this._canceled && ApplicationNavigatorWindow.this.enabledNewApplication) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ApplicationNavigatorWindow.this.invokeCreateNewApplication();
                                }
                            });
                        }
                    } else if (item.equals(Res.getString(1))) {
                        this.ignoreStateChangedEvent = true;
                        ApplicationNavigatorWindow.this._appPicker.setSelectedItem(new DisplayURL((Node)ApplicationNavigatorWindow.this._currentWorkspace));
                        this.ignoreStateChangedEvent = false;
                        if (!this._canceled) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ApplicationNavigatorWindow.this.invokeOpenApplication();
                                }
                            });
                        }
                    }
                }
                this._canceled = false;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this._canceled = true;
            }
        }
        L listener = new L();
        Node.addNodeListenerForType(Workspace.class, (NodeListener)listener);
        this._appPicker.addItemListener(listener);
        this._appPicker.addPopupMenuListener(listener);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Workspace curWorkspace = ApplicationNavigatorWindow.this._currentWorkspace;
                if (curWorkspace != null && SwingUtilities.isRightMouseButton(e)) {
                    ApplicationNavigatorWindow.this._appPicker.requestFocus();
                    Context workspaceContext = ApplicationNavigatorWindow.this.getContext(e);
                    ApplicationNavigatorWindow.this.getContextMenu().show(workspaceContext);
                }
            }
        };
        for (Component comp : this._appPicker.getComponents()) {
            if (comp == null) continue;
            comp.addMouseListener(mouseListener);
        }
        class LCR
        extends DefaultListCellRenderer {
            private final Font _normal = UIManager.getFont("ComboBox.font");
            private final Font _italic = this._normal.deriveFont(2);

            LCR() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof DisplayURL) {
                    WorkingSet currentWorkingSet;
                    URL url = ((DisplayURL)value)._node.getURL();
                    IconOverlayCache cache = IconOverlayCache.getInstance();
                    Workspace workspace = (Workspace)NodeFactory.find((URL)url);
                    String toolTipText = URLFileSystem.getPlatformPathName((URL)url);
                    if (workspace == null) {
                        return comp;
                    }
                    Icon theIcon = cache.getRendererIcon((Element)workspace, workspace.getIcon());
                    String overlayToolTipText = cache.getRendererToolTipText((Element)workspace, toolTipText);
                    comp.setToolTipText(overlayToolTipText);
                    if (workspace != null && workspace.isDirty()) {
                        comp.setFont(this._italic);
                    } else {
                        comp.setFont(this._normal);
                    }
                    WorkingSets instance = WorkingSets.getInstance((Workspace)workspace);
                    if (instance != null && (currentWorkingSet = instance.getCurrentWorkingSet()) != null && !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(currentWorkingSet.getName()) && currentWorkingSet.getExcludedProjectList() != null && currentWorkingSet.getExcludedProjectList().size() > 0) {
                        comp.setText(Res.format(3, this.getText()));
                    }
                    if (index < 0) {
                        if (workspace.isDirty()) {
                            ApplicationNavigatorWindow.this._appPicker.setFont(this._italic);
                        } else {
                            ApplicationNavigatorWindow.this._appPicker.setFont(this._normal);
                        }
                        ApplicationNavigatorWindow.this._appPicker.setToolTipText(overlayToolTipText);
                    }
                    comp.setIcon(theIcon);
                } else if (value instanceof String) {
                    String itemName = (String)value;
                    if (itemName.equals(Res.getString(0)) && !ApplicationNavigatorWindow.this.enabledNewApplication) {
                        comp.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    }
                    comp.setFont(this._normal);
                    comp.setIcon(NULL_ICON);
                }
                return comp;
            }
        }
        this._appPicker.setRenderer(new LCR());
        this.createDrawerWindow();
        Layouts.getLayouts().addLayoutResetListener(new LayoutResetListener(){

            public void afterLayoutReset(LayoutResetEvent e) {
                DockStation ds = DockStation.getDockStation();
                ds.activateDockable((Dockable)ApplicationNavigatorWindow.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openContext(Context context) {
        boolean promptUserWhenNotFound = context.getBoolean("REFRESH_CMD_ID.promptUserWhenNotFound");
        context.setBoolean("REFRESH_CMD_ID.promptUserWhenNotFound", false);
        boolean found = false;
        List<DockableWindow> hostedDockables = this.getHostedDockables();
        if (hostedDockables != null) {
            Iterator<DockableWindow> iter = hostedDockables.iterator();
            while (iter.hasNext() && !found) {
                DockableWindow hostedDockable = iter.next();
                if (!(hostedDockable instanceof NavigatorWindow)) continue;
                try {
                    int dockableStatus = DockStation.getDockStation().getDockableStatus((Dockable)this);
                    if ((dockableStatus & 0x20) != 0) continue;
                }
                finally {
                    NavigatorWindow navigator = (NavigatorWindow)hostedDockable;
                    found = navigator.openContext(context, false);
                    if (!found || !context.getBoolean("REFRESH_CMD_ID.expandAndActivateOnFind")) continue;
                    this.show();
                    DockStation.getDockStation().activateDockable((Dockable)this);
                    if (!this._drawerWindow.showing((View)navigator)) {
                        this._drawerWindow.show((View)navigator);
                    }
                    this._drawerWindow.activate((View)navigator, true);
                    this._drawerWindow.expand((View)navigator);
                }
            }
            if (!found && promptUserWhenNotFound && !context.getBoolean("oracle.ide.model.ProjectContent.AutoSelecter")) {
                if (context.getWorkspace() != null) {
                    this.displayNodeNotFound(context.getNode().getShortLabel(), context.getWorkspace().getShortLabel());
                } else {
                    this.displayNodeNotFound(context.getNode().getShortLabel(), "Navigator");
                }
            }
        }
        return found;
    }

    private void displayNodeNotFound(String target, String searchSpaceName) {
        String prompt = NavigatorArb.format(7, target, searchSpaceName);
        String title = StringUtils.stripMnemonic((String)IdeArb.getString((int)352));
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)prompt, (String)title, null);
    }

    void selectApplication(Workspace application) {
        if (application != null) {
            this._appPicker.setSelectedItem(new DisplayURL((Node)application));
        }
    }

    @Override
    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (this._currentWorkspace != null) {
            Project project = this._currentWorkspace.currentActiveProject();
            context.setWorkspace(this._currentWorkspace);
            context.setNode((Node)this._currentWorkspace);
            context.setElement((Element)this._currentWorkspace);
            context.setProject(project);
        } else {
            context.setWorkspace(null);
            context.setProject(null);
        }
        return context;
    }

    @Override
    protected Workspace getCurrentWorkspace() {
        return this._currentWorkspace;
    }

    public boolean isUsingDrawer() {
        return true;
    }

    @Override
    public JComponent topComponent() {
        return this.topComponent;
    }

    @Override
    protected void addToNorth(JComponent comp) {
        this.topComponent = comp;
        if (this._drawerWindow != null) {
            this._drawerWindow.topComponent(comp);
        }
    }

    @Override
    public Component getGUI() {
        JPanel returnedGUI = this.gui;
        if (this.gui == null) {
            this.guiCardLayout = new CardLayout();
            this.gui = new JPanel(this.guiCardLayout);
            this.gui.setOpaque(false);
            JPanel startPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
            startPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(0xCCCCCC)));
            startPanel.setOpaque(false);
            final AbstractButton newButton = ApplicationNavigatorWindow.newStartButton(Res.getString(0), OracleIcons.getIcon((String)"header/createapplication.png"));
            newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationNavigatorWindow.this.invokeCreateNewApplication();
                }
            });
            startPanel.add(newButton);
            IdeAction action = IdeAction.find((String)"ObjectGalleryCommand");
            if (action != null) {
                newButton.setEnabled(action.isEnabled());
                action.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("enabled".equals(evt.getPropertyName())) {
                            boolean toEnable = Boolean.parseBoolean(evt.getNewValue().toString());
                            newButton.setEnabled(toEnable);
                            ApplicationNavigatorWindow.this.enabledNewApplication = toEnable;
                        }
                    }
                });
            } else {
                LOG.log(Level.WARNING, "ObjectGallery command was null in navigator. Not fatal, continuing ...");
            }
            AbstractButton openButton = ApplicationNavigatorWindow.newStartButton(Res.getString(1), OracleIcons.getIcon((String)"header/openapplication.png"));
            openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationNavigatorWindow.this.invokeOpenApplication();
                }
            });
            startPanel.add(openButton);
            startPanel.setBackground(UIManager.getColor("window"));
            this.gui.add((Component)startPanel, "start");
            Component navigatorGUI = this._drawerWindow.getGUI();
            super.initCommonItems();
            this.gui.add(navigatorGUI, "navigator");
            Workspaces workspaces = Ide.getWorkspaces();
            workspaces.attach(new Observer(){

                public void update(Object observed, UpdateMessage change) {
                    int mesgID = change.getMessageID();
                    if (mesgID == UpdateMessage.CHILD_ADDED) {
                        List addObjects = change.getAddObjects();
                        if (addObjects != null) {
                            for (Object next : addObjects) {
                                int i;
                                if (!(next instanceof Workspace)) continue;
                                Workspace workspace = (Workspace)next;
                                DisplayURL display = new DisplayURL((Node)workspace);
                                int n = ApplicationNavigatorWindow.this._appPicker.getItemCount();
                                for (i = 0; i < n; ++i) {
                                    Object obj = ApplicationNavigatorWindow.this._appPicker.getItemAt(i);
                                    if (obj instanceof DisplayURL) {
                                        DisplayURL cur = (DisplayURL)obj;
                                        if (cur.equals(display)) {
                                            display = cur;
                                            break;
                                        }
                                        if (cur.toString().compareTo(display.toString()) <= 0) continue;
                                        ApplicationNavigatorWindow.this._appPicker.insertItemAt(display, i);
                                        break;
                                    }
                                    ApplicationNavigatorWindow.this._appPicker.insertItemAt(display, i);
                                    break;
                                }
                                if (i == n) {
                                    ApplicationNavigatorWindow.this._appPicker.insertItemAt(display, n);
                                }
                                ApplicationNavigatorWindow.this._appPicker.setSelectedItem(display);
                            }
                        }
                        ApplicationNavigatorWindow.this.guiCardLayout.show(ApplicationNavigatorWindow.this.gui, "navigator");
                        if (ApplicationNavigatorWindow.this._appPicker.getItemCount() == 3) {
                            ApplicationNavigatorWindow.this._appPicker.requestFocus();
                        }
                    } else if (mesgID == UpdateMessage.CHILD_REMOVED) {
                        List removeObjects = change.getRemoveObjects();
                        if (removeObjects != null) {
                            for (Object next : removeObjects) {
                                if (!(next instanceof Workspace)) continue;
                                Workspace workspace = (Workspace)next;
                                DisplayURL display = new DisplayURL((Node)workspace);
                                ApplicationNavigatorWindow.this.removingApplication6674339 = true;
                                ApplicationNavigatorWindow.this._appPicker.removeItem(display);
                                ApplicationNavigatorWindow.this.removingApplication6674339 = false;
                            }
                        }
                        ApplicationNavigatorWindow.this.correctSelectionAfterWorkspaceRemoval();
                    }
                }
            });
            if (workspaces.size() > 0) {
                this.guiCardLayout.show(this.gui, "navigator");
            }
            returnedGUI = this.gui;
        }
        return returnedGUI;
    }

    private void correctSelectionAfterWorkspaceRemoval() {
        if (this.isLastWorkspaceRemoved()) {
            this.resetToBlankNavigator();
        } else {
            this._appPicker.setSelectedIndex(0);
        }
    }

    private void resetToBlankNavigator() {
        this._currentWorkspace = null;
        this.guiCardLayout.show(this.gui, "start");
        ViewSelectionEvent event = new ViewSelectionEvent((View)this);
        this.fireViewSelectionChanged(event);
    }

    private boolean isLastWorkspaceRemoved() {
        return Ide.getWorkspaces().size() == 0;
    }

    private void invokeCreateNewApplication() {
        String newAppCmd = "oracle.jdeveloper.cmd.NewApplicationCommand";
        IdeAction action = IdeAction.find((String)"oracle.jdeveloper.cmd.NewApplicationCommand");
        if (action != null) {
            try {
                action.putValue("invokedFrom", (Object)ACTION_INVOKED_FROM_VALUE);
                action.performAction(this.getContext());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void invokeOpenApplication() {
        String openAppCmd = "ContentSetSupport.ADD_TO_PROJECT_CMD_ID";
        IdeAction action = IdeAction.find((String)"ContentSetSupport.ADD_TO_PROJECT_CMD_ID");
        if (action != null) {
            try {
                Workspaces workspaces = Ide.getWorkspaces();
                Context context = this.getContext();
                context.setElement((Element)workspaces);
                context.setWorkspace(null);
                context.setProject(null);
                context.setNode(null);
                action.putValue("invokedFrom", (Object)ACTION_INVOKED_FROM_VALUE);
                action.performAction(context);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static AbstractButton newStartButton(String text, Icon icon) {
        TaskButton button = new TaskButton(ApplicationNavigatorWindow.class.getName());
        button.setText(text);
        button.setIcon(icon);
        button.setFont(button.getFont().deriveFont(1));
        return button;
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this._drawerWindow.updateVisibleActions(updateMessage);
    }

    @Override
    public Workspace currentApplication() {
        return this._currentWorkspace;
    }

    @Override
    public final void addApplicationChangeListener(ApplicationChangeListener listener) {
        if (listener != null && !this._applicationChangeListeners.contains(listener)) {
            this._applicationChangeListeners.add(listener);
        }
    }

    @Override
    public final void removeApplicationChangeListener(ApplicationChangeListener listener) {
        if (listener != null) {
            this._applicationChangeListeners.remove(listener);
        }
    }

    @Override
    protected void addFirstHostedWindow(DockableWindow toHost) {
        this._firstDrawer = null;
        this.addHostedWindow(toHost);
    }

    @Override
    public final void addHostedWindow(DockableWindow toHost) {
        this.addHostedWindowWithoutAddingDrawer(toHost);
        this._drawerWindow.removeIfPresent((View)toHost);
        this._drawerWindow.addDrawer(toHost);
        if (this._firstDrawer == null) {
            this._firstDrawer = toHost;
            this.getGUI();
            this._drawerWindow.expand((View)this._firstDrawer);
        }
    }

    private void addHostedWindowWithoutAddingDrawer(DockableWindow toHost) {
        this.hostedWindows.add(toHost);
    }

    public List<DockableWindow> getHostedDockables() {
        return this.hostedWindows;
    }

    private void fireApplicationChangeEvent(ApplicationChangeEvent event) {
        this.fireApplicationChangeEventImpl(event, this.hostedWindows);
        this.fireApplicationChangeEventImpl(event, this._applicationChangeListeners);
    }

    private void fireApplicationChangeEventImpl(ApplicationChangeEvent event, Collection listeners) {
        for (Object listenerObj : listeners) {
            if (!(listenerObj instanceof ApplicationChangeListener)) continue;
            try {
                ApplicationChangeListener listener = (ApplicationChangeListener)listenerObj;
                long startTime = System.nanoTime();
                listener.applicationChanged(event);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("ApplicationChangeListener.applicationChanged", listener.getClass().getName(), endTime - startTime);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                FeedbackManager.reportException((Throwable)t);
            }
        }
    }

    @Override
    protected void initToolbarArea() {
        Workspaces workspaces = Ide.getWorkspaces();
        Iterator iter = workspaces.getChildren();
        int i = 0;
        while (iter.hasNext()) {
            Object workspaceObj = iter.next();
            if (!(workspaceObj instanceof Workspace)) continue;
            Workspace workspace = (Workspace)workspaceObj;
            if (URLFileSystem.exists((URL)workspace.getURL())) {
                if (!Ide.getWorkspaces().containsChild((Element)workspace)) continue;
                DisplayURL display = new DisplayURL((Node)workspace);
                this._appPicker.insertItemAt(display, i++);
                continue;
            }
            workspaces.remove((Element)workspace);
            NodeFactory.uncache((URL)workspace.getURL());
        }
        this.initSelectedApplication();
        this.topComponent.add(this._appPicker);
        ToggleAction nopAction = new ToggleAction(Res.getString(4), ModelArb.getIcon((int)12)){

            public void actionPerformed(ActionEvent e) {
            }
        };
        final ContextMenu contextMenu = this.getContextMenu();
        MenuToolButton appMenu = new MenuToolButton(nopAction){
            private PopupMenuListener _popupMenuListener;
            {
                super(x0);
                this._popupMenuListener = new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        this.removePML();
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                };
            }

            private void removePML() {
                this.getModel().setArmed(false);
                this.setSelected(false);
                this._popup.removePopupMenuListener(this._popupMenuListener);
            }

            protected JPopupMenu createPopupMenu() {
                this._popup = (JPopupMenu)contextMenu.getGUI(true);
                return this._popup;
            }

            protected ItemListener createButtonItemListener() {
                final ItemListener superListener = super.createButtonItemListener();
                return new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        Context context = ApplicationNavigatorWindow.this.getContext();
                        Workspace workspace = context.getWorkspace();
                        context.setElement((Element)workspace);
                        ApplicationNavigatorWindow.this.getGUI().requestFocus();
                        context.setProject(null);
                        context.setNode((Node)workspace);
                        contextMenu.prepareShow(context);
                        _popup.addPopupMenuListener(_popupMenuListener);
                        superListener.itemStateChanged(e);
                    }
                };
            }
        };
        this.topComponent.add((Component)appMenu);
        this._pickerUI.setButton((AbstractButton)appMenu);
        appMenu.setFocusable(false);
        super.initToolbarArea();
    }

    @Override
    protected void initSelection() {
        super.initSelection();
        this.initSelectedApplication();
    }

    private void initSelectedApplication() {
        int selectedIndex = -1;
        int n = this._appPicker.getItemCount();
        if (this._initialWorkspaceURL != null) {
            for (int i = 0; i < n; ++i) {
                DisplayURL displayURL;
                Object obj = this._appPicker.getItemAt(i);
                if (!(obj instanceof DisplayURL) || !URLFileSystem.equals((URL)(displayURL = (DisplayURL)obj)._node.getURL(), (URL)this._initialWorkspaceURL)) continue;
                this._appPicker.setSelectedItem(null);
                this._appPicker.setSelectedIndex(i);
                selectedIndex = i;
                break;
            }
        }
        if (selectedIndex == -1) {
            if (n > 2) {
                this._appPicker.setSelectedIndex(0);
            } else {
                this._appPicker.setSelectedItem(null);
            }
        }
    }

    @Override
    public final void loadLayout(PropertyAccess layout) {
        if (!this.doneLoadLayout) {
            if (!this.drawerLayoutLoaded) {
                this.drawerLayoutLoaded = true;
                this._drawerWindow.loadLayout(layout);
                return;
            }
            String initialWorkspaceURLStr = layout.getProperty(INITIAL_WORKSPACE, null);
            if (initialWorkspaceURLStr != null) {
                this._initialWorkspaceURL = URLFactory.newURL((String)initialWorkspaceURLStr);
            }
            super.loadLayout(layout);
            this.loadDrawers();
            this.drawerLayoutLoaded = false;
            this.doneLoadLayout = true;
        }
    }

    private void loadDrawers() {
        for (View view : this._drawerWindow.drawerViews()) {
            this.addHostedWindowWithoutAddingDrawer((DockableWindow)view);
        }
    }

    @Override
    public final void saveLayout(PropertyAccess layout) {
        if (!this.drawerLayoutSaved) {
            this.drawerLayoutSaved = true;
            this._drawerWindow.saveLayout(layout);
            return;
        }
        super.saveLayout(layout);
        Object item = this._appPicker.getSelectedItem();
        if (item instanceof DisplayURL) {
            DisplayURL displayURL = (DisplayURL)item;
            String initialWorkspaceURLStr = displayURL._node.getURL().toString();
            layout.setProperty(INITIAL_WORKSPACE, initialWorkspaceURLStr);
        } else {
            layout.removeProperty(INITIAL_WORKSPACE);
        }
        this.drawerLayoutSaved = false;
    }

    private void registerActivationListener() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Component c = (Component)evt.getNewValue();
                boolean activeView = ApplicationNavigatorWindow.this.gui != null && c != null && SwingUtilities.isDescendingFrom(c, ApplicationNavigatorWindow.this.gui);
                ApplicationNavigatorWindow.this._pickerUI.setInActiveView(activeView);
                ApplicationNavigatorWindow.this._activeView = activeView;
            }
        });
    }

    private static class DisplayURL {
        private final Node _node;

        DisplayURL(Node node) {
            if (node == null) {
                throw new IllegalArgumentException();
            }
            this._node = node;
        }

        public String toString() {
            URL url = this._node.getURL();
            if (URLFileSystem.hasSuffix((URL)url, (String)".jws")) {
                String fileName = URLFileSystem.getFileName((URL)url);
                return fileName.substring(0, fileName.length() - ".jws".length());
            }
            return URLFileSystem.getName((URL)this._node.getURL());
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            DisplayURL other = (DisplayURL)o;
            return this._node == other._node || this._node.getLongLabel().equals(other._node.getLongLabel());
        }
    }
}

