/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.window;

import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.status.resource.StatusBundle;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.util.FormatBundle;

public class StatusTableModel
extends AbstractTableModel {
    public static final int BUTTON_COLUMN = 0;
    public static final int MESSAGE_COLUMN = 1;
    private static final FormatBundle BUNDLE = new FormatBundle(StatusBundle.class);
    private URL file;
    private Project project;
    private Workspace workspace;
    private EnumSet<Severity> filter;
    private IssueList issues;
    private List<Issue> visibleIssues;

    public StatusTableModel(URL file, Project project, Workspace workspace, EnumSet<Severity> filter, IssueList issues) {
        this.file = file;
        this.project = project;
        this.workspace = workspace;
        this.filter = EnumSet.copyOf(filter);
        this.issues = issues;
        this.visibleIssues = new ArrayList<Issue>();
        if (issues != null) {
            for (Issue issue : issues) {
                if (!filter.contains(issue.getSeverity())) continue;
                this.visibleIssues.add(issue);
            }
        }
    }

    public URL getFile() {
        return this.file;
    }

    public Project getProject() {
        return this.project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Icon getSummaryIcon() {
        if (this.issues != null) {
            return this.issues.getSeverity().getIcon();
        }
        return Severity.UNKNOWN.getIcon();
    }

    public String getSummaryMessage() {
        if (this.issues != null) {
            if (this.issues.isStale()) {
                return BUNDLE.get("status.analyzing.label");
            }
            int errors = this.issues.getErrorCount();
            int warnings = this.issues.getWarningCount();
            int incompletes = this.issues.getIncompleteCount();
            int advisories = this.issues.getAdvisoryCount();
            int count = this.count(errors) + this.count(warnings) + this.count(incompletes) + this.count(advisories);
            Object[] arguments = new Object[count];
            int index = 0;
            index = this.text(arguments, index, "errors", errors, BUNDLE);
            index = this.text(arguments, index, "warnings", warnings, BUNDLE);
            index = this.text(arguments, index, "incompletes", incompletes, BUNDLE);
            this.text(arguments, index, "advisories", advisories, BUNDLE);
            return BUNDLE.get("status.completed." + count + ".label", arguments);
        }
        return BUNDLE.get("status.unselected.label");
    }

    private int count(int count) {
        return count > 0 ? 1 : 0;
    }

    private int text(Object[] arguments, int index, String prefix, int count, FormatBundle bundle) {
        String key;
        switch (count) {
            case 0: {
                return index;
            }
            case 1: {
                key = prefix + "-1";
                break;
            }
            default: {
                key = prefix + "-n";
            }
        }
        arguments[index] = bundle.get(key, new Object[]{count});
        return index + 1;
    }

    public void setFilter(EnumSet<Severity> newFilter) {
        EnumSet<Severity> oldFilter = this.filter;
        this.filter = EnumSet.copyOf(newFilter);
        this.visibleIssues.clear();
        if (this.issues != null) {
            for (Issue issue : this.issues) {
                boolean isVisible;
                Severity severity = issue.getSeverity();
                boolean wasVisible = oldFilter.contains(severity);
                if (wasVisible != (isVisible = newFilter.contains(severity))) {
                    int index = this.visibleIssues.size();
                    if (wasVisible) {
                        this.fireTableRowsDeleted(index, index);
                    } else {
                        this.fireTableRowsInserted(index, index);
                    }
                }
                if (!isVisible) continue;
                this.visibleIssues.add(issue);
            }
        }
    }

    public Issue getIssueAt(int rowIndex) {
        return this.visibleIssues.get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.visibleIssues.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Issue.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Issue issue = this.visibleIssues.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return issue;
            }
            case 1: {
                return issue.getMessage();
            }
        }
        return null;
    }
}

