/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status.editor;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.status.editor.StatusEditorPlugin;
import oracle.ide.status.editor.TransformFilter;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdevimpl.audit.AuditBundle;

public class StatusEditorManager
implements ContextMenuListener,
Controller,
DynamicMenuListener,
EditorListener,
IdeListener,
PropertyChangeListener {
    private static StatusEditorManager instance;
    private AuditPreferences preferences;
    private IdeAction codeAssistAction;
    private TransformFilter transformFilter;
    private static final Log LOG;
    private static final FormatBundle BUNDLE;
    private static final String KEY;
    private JComponent[] dynamicActions;
    private JComponent[] noActions = new JComponent[0];

    public static void createAuditEditorManager() {
        if (instance != null) {
            throw new IllegalStateException("StatusEditorManager created twice");
        }
        instance = new StatusEditorManager();
    }

    private StatusEditorManager() {
        int cid = Ide.findOrCreateCmdID((String)"audit-assist");
        String category = CodeMenuConstants.CATEGORY_CODE_MENU;
        String name = BUNDLE.get("editor.menu.label");
        Integer mnemonic = BUNDLE.get("editor.menu.mnemonic").charAt(0);
        this.codeAssistAction = IdeAction.get((int)cid, null, (String)name, (String)category, (Integer)mnemonic, (Icon)OracleIcons.getIcon((String)"assist.png"), null, (boolean)true);
        this.codeAssistAction.addController((Controller)this);
        this.preferences = AuditManager.getAuditManager().getPreferences();
        this.preferences.addPropertyChangeListener("auditWhileEditing", (PropertyChangeListener)this);
        if (this.preferences.isAuditWhileEditing()) {
            if (Ide.isStarting()) {
                Ide.addIdeListener((IdeListener)this);
            } else {
                this.start();
            }
        }
        StatusEditorPlugin.ensureStylesCreated();
    }

    private void start() {
        LOG.trace("starting background audit");
        EditorManager manager = EditorManager.getEditorManager();
        manager.addEditorListener((EditorListener)this);
        manager.getContextMenu().addContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)this);
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        this.preferences = AuditManager.getAuditManager().getPreferences();
        this.transformFilter = new TransformFilter();
        List editors = EditorManager.getEditorManager().getAllEditors();
        for (Object editor : editors) {
            if (!(editor instanceof CodeEditor)) continue;
            this.installPlugin((CodeEditor)editor);
        }
    }

    private void stop() {
        LOG.trace("stopping background audit");
        EditorManager manager = EditorManager.getEditorManager();
        manager.removeEditorListener((EditorListener)this);
        manager.getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().removeContextMenuListener((ContextMenuListener)this);
        List editors = EditorManager.getEditorManager().getAllEditors();
        for (Object editor : editors) {
            if (!(editor instanceof CodeEditor)) continue;
            this.deinstallPlugin((CodeEditor)editor);
        }
        this.preferences = null;
    }

    private void installPlugin(CodeEditor codeEditor) {
        Context context = codeEditor.getContext();
        LOG.trace("installing audit editor plugin into {0}", (Object)context);
        StatusEditorPlugin plugin = new StatusEditorPlugin(codeEditor, this.preferences, this.transformFilter);
        BasicEditorPane component = codeEditor.getFocusedEditorPane();
        component.installPlugin((EditorPlugin)plugin);
    }

    private void deinstallPlugin(CodeEditor codeEditor) {
        LOG.trace("deinstalling audit editor plugin from {0}", (Object)codeEditor.getContext());
        BasicEditorPane component = codeEditor.getFocusedEditorPane();
        StatusEditorPlugin plugin = (StatusEditorPlugin)component.getProperty(KEY);
        component.deinstallPlugin((EditorPlugin)plugin);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object value = event.getNewValue();
        LOG.trace("property {0} changed to {1}", (Object)name, value);
        if (name.equals("auditWhileEditing")) {
            if (Boolean.TRUE.equals(value)) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        this.start();
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            this.installPlugin((CodeEditor)editor);
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            this.deinstallPlugin((CodeEditor)editor);
        }
    }

    public boolean update(IdeAction action, Context context) {
        BasicEditorPane editor;
        StatusEditorPlugin plugin;
        if (action != this.codeAssistAction) {
            return false;
        }
        View view = context.getView();
        if (view instanceof CodeEditor) {
            BasicEditorPane editor2 = ((CodeEditor)view).getFocusedEditorPane();
            StatusEditorPlugin plugin2 = (StatusEditorPlugin)editor2.getProperty(KEY);
            if (plugin2 != null) {
                this.codeAssistAction.setEnabled(plugin2.isCodeAssistPopupEnabled());
            }
        } else if (view instanceof CodeEditorGutter.GutterView && (plugin = (StatusEditorPlugin)(editor = ((CodeEditor)view.owner()).getFocusedEditorPane()).getProperty(KEY)) != null) {
            this.codeAssistAction.setEnabled(plugin.isCodeAssistPopupEnabled());
        }
        return true;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            if (action == this.codeAssistAction) {
                BasicEditorPane editor = ((CodeEditor)view).getFocusedEditorPane();
                StatusEditorPlugin plugin = (StatusEditorPlugin)editor.getProperty(KEY);
                if (plugin != null && plugin.isCodeAssistPopupEnabled()) {
                    plugin.showCodeAssistPopup(context);
                } else {
                    editor.getToolkit().beep();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu menu) {
        if (Product.isRaptor()) {
            return;
        }
        Context context = menu.getContext();
        EventObject event = context.getEvent();
        if (!(event instanceof MouseEvent)) {
            return;
        }
        View view = context.getView();
        if (view instanceof CodeEditor) {
            BasicEditorPane editor = ((CodeEditor)view).getFocusedEditorPane();
            StatusEditorPlugin plugin = (StatusEditorPlugin)editor.getProperty(KEY);
            if (plugin == null) {
                return;
            }
            JMenuItem menuItem = menu.createMenuItem((ToggleAction)this.codeAssistAction, 135.0f);
            menuItem.setEnabled(plugin.isCodeAssistPopupEnabled());
            menu.add((Component)menuItem, MenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        } else if (view instanceof CodeEditorGutter.GutterView) {
            GutterMark mark;
            String columnName;
            BasicEditorPane editor = ((CodeEditor)view.owner()).getFocusedEditorPane();
            StatusEditorPlugin plugin = (StatusEditorPlugin)editor.getProperty(KEY);
            if (plugin == null) {
                return;
            }
            if (CodeEditorGutter.isMarkDroppingDown((Context)context) && !"lightbulb".equals(columnName = (mark = CodeEditorGutter.getMarkForContext((Context)context)).getGutterColumn().getColumnName())) {
                return;
            }
            int line = CodeEditorGutter.getLineForContext((Context)context) - 1;
            LOG.trace("popping up code editor context menu at line {0}", line);
            float section = 1.0f;
            for (JMenuItem item : plugin.getMenuItemsForLine(line)) {
                if (item != null) {
                    menu.add((Component)item, section);
                    continue;
                }
                section = MenuConstants.increment((float)section);
            }
        }
    }

    public void menuWillHide(ContextMenu menu) {
    }

    public JComponent[] gatherDynamicActions(Context context) {
        StatusEditorPlugin plugin;
        BasicEditorPane editor;
        if (Product.isRaptor()) {
            return this.noActions;
        }
        View view = context.getView();
        if (view instanceof CodeEditor && (editor = ((CodeEditor)view).getFocusedEditorPane()) != null && (plugin = (StatusEditorPlugin)editor.getProperty(KEY)) != null) {
            if (this.dynamicActions == null) {
                JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.codeAssistAction, 135.0f);
                menuItem.putClientProperty("menu-section-id", new Float(1.0f));
                this.dynamicActions = new JComponent[]{menuItem};
            }
            return this.dynamicActions;
        }
        return this.noActions;
    }

    static {
        LOG = new Log("editor");
        BUNDLE = new FormatBundle(AuditBundle.class);
        KEY = StatusEditorPlugin.AUDIT_EDITOR_PLUGIN_KEY;
    }
}

