/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.status.AssistListener;
import oracle.ide.status.DefaultIssueList;
import oracle.ide.status.DefaultStatus;
import oracle.ide.status.IssueListener;
import oracle.ide.status.MonitorContext;
import oracle.ide.status.StalenessListener;
import oracle.ide.status.StatusExecutor;
import oracle.ide.status.StatusListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.status.Status;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.CompositeDependency;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.DependencyListener;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.service.AuditListener;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Violation;

class StatusMonitor
implements DependencyListener {
    private static final long POSSIBLE_SEQUENCE_DELAY = TimeUnit.NANOSECONDS.convert(800L, TimeUnit.MILLISECONDS);
    private final URL file;
    private final Project project;
    private final Workspace workspace;
    private final MonitorContext context;
    private DefaultStatus lastStatus;
    private SoftReference<DefaultIssueList> lastIssues;
    private SoftReference<DefaultIssueList> lastAssists;
    private long lastTime;
    private CompositeDependency dependencies;
    private long lastChangedTime;
    private long lastScheduledTime;
    private int pendingTasks;
    private volatile StatusTask taskToCancel;
    private volatile boolean shuttingDown;
    private CopyOnWriteArrayList<StatusListener> statusListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<IssueListener> issueListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<AssistListener> assistListeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<StalenessListener> stalenessListeners = new CopyOnWriteArrayList();
    private Map<EventListener, View> views;
    private CopyOnWriteArrayList<IssueListener> newIssueListeners;
    private CopyOnWriteArrayList<AssistListener> newAssistListeners;
    private static final Log LOG = new Log("status");
    private static final Log LOGISSUES = new Log("status-issues");
    private static final Log LOGLOCK = new Log("status-lock");
    private static final Log LOGRUN = new Log("status", "status-run", "status-run-cause");
    private static final Log LOGRUNCAUSE = new Log("status-run-cause");
    private static final Logger LOGGER = Logger.getLogger("status");

    public StatusMonitor(URL file, Project project, Workspace workspace, MonitorContext context) {
        this.file = file;
        this.project = project;
        this.workspace = workspace;
        this.context = context;
        this.lastStatus = new DefaultStatus();
    }

    public URL getFile() {
        return this.file;
    }

    public Project getProject() {
        return this.project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public synchronized Collection<View> getViews() {
        return this.views != null ? this.views.values() : null;
    }

    public synchronized Status addStatusListener(StatusListener listener) {
        assert (LOG.trace("adding status listener to {0}", (Object)this));
        int count = this.statusListeners.size() + this.issueListeners.size() + this.assistListeners.size();
        this.statusListeners.addIfAbsent(listener);
        if (count == 0 || this.lastStatus.isStale() && this.pendingTasks == 0) {
            this.submit();
        }
        return this.lastStatus;
    }

    public synchronized void removeStatusListener(StatusListener listener) {
        assert (LOG.trace("removing status listener from {0}", (Object)this));
        boolean removed = this.statusListeners.remove(listener);
        if (removed && this.pendingTasks == 0 && this.statusListeners.size() + this.issueListeners.size() + this.assistListeners.size() == 0) {
            this.submit();
        }
    }

    public synchronized Iterable<StatusListener> getStatusListeners() {
        return this.statusListeners;
    }

    public synchronized IssueList addIssueListener(IssueListener listener, View view) {
        DefaultIssueList issues;
        assert (LOG.trace("adding issue listener to {0}", (Object)this));
        this.issueListeners.addIfAbsent(listener);
        if (view != null) {
            if (this.views == null) {
                this.views = new HashMap<EventListener, View>();
            }
            this.views.put(listener, view);
        }
        DefaultIssueList defaultIssueList = issues = this.lastIssues != null ? this.lastIssues.get() : null;
        if (issues == null) {
            issues = this.lastStatus != null ? new DefaultIssueList(this.lastStatus, false) : new DefaultIssueList(false);
            assert (issues.isStale());
        }
        if (issues.isStale()) {
            boolean submit;
            boolean bl = submit = view != null || this.newIssueListeners == null && this.newAssistListeners == null;
            if (this.newIssueListeners == null) {
                this.newIssueListeners = new CopyOnWriteArrayList();
            }
            this.newIssueListeners.addIfAbsent(listener);
            if (submit) {
                this.submit();
            }
        }
        return issues;
    }

    public synchronized void removeIssueListener(IssueListener listener) {
        assert (LOG.trace("removing issue listener from {0}", (Object)this));
        boolean removed = this.issueListeners.remove(listener);
        if (removed) {
            this.views.remove(listener);
            if (this.newIssueListeners != null) {
                this.newIssueListeners.remove(listener);
                if (this.newIssueListeners.isEmpty()) {
                    this.newIssueListeners = null;
                }
            }
            if (this.statusListeners.size() + this.issueListeners.size() + this.assistListeners.size() == 0) {
                this.submit();
            }
        }
    }

    public synchronized Iterable<IssueListener> getIssueListeners() {
        return this.issueListeners;
    }

    public synchronized IssueList addAssistListener(AssistListener listener, View view) {
        DefaultIssueList assists;
        assert (LOG.trace("adding assist listener {0} to {1}, view {2}", (Object)listener, (Object)this, (Object)view));
        this.assistListeners.addIfAbsent(listener);
        if (view != null) {
            if (this.views == null) {
                this.views = new HashMap<EventListener, View>();
            }
            this.views.put(listener, view);
            this.enableLockEventLog(view);
        }
        DefaultIssueList defaultIssueList = assists = this.lastAssists != null ? this.lastAssists.get() : null;
        if (assists == null) {
            DefaultIssueList issues;
            if (this.lastIssues != null && (issues = this.lastIssues.get()) != null) {
                assists = new DefaultIssueList(issues, true);
            }
            if (assists == null) {
                assists = this.lastStatus != null ? new DefaultIssueList(this.lastStatus, true) : new DefaultIssueList(true);
            }
            assert (assists.isStale());
        }
        if (assists.isStale()) {
            boolean submit;
            boolean bl = submit = view != null || this.newIssueListeners == null && this.newAssistListeners == null;
            if (this.newAssistListeners == null) {
                this.newAssistListeners = new CopyOnWriteArrayList();
            }
            this.newAssistListeners.add(listener);
            if (submit) {
                this.submit();
            }
        }
        return assists;
    }

    public synchronized void removeAssistListener(AssistListener listener) {
        assert (LOG.trace("removing assist listener {0} from {1}", (Object)listener, (Object)this));
        boolean removed = this.assistListeners.remove(listener);
        if (removed) {
            View view = this.views.remove(listener);
            this.disableLockEventLog(view);
            if (this.newAssistListeners != null) {
                this.newAssistListeners.remove(listener);
                if (this.newAssistListeners.isEmpty()) {
                    this.newAssistListeners = null;
                }
            }
            if (this.statusListeners.size() + this.issueListeners.size() + this.assistListeners.size() == 0) {
                this.submit();
            }
        }
    }

    public synchronized Iterable<AssistListener> getAssistListeners() {
        return this.assistListeners;
    }

    public synchronized boolean addStalenessListener(StalenessListener listener) {
        assert (LOG.trace("adding staleness listener to {0}", (Object)this));
        this.stalenessListeners.addIfAbsent(listener);
        return this.lastStatus.isStale();
    }

    public synchronized void removeStalenessListener(StalenessListener listener) {
        assert (LOG.trace("removing status listener from {0}", (Object)this));
        boolean removed = this.stalenessListeners.remove(listener);
        if (removed && this.statusListeners.size() + this.issueListeners.size() + this.assistListeners.size() + this.stalenessListeners.size() == 0) {
            this.submit();
        }
    }

    public synchronized Iterable<StalenessListener> getStalenessListeners() {
        return this.stalenessListeners;
    }

    public synchronized View getView(EventListener listener) {
        return this.views == null ? null : this.views.get(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profileChanged() {
        LOGLOCK.trace("processing profile changed in {0}", (Object)this);
        StatusMonitor statusMonitor = this;
        synchronized (statusMonitor) {
            this.forceUpdate(false);
        }
    }

    public void dependencyChanged(Dependency dependency, boolean possibleSequence) {
        LOGLOCK.trace("processing dependencies changed from {1}, possible sequence {0}, in {2}", (Object)possibleSequence, (Object)dependency, (Object)this);
        this.forceUpdate(possibleSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceUpdate(boolean possibleSequence) {
        StatusMonitor statusMonitor = this;
        synchronized (statusMonitor) {
            if (this.shuttingDown) {
                return;
            }
            this.lastChangedTime = StatusExecutor.translatedNow();
            if (possibleSequence) {
                this.lastScheduledTime = this.lastChangedTime + POSSIBLE_SEQUENCE_DELAY;
                this.submit(this.lastScheduledTime);
            } else {
                if (this.lastScheduledTime <= this.lastChangedTime) {
                    this.lastScheduledTime = this.lastChangedTime;
                }
                if (this.pendingTasks == 0) {
                    this.submit();
                }
            }
        }
    }

    private void submit() {
        this.submit(StatusExecutor.translatedNow());
    }

    private synchronized void submit(long when) {
        if (this.shuttingDown) {
            return;
        }
        ++this.pendingTasks;
        this.context.executor().submit(new StatusTask(when));
    }

    public synchronized void cancel() {
        LOGLOCK.trace("cancelling {0}", (Object)this);
        StatusTask task = this.taskToCancel;
        if (task != null) {
            task.cancel(false);
        }
    }

    public void shutdown() {
        LOG.trace("shutting down {0}", (Object)this);
        this.shuttingDown = true;
        this.cancel();
        if (this.dependencies != null) {
            this.dependencies.clear();
            this.dependencies = null;
            this.lastTime = 0L;
        }
    }

    private void fireStatusListeners(DefaultStatus status, DefaultIssueList issues, DefaultIssueList assists, Iterator<StatusListener> statusListenerIterator, Iterator<IssueListener> issueListenerIterator, Iterator<AssistListener> assistListenerIterator) {
        EventListener listener;
        assert (LOG.trace("firing status changed for {0} to {1}; {2}", (Object)this, (Object)issues, (Object)assists));
        if (statusListenerIterator != null) {
            while (statusListenerIterator.hasNext()) {
                listener = statusListenerIterator.next();
                try {
                    assert (LOG.trace("firing status changed for {0} to status listener {1}", (Object)this, (Object)listener));
                    listener.statusChanged(this.file, this.project, this.workspace, status);
                }
                catch (Throwable e) {
                    AuditLogger.error((String)"error firing status changed for {0} to {1}: {2}", (Object[])new Object[]{this, listener, e});
                }
            }
        }
        if (issueListenerIterator != null) {
            while (issueListenerIterator.hasNext()) {
                listener = issueListenerIterator.next();
                try {
                    assert (LOG.trace("firing status changed for {0} to issue listener {1}", (Object)this, (Object)listener));
                    listener.statusChanged(this.file, this.project, this.workspace, issues);
                }
                catch (Throwable e) {
                    AuditLogger.error((String)"error firing status changed for {0} to issue listener {1}: {2}", (Object[])new Object[]{this, listener, e});
                }
            }
        }
        if (assistListenerIterator != null) {
            while (assistListenerIterator.hasNext()) {
                listener = assistListenerIterator.next();
                try {
                    assert (LOG.trace("firing status changed for {0} to assist listener {1}", (Object)this, (Object)listener));
                    listener.statusChanged(this.file, this.project, this.workspace, assists);
                }
                catch (Throwable e) {
                    AuditLogger.error((String)"error first status changed for {0} to assist listener {1}: {2}", (Object[])new Object[]{this, listener, e});
                }
            }
        }
    }

    public String toString() {
        return "StatusMonitor[" + URLFileSystem.getFileName((URL)this.getFile()) + ", " + Log.formatTranslatedTime((long)this.lastTime) + ", " + this.lastStatus + "]";
    }

    private void enableLockEventLog(View view) {
        Node node;
        if (LOGLOCK.isEnabled() && view instanceof CodeEditor && (node = NodeFactory.find((URL)this.file)) != null) {
            node.setEventLog(LOGLOCK);
        }
    }

    private void disableLockEventLog(View view) {
        Node node;
        if (LOGLOCK.isEnabled() && view instanceof CodeEditor && (node = NodeFactory.find((URL)this.file)) != null) {
            node.setEventLog(null);
        }
    }

    static /* synthetic */ StatusTask access$602(StatusMonitor x0, StatusTask x1) {
        x0.taskToCancel = x1;
        return x0.taskToCancel;
    }

    static /* synthetic */ int access$710(StatusMonitor x0) {
        return x0.pendingTasks--;
    }

    static /* synthetic */ boolean access$800(StatusMonitor x0) {
        return x0.shuttingDown;
    }

    static /* synthetic */ long access$900(StatusMonitor x0) {
        return x0.lastChangedTime;
    }

    static /* synthetic */ long access$1000(StatusMonitor x0) {
        return x0.lastTime;
    }

    static /* synthetic */ CopyOnWriteArrayList access$1100(StatusMonitor x0) {
        return x0.statusListeners;
    }

    static /* synthetic */ CopyOnWriteArrayList access$1200(StatusMonitor x0) {
        return x0.issueListeners;
    }

    static /* synthetic */ CopyOnWriteArrayList access$1300(StatusMonitor x0) {
        return x0.assistListeners;
    }

    static /* synthetic */ CopyOnWriteArrayList access$1400(StatusMonitor x0) {
        return x0.stalenessListeners;
    }

    static /* synthetic */ DefaultStatus access$1500(StatusMonitor x0) {
        return x0.lastStatus;
    }

    static /* synthetic */ CompositeDependency access$1600(StatusMonitor x0) {
        return x0.dependencies;
    }

    static /* synthetic */ Log access$1700() {
        return LOG;
    }

    static /* synthetic */ SoftReference access$1800(StatusMonitor x0) {
        return x0.lastIssues;
    }

    static /* synthetic */ SoftReference access$1900(StatusMonitor x0) {
        return x0.lastAssists;
    }

    static /* synthetic */ CompositeDependency access$1602(StatusMonitor x0, CompositeDependency x1) {
        x0.dependencies = x1;
        return x0.dependencies;
    }

    static /* synthetic */ long access$1002(StatusMonitor x0, long x1) {
        x0.lastTime = x1;
        return x0.lastTime;
    }

    static /* synthetic */ CopyOnWriteArrayList access$2000(StatusMonitor x0) {
        return x0.newIssueListeners;
    }

    static /* synthetic */ CopyOnWriteArrayList access$2100(StatusMonitor x0) {
        return x0.newAssistListeners;
    }

    static /* synthetic */ long access$2200(StatusMonitor x0) {
        return x0.lastScheduledTime;
    }

    static /* synthetic */ int access$700(StatusMonitor x0) {
        return x0.pendingTasks;
    }

    static /* synthetic */ void access$2300(StatusMonitor x0, long x1) {
        x0.submit(x1);
    }

    static /* synthetic */ CopyOnWriteArrayList access$2002(StatusMonitor x0, CopyOnWriteArrayList x1) {
        x0.newIssueListeners = x1;
        return x0.newIssueListeners;
    }

    static /* synthetic */ CopyOnWriteArrayList access$2102(StatusMonitor x0, CopyOnWriteArrayList x1) {
        x0.newAssistListeners = x1;
        return x0.newAssistListeners;
    }

    static /* synthetic */ Project access$2400(StatusMonitor x0) {
        return x0.project;
    }

    static /* synthetic */ Workspace access$2500(StatusMonitor x0) {
        return x0.workspace;
    }

    static /* synthetic */ Logger access$2600() {
        return LOGGER;
    }

    static /* synthetic */ DefaultStatus access$1502(StatusMonitor x0, DefaultStatus x1) {
        x0.lastStatus = x1;
        return x0.lastStatus;
    }

    static /* synthetic */ SoftReference access$1802(StatusMonitor x0, SoftReference x1) {
        x0.lastIssues = x1;
        return x0.lastIssues;
    }

    static /* synthetic */ SoftReference access$1902(StatusMonitor x0, SoftReference x1) {
        x0.lastAssists = x1;
        return x0.lastAssists;
    }

    static /* synthetic */ void access$2700(StatusMonitor x0, DefaultStatus x1, DefaultIssueList x2, DefaultIssueList x3, Iterator x4, Iterator x5, Iterator x6) {
        x0.fireStatusListeners(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ long access$2202(StatusMonitor x0, long x1) {
        x0.lastScheduledTime = x1;
        return x0.lastScheduledTime;
    }

    static /* synthetic */ long access$2800() {
        return POSSIBLE_SEQUENCE_DELAY;
    }

    private static class StatusAuditListener
    implements AuditListener {
        private ArrayList<DefaultStatus> listeners = new ArrayList(3);

        public StatusAuditListener(DefaultStatus ... listeners) {
            for (DefaultStatus listener : listeners) {
                if (listener == null) continue;
                this.listeners.add(listener);
            }
        }

        public void addException(Throwable e, URL file, Project project, Workspace workspace, ModelFactory factory) {
            for (DefaultStatus listener : this.listeners) {
                listener.addException(e, file, project, workspace, factory);
            }
        }

        public void addOptionalAnalyses(Collection<Issue> issues) {
            for (DefaultStatus listener : this.listeners) {
                for (Issue issue : issues) {
                    listener.addOptionalAnalysis(issue);
                }
            }
        }

        public void markUnauditable(URL file, Project project, Workspace workspace, ModelFactory factory) {
            for (DefaultStatus listener : this.listeners) {
                listener.markUnauditable(file, project, workspace, factory);
            }
        }

        public void issueReported(Auditor auditor, Violation issue, int transformMask) {
            LOGISSUES.trace("issue reported: {0}", (Object)issue);
            Severity severity = DefaultStatus.issueSeverity(issue.getRule().getSeverity());
            for (DefaultStatus listener : this.listeners) {
                listener.addViolation(severity, issue, transformMask);
            }
        }

        public void markCurrent() {
            for (DefaultStatus listener : this.listeners) {
                listener.markCurrent();
            }
        }

        public void auditorCleared(Auditor auditor) {
        }

        public void auditStarted(Auditor auditor, List<Metric> columns, List<Location> locations, Location root, Class type) {
        }

        public void auditStopped(Auditor auditor, boolean cancelled) {
        }

        public void locationEntered(Auditor auditor, Location location, Class type) {
        }

        public void locationExited(Auditor auditor, Location location) {
        }

        public void modelEntered(Auditor auditor, ModelAdapter model) {
        }

        public void modelExited(Auditor auditor, ModelAdapter model) {
        }

        public void phaseStarted(Auditor auditor, String phaseName) {
        }

        public void valueReported(Auditor auditor, Location location, Metric metric, Object newValue) {
        }
    }

    private class StatusTask
    implements StatusExecutor.Task,
    WriteLockRequestListener {
        private final long scheduledTime;
        private final long sequence;
        private final int priority;
        private volatile boolean cancelled;
        private volatile boolean done;
        private volatile Auditor auditorToCancel;
        private volatile Thread statusThread;
        private Throwable submittedTrace;
        private long submittedTime;
        private String submittedName;

        public StatusTask(long delay) {
            this.scheduledTime = delay;
            this.sequence = StatusMonitor.this.context.sequence();
            int priority = 0;
            if (StatusMonitor.this.views != null) {
                View lastActiveView = Ide.getMainWindow().getLastActiveView();
                priority = StatusMonitor.this.views.size();
                for (View view : StatusMonitor.this.views.values()) {
                    if (view != lastActiveView) continue;
                    priority = Integer.MAX_VALUE;
                    break;
                }
            }
            this.priority = priority;
            if (LOGRUN.isEnabled()) {
                this.submittedTime = StatusExecutor.translatedNow();
                if (LOGRUNCAUSE.isEnabled()) {
                    this.submittedTrace = new Throwable();
                }
                this.submittedName = URLFileSystem.getFileName((URL)StatusMonitor.this.file);
            }
        }

        @Override
        public boolean cancel(boolean maybeInterrupt) {
            this.cancelled = true;
            Auditor auditor = this.auditorToCancel;
            LOGLOCK.trace("cancelling task {1}, done {0}, auditor {2}", (Object)this.done, (Object)this, (Object)auditor);
            if (auditor != null) {
                auditor.cancel();
            }
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.scheduledTime - StatusExecutor.translatedNow();
            return unit == TimeUnit.NANOSECONDS ? delay : unit.convert(delay, TimeUnit.NANOSECONDS);
        }

        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(Delayed that) {
            return this.compareTo((StatusTask)that);
        }

        @Override
        public int compareTo(StatusTask that) {
            long comparison;
            long thatTime;
            long thisTime = this.scheduledTime - StatusExecutor.translatedNow();
            if (thisTime < 0L) {
                thisTime = 0L;
            }
            if ((thatTime = that.scheduledTime - StatusExecutor.translatedNow()) < 0L) {
                thatTime = 0L;
            }
            if ((comparison = thisTime - thatTime) < 0L) {
                return -1;
            }
            if (comparison > 0L) {
                return 1;
            }
            int priority = that.getPriority() - this.getPriority();
            if (priority != 0) {
                return priority;
            }
            comparison = this.sequence - that.sequence;
            if (comparison < 0L) {
                return -1;
            }
            if (comparison > 0L) {
                return 1;
            }
            return 0;
        }

        public void writeRequested(ReadWriteLock lock) {
            if (Thread.currentThread() != this.statusThread) {
                LOGLOCK.trace("write lock {0} requested for {1}", (Object)lock, (Object)this);
                this.cancel(false);
                StatusMonitor.this.forceUpdate(true);
            }
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        public String toString() {
            return StatusMonitor.this.toString();
        }
    }
}

