/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.status.AssistListener;
import oracle.ide.status.IssueListener;
import oracle.ide.status.MonitorContext;
import oracle.ide.status.StalenessListener;
import oracle.ide.status.StatusExecutor;
import oracle.ide.status.StatusListener;
import oracle.ide.status.StatusMonitor;
import oracle.ide.view.View;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Severity;
import oracle.javatools.status.Status;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdevimpl.audit.util.EmptyIterator;

public class StatusManager {
    private static final boolean SUPRESSED = Boolean.getBoolean("oracle.status.suppressed");
    private static StatusManager manager;
    private Map<Workspace, Map<Project, Map<URL, StatusMonitor>>> monitorsByWorkspace = new LinkedHashMap<Workspace, Map<Project, Map<URL, StatusMonitor>>>();
    private MultiMap<EventListener, StatusMonitor> listeners = new MultiMap(IdentityHashMap.class, HashSet.class);
    private MonitorContext context;
    private MultiListener listener;
    private final IssueList NULL_STATUS = new NullIssueList();
    private static final Log LOG;

    public static synchronized StatusManager getStatusManager() {
        if (manager == null) {
            LOG.trace("creating status manager");
            manager = new StatusManager();
        }
        return manager;
    }

    private StatusManager() {
        this.listener = new MultiListener();
        this.context = new MonitorContext(new StatusExecutor(), this.listener);
        Ide.getWorkspaces().attach((Observer)this.listener);
    }

    public synchronized Status addStatusListener(URL file, Project project, Workspace workspace, StatusListener listener) {
        if (SUPRESSED) {
            return this.NULL_STATUS;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.listeners.add((Object)listener, (Object)monitor);
        return monitor.addStatusListener(listener);
    }

    public synchronized void removeStatusListener(URL file, Project project, Workspace workspace, StatusListener listener) {
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeStatusListener(listener);
            this.listeners.remove((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeStatusListener(StatusListener listener) {
        Collection monitors = this.listeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeStatusListener(listener);
            }
        }
    }

    public synchronized IssueList addIssueListener(URL file, Project project, Workspace workspace, IssueListener listener, View view) {
        if (SUPRESSED) {
            return this.NULL_STATUS;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.listeners.add((Object)listener, (Object)monitor);
        return monitor.addIssueListener(listener, view);
    }

    public synchronized void removeIssueListener(URL file, Project project, Workspace workspace, IssueListener listener) {
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeIssueListener(listener);
            this.listeners.remove((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeIssueListener(IssueListener listener) {
        Collection monitors = this.listeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeIssueListener(listener);
            }
        }
    }

    public synchronized IssueList addAssistListener(URL file, Project project, Workspace workspace, AssistListener listener, View view) {
        if (SUPRESSED) {
            return this.NULL_STATUS;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.listeners.add((Object)listener, (Object)monitor);
        return monitor.addAssistListener(listener, view);
    }

    public synchronized void removeAssistListener(URL file, Project project, Workspace workspace, AssistListener listener) {
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeAssistListener(listener);
            this.listeners.remove((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeAssistListener(AssistListener listener) {
        Collection monitors = this.listeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeAssistListener(listener);
            }
        }
    }

    public synchronized boolean addStalenessListener(URL file, Project project, Workspace workspace, StalenessListener listener) {
        if (SUPRESSED) {
            return true;
        }
        StatusMonitor monitor = this.getOrCreateMonitor(file, project, workspace);
        this.listeners.add((Object)listener, (Object)monitor);
        return monitor.addStalenessListener(listener);
    }

    public synchronized void removeStalenessListener(URL file, Project project, Workspace workspace, StalenessListener listener) {
        StatusMonitor monitor = this.getMonitor(file, project, workspace);
        if (monitor != null) {
            monitor.removeStalenessListener(listener);
            this.listeners.remove((Object)listener, (Object)monitor);
        }
    }

    public synchronized void removeStalenessListener(StalenessListener listener) {
        Collection monitors = this.listeners.remove((Object)listener);
        if (monitors != null) {
            for (StatusMonitor monitor : monitors) {
                monitor.removeStalenessListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(boolean cancel) {
        StatusManager statusManager = this;
        synchronized (statusManager) {
            if (this.context == null) {
                this.listener = new MultiListener();
                this.context = new MonitorContext(new StatusExecutor(), this.listener);
                Ide.getWorkspaces().attach((Observer)this.listener);
            }
        }
        this.context.executor().pause(cancel);
    }

    public void resume() {
        this.context.executor().resume();
    }

    private StatusMonitor getMonitor(URL file, Project project, Workspace workspace) {
        Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.get(workspace);
        if (monitorsByProject == null) {
            return null;
        }
        Map<URL, StatusMonitor> monitorsByFile = monitorsByProject.get(project);
        if (monitorsByFile == null) {
            return null;
        }
        return monitorsByFile.get(file);
    }

    private StatusMonitor getOrCreateMonitor(URL file, Project project, Workspace workspace) {
        StatusMonitor monitor;
        Map<URL, StatusMonitor> monitorsByFile;
        if (workspace == null && project != null) {
            throw new IllegalArgumentException("workspace null implies project null");
        }
        Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.get(workspace);
        if (monitorsByProject == null) {
            monitorsByProject = new HashMap<Project, Map<URL, StatusMonitor>>();
            this.monitorsByWorkspace.put(workspace, monitorsByProject);
            if (workspace != null) {
                workspace.attach((Observer)this.listener);
            }
        }
        if ((monitorsByFile = monitorsByProject.get(project)) == null) {
            monitorsByFile = new HashMap<URL, StatusMonitor>();
            monitorsByProject.put(project, monitorsByFile);
        }
        if ((monitor = monitorsByFile.get(file)) == null) {
            monitor = new StatusMonitor(file, project, workspace, this.context);
            monitorsByFile.put(file, monitor);
            LOG.trace("created {0}", (Object)monitor);
        }
        return monitor;
    }

    private synchronized void profileChanged() {
        Map<Workspace, Map<Project, Map<URL, StatusMonitor>>> monitorsByWorkspace = this.monitorsByWorkspace;
        for (Map<Project, Map<URL, StatusMonitor>> monitorsByProject : monitorsByWorkspace.values()) {
            for (Map<URL, StatusMonitor> monitorsByFile : monitorsByProject.values()) {
                for (StatusMonitor monitor : monitorsByFile.values()) {
                    monitor.profileChanged();
                }
            }
        }
    }

    private synchronized void workspaceRemoved(Workspace workspace) {
        workspace.detach((Observer)this.listener);
        Map<Project, Map<URL, StatusMonitor>> monitorsByProject = this.monitorsByWorkspace.remove(workspace);
        if (monitorsByProject != null) {
            for (Map<URL, StatusMonitor> monitorsByFile : monitorsByProject.values()) {
                this.shutdownMonitors(monitorsByFile);
            }
        }
    }

    private void projectRemoved(Project project) {
        for (Map<Project, Map<URL, StatusMonitor>> monitorsByProject : this.monitorsByWorkspace.values()) {
            Map<URL, StatusMonitor> monitorsByFile = monitorsByProject.remove(project);
            if (monitorsByFile == null) continue;
            this.shutdownMonitors(monitorsByFile);
        }
    }

    private void shutdownMonitors(Map<URL, StatusMonitor> monitorsByFile) {
        for (StatusMonitor monitor : monitorsByFile.values()) {
            monitor.shutdown();
            for (StatusListener statusListener : monitor.getStatusListeners()) {
                this.listeners.remove((Object)statusListener, (Object)monitor);
            }
            for (IssueListener issueListener : monitor.getIssueListeners()) {
                this.listeners.remove((Object)issueListener, (Object)monitor);
            }
            for (AssistListener assistListener : monitor.getAssistListeners()) {
                this.listeners.remove((Object)assistListener, (Object)monitor);
            }
        }
    }

    static {
        LOG = new Log("status");
    }

    private class NullIssueList
    implements IssueList {
        private NullIssueList() {
        }

        public int size() {
            return 0;
        }

        public Issue getIssueAt(int index) {
            throw new IndexOutOfBoundsException();
        }

        public Severity getSeverity() {
            return Severity.OK;
        }

        public boolean isStale() {
            return false;
        }

        public int getErrorCount() {
            return 0;
        }

        public int getWarningCount() {
            return 0;
        }

        public int getIncompleteCount() {
            return 0;
        }

        public int getAdvisoryCount() {
            return 0;
        }

        public Collection<Issue> getOptionalAnalyses() {
            return Collections.emptyList();
        }

        public Iterator<Issue> iterator() {
            return EmptyIterator.emptyIterator();
        }
    }

    private class MultiListener
    implements ChangeListener,
    Observer {
        private MultiListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            StatusManager.this.profileChanged();
        }

        public void update(Object observed, UpdateMessage change) {
            if (change.getMessageID() == UpdateMessage.CHILD_REMOVED) {
                for (Object object : change.getRemoveObjects()) {
                    if (object instanceof Workspace) {
                        LOG.trace("workspace {0} removed", object);
                        StatusManager.this.workspaceRemoved((Workspace)object);
                        continue;
                    }
                    if (!(object instanceof Project)) continue;
                    LOG.trace("project {0} removed", object);
                    StatusManager.this.projectRemoved((Project)object);
                }
            }
        }
    }
}

