/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ideimpl.controller.CommandExecutionEvent;
import oracle.ideimpl.controller.CommandExecutionListener;
import oracle.ideimpl.controller.CommandExecutionTracker;
import oracle.javatools.util.Executors;
import oracle.javatools.util.Log;

class StatusExecutor
implements ShutdownHook,
CommandExecutionListener {
    private static final long NANO_ORIGIN = Log.TIME_ZERO_NANO;
    private StatusThreadPoolExecutor executor = new StatusThreadPoolExecutor();
    private static final Log LOG = new Log("status");

    static long translate(long time) {
        return time - NANO_ORIGIN;
    }

    static long translatedNow() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    static boolean isStatusThread() {
        return Thread.currentThread() instanceof StatusThread;
    }

    StatusExecutor() {
        ExitCommand.addShutdownHook((ShutdownHook)this);
        CommandExecutionTracker.commandExecutionTracker().addCommandExecutionListener((CommandExecutionListener)this);
    }

    void submit(Task task) {
        LOG.trace("submitting {0}", (Object)task);
        this.executor.execute(task);
    }

    void pause(boolean cancel) {
        LOG.trace("pausing {0}", (Object)this.executor.executingTask);
        this.executor.pause(cancel);
    }

    void resume() {
        LOG.trace("resuming {0}", (Object)this.executor.executingTask);
        this.executor.resume();
    }

    public void commandStarting(CommandExecutionEvent event) {
        LOG.trace("{0} starting", (Object)event);
        if (event.getOtherCount() == 0) {
            this.pause(false);
        }
    }

    public void commandEnded(CommandExecutionEvent event) {
        LOG.trace("{0} ended", (Object)event);
        if (event.getOtherCount() == 0) {
            this.resume();
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        LOG.trace("shutting down");
        Executors.shutdownNow((ExecutorService)this.executor);
    }

    private static class StatusQueue
    implements BlockingQueue<Runnable> {
        private DelayQueue<Task> queue = new DelayQueue();

        private StatusQueue() {
        }

        @Override
        public boolean add(Runnable o) {
            return this.queue.add((Task)o);
        }

        @Override
        public boolean addAll(Collection<? extends Runnable> c) {
            boolean added = false;
            for (Runnable runnable : c) {
                added |= this.queue.add((Task)runnable);
            }
            return added;
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.queue.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.queue.containsAll(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.queue.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.queue.drainTo(c, maxElements);
        }

        @Override
        public Task element() {
            return (Task)this.queue.element();
        }

        @Override
        public boolean equals(Object o) {
            return this.queue.equals(o);
        }

        @Override
        public int hashCode() {
            return this.queue.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public Iterator<Runnable> iterator() {
            return new Iterator<Runnable>(){
                private Iterator<Task> i;
                {
                    this.i = StatusQueue.this.queue.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Runnable next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean offer(Runnable o) {
            return this.queue.offer((Task)o);
        }

        @Override
        public boolean offer(Runnable o, long timeout, TimeUnit unit) {
            return this.queue.offer((Task)o, timeout, unit);
        }

        @Override
        public Task peek() {
            return (Task)this.queue.peek();
        }

        @Override
        public Task poll() {
            return (Task)this.queue.poll();
        }

        @Override
        public Task poll(long timeout, TimeUnit unit) throws InterruptedException {
            return (Task)this.queue.poll(timeout, unit);
        }

        @Override
        public void put(Runnable o) {
            this.queue.put((Task)o);
        }

        @Override
        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        @Override
        public Task remove() {
            return (Task)this.queue.remove();
        }

        @Override
        public boolean remove(Object o) {
            return this.queue.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.queue.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.queue.retainAll(c);
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public Task take() throws InterruptedException {
            return (Task)this.queue.take();
        }

        @Override
        public Object[] toArray() {
            return this.queue.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.queue.toArray(array);
        }

        public String toString() {
            return this.queue.toString();
        }
    }

    private static class StatusThread
    extends Thread
    implements Thread.UncaughtExceptionHandler {
        private static AtomicInteger count = new AtomicInteger(0);

        public StatusThread(Runnable target) {
            super(target, "status-" + count.getAndIncrement());
            this.setUncaughtExceptionHandler(this);
            this.setPriority(2);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LogRecord record = new LogRecord(Level.SEVERE, "uncaught exception in thread {0}: {1}");
            record.setParameters(new Object[]{t, e});
            record.setThrown(e);
            Logger.getLogger("oracle.ide.status").log(record);
        }
    }

    private static class StatusThreadFactory
    implements ThreadFactory {
        private StatusThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable runnable) {
            return new StatusThread(runnable);
        }
    }

    private static class StatusThreadPoolExecutor
    extends ThreadPoolExecutor {
        private ReentrantLock controlLock = new ReentrantLock();
        private Task executingTask;
        private int pauseCount;
        private Condition unpaused = this.controlLock.newCondition();

        public StatusThreadPoolExecutor() {
            super(1, 1, 0L, TimeUnit.NANOSECONDS, new StatusQueue(), new StatusThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
        }

        @Override
        public void execute(Runnable command) {
            super.execute(command);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause(boolean cancel) {
            Task task;
            this.controlLock.lock();
            try {
                ++this.pauseCount;
                task = this.executingTask;
            }
            finally {
                this.controlLock.unlock();
            }
            if (cancel && task != null) {
                task.cancel(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            this.controlLock.lock();
            try {
                if (this.pauseCount > 0 && --this.pauseCount == 0) {
                    this.unpaused.signalAll();
                }
            }
            finally {
                this.controlLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread thread, Runnable task) {
            super.beforeExecute(thread, task);
            this.controlLock.lock();
            try {
                while (this.pauseCount > 0) {
                    this.unpaused.await();
                }
                this.executingTask = (Task)task;
            }
            catch (InterruptedException ie) {
                thread.interrupt();
            }
            finally {
                this.controlLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable task, Throwable exception) {
            this.controlLock.lock();
            try {
                this.executingTask = null;
            }
            finally {
                this.controlLock.unlock();
            }
            super.afterExecute(task, exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Runnable> shutdownNow() {
            Task task;
            LOG.trace("shutting down, task {0}", (Object)this.executingTask);
            List<Runnable> runnables = super.shutdownNow();
            this.controlLock.lock();
            try {
                task = this.executingTask;
            }
            finally {
                this.controlLock.unlock();
            }
            if (task != null) {
                task.cancel(false);
            }
            return runnables;
        }
    }

    static interface Task
    extends Future<Void>,
    Runnable,
    Delayed {
    }
}

