/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.status;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.status.DefaultStatus;
import oracle.ide.status.resource.StatusBundle;
import oracle.javatools.status.Issue;
import oracle.javatools.status.IssueList;
import oracle.javatools.status.Status;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.Severity;
import oracle.jdeveloper.audit.model.Located;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.service.ViolationHelper;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.InternalCategory;

public class DefaultIssueList
extends DefaultStatus
implements IssueList,
Comparator<Issue> {
    private static final Log LOG_ISSUES = new Log("status-issues");
    private ViolationHelper helper = new ViolationHelper();
    private boolean assistsAccepted;
    private List<Issue> issues = new ArrayList<Issue>();
    private static int lastSerialNumber;

    DefaultIssueList(boolean assistsAccepted) {
        this.assistsAccepted = assistsAccepted;
    }

    DefaultIssueList(Status status, boolean assistsAccepted) {
        super(status);
        this.assistsAccepted = assistsAccepted;
        this.markStale();
    }

    DefaultIssueList(IssueList issues, boolean assistsAccepted) {
        super((Status)issues);
        for (Issue issue : issues) {
            this.addIssue(issue);
        }
        this.assistsAccepted = assistsAccepted;
        this.markStale();
    }

    @Override
    void addViolation(oracle.javatools.status.Severity severity, Violation violation, int transformMask) {
        super.addViolation(severity, violation, transformMask);
        if (severity == oracle.javatools.status.Severity.OK && !this.assistsAccepted) {
            LOG_ISSUES.trace("ignoring assist {0}", (Object)violation);
            return;
        }
        this.addIssue(new DefaultIssue(violation, transformMask, this.helper));
    }

    @Override
    void addException(Throwable exception, URL file, Project project, Workspace workspace, ModelFactory factory) {
        super.addException(exception, file, project, workspace, factory);
        this.addIssue(new InternalIssue(exception, file, project, workspace, factory));
    }

    @Override
    void markUnauditable(URL file, Project project, Workspace workspace, ModelFactory factory) {
        super.markUnauditable(file, project, workspace, factory);
        this.addIssue(new InternalIssue(file, project, workspace, factory));
    }

    private void addIssue(Issue issue) {
        int index = Collections.binarySearch(this.issues, issue, this);
        if (index < 0) {
            index = -index - 1;
        }
        this.issues.add(index, issue);
    }

    @Override
    public int compare(Issue v1, Issue v2) {
        return ((Violation)v1).getLocation().compareTo(((Violation)v2).getLocation());
    }

    public int size() {
        return this.issues.size();
    }

    public Issue getIssueAt(int index) {
        return this.issues.get(index);
    }

    public Iterator<Issue> iterator() {
        return this.issues.iterator();
    }

    @Override
    String classLabel() {
        return this.assistsAccepted ? "AssistList" : "IssueList";
    }

    private static class DefaultIssue
    implements Issue,
    Violation {
        private final Rule rule;
        private final Location location;
        private final int serialNumber;
        private final int bits;
        private final Object[] objects;

        public DefaultIssue(Violation violation, int transformMask, ViolationHelper helper) {
            this.rule = violation.getRule();
            this.location = violation.getLocation();
            this.serialNumber = ++lastSerialNumber;
            helper.pack(violation, transformMask);
            this.bits = helper.getBits();
            this.objects = helper.getObjects();
        }

        public String getMessage() {
            return this.rule.message((Violation)this);
        }

        public String getHtmlMessage() {
            return this.rule.htmlMessage((Violation)this);
        }

        public oracle.javatools.status.Severity getSeverity() {
            return DefaultStatus.issueSeverity(this.rule.getSeverity());
        }

        public Object getConstruct() {
            Location location = this.getLocation();
            return location.getModel().getConstruct(location);
        }

        public int getOffset() {
            return this.focusLocation().getOffset();
        }

        public int getLength() {
            return this.focusLocation().getLength();
        }

        public boolean hasTransforms() {
            return this.getTransformCount() > 0;
        }

        public List<? extends Action> getTransforms() {
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            return transformer.createTransformActions((Violation)this, null, null);
        }

        public int compareTo(Located that) {
            return this.location.compareTo(that.getLocation());
        }

        public Rule getRule() {
            return this.rule;
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getFocusLocation() {
            return ViolationHelper.unpackFocusLocation((int)this.bits, (Object[])this.objects, null);
        }

        public String getVariation() {
            return ViolationHelper.unpackVariation((int)this.bits, (Rule)this.rule);
        }

        public int getParameterCount() {
            return ViolationHelper.unpackParameterCount((int)this.bits);
        }

        public String getParameterName(int index) {
            return ViolationHelper.unpackParameterName((int)this.bits, (Object[])this.objects, (int)index);
        }

        public Object getParameterValue(int index) {
            return ViolationHelper.unpackParameterValue((int)this.bits, (Object[])this.objects, (int)index);
        }

        public Object getParameterValue(String name) {
            return ViolationHelper.unpackParameterValue((int)this.bits, (Object[])this.objects, (String)name);
        }

        public int getTransformCount() {
            return ViolationHelper.unpackTransformCount((int)this.bits);
        }

        public Transform getTransform(int index) {
            return ViolationHelper.unpackTransform((int)this.bits, (Rule)this.rule, (int)index);
        }

        public Location getTransformFocusLocation(int index) {
            return ViolationHelper.unpackTransformFocusLocation((int)this.bits, (Object[])this.objects, (int)index);
        }

        public Transform getDefaultTransform() {
            return ViolationHelper.unpackDefaultTransform((int)this.bits, (Rule)this.rule);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Issue[");
            buffer.append(this.rule.id());
            buffer.append('(');
            int count = this.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getParameterName(i));
                buffer.append('=');
                buffer.append(this.getParameterValue(i));
            }
            buffer.append(") ");
            buffer.append(this.focusLocation());
            buffer.append(']');
            return buffer.toString();
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }

        public int compareTo(DefaultIssue that) {
            int comparison = this.focusLocation().compareTo(that.focusLocation());
            if (comparison == 0) {
                comparison = this.serialNumber - that.serialNumber;
            }
            return comparison;
        }

        private Location focusLocation() {
            return ViolationHelper.unpackFocusLocation((int)this.bits, (Object[])this.objects, (Location)this.location);
        }
    }

    private static class InternalIssue
    implements Issue,
    Violation {
        private Rule rule;
        private Location location;
        private int serialNumber;
        private Object[] parameters;

        public InternalIssue(URL file, Project project, Workspace workspace, ModelFactory factory) {
            String parameterValue;
            String parameterName;
            String ruleName;
            this.setLocation(file, project, workspace, factory);
            if (project != null) {
                ruleName = "file-outside-project";
                parameterName = "project";
                parameterValue = project.getShortLabel();
            } else {
                ruleName = "file-outside-workspace";
                parameterName = "workspace";
                parameterValue = workspace.getShortLabel();
            }
            this.rule = new Rule(ruleName, (Category)new InternalCategory(), Severity.WARNING, Localizer.instance(StatusBundle.class));
            this.rule.setEnabled(true);
            this.parameters = new Object[4];
            this.parameters[0] = "file";
            this.parameters[1] = URLFileSystem.getFileName((URL)file);
            this.parameters[2] = parameterName;
            this.parameters[3] = parameterValue;
        }

        public InternalIssue(Throwable exception, URL file, Project project, Workspace workspace, ModelFactory factory) {
            this.setLocation(file, project, workspace, factory);
            this.rule = new Rule("internal-exception", (Category)new InternalCategory(), Severity.ERROR, Localizer.instance(StatusBundle.class));
            this.rule.setEnabled(true);
            if (exception instanceof InvocationTargetException) {
                exception = exception.getCause();
            }
            this.parameters = new Object[4];
            this.parameters[0] = "exception";
            this.parameters[1] = exception.getClass().getSimpleName();
            this.parameters[2] = "method";
            StackTraceElement[] trace = exception.getStackTrace();
            this.parameters[3] = trace.length > 0 ? trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber() : "?";
        }

        private void setLocation(URL file, Project project, Workspace workspace, ModelFactory factory) {
            Collection models = factory.getModelAdapters(null, file, project, workspace);
            if (models.isEmpty()) {
                if (project != null) {
                    models = factory.getModelAdapters((Element)project, null, null, workspace);
                } else if (workspace != null) {
                    models = factory.getModelAdapters((Element)workspace, null, null, null);
                } else {
                    throw new IllegalStateException("file " + file + " has neither workspace nor project context");
                }
            }
            ModelAdapter model = (ModelAdapter)models.iterator().next();
            this.location = model.getLocation(0, 0);
            this.serialNumber = ++lastSerialNumber;
        }

        public String getMessage() {
            return this.rule.message((Violation)this);
        }

        public String getHtmlMessage() {
            return this.rule.htmlMessage((Violation)this);
        }

        public oracle.javatools.status.Severity getSeverity() {
            return DefaultStatus.issueSeverity(this.rule.getSeverity());
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public boolean hasTransforms() {
            return false;
        }

        public List<? extends Action> getTransforms() {
            return Collections.emptyList();
        }

        public Object getConstruct() {
            Location location = this.getLocation();
            return location.getModel().getConstruct(location);
        }

        public int compareTo(Located that) {
            return this.location.compareTo(that.getLocation());
        }

        public Rule getRule() {
            return this.rule;
        }

        public Location getLocation() {
            return this.location;
        }

        public Location getFocusLocation() {
            return this.location;
        }

        public String getVariation() {
            return null;
        }

        public int getParameterCount() {
            return this.parameters.length / 2;
        }

        public String getParameterName(int index) {
            return (String)this.parameters[index * 2];
        }

        public Object getParameterValue(int index) {
            return this.parameters[index * 2 + 1];
        }

        public Object getParameterValue(String name) {
            for (int i = 0; i < this.parameters.length; i += 2) {
                if (!name.equals(this.parameters[i])) continue;
                return this.parameters[i + 1];
            }
            return null;
        }

        public int getTransformCount() {
            return 0;
        }

        public Transform getTransform(int index) {
            throw new IndexOutOfBoundsException();
        }

        public Location getTransformFocusLocation(int index) {
            return null;
        }

        public Transform getDefaultTransform() {
            return null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Issue[");
            buffer.append(this.rule.id());
            buffer.append('(');
            int count = this.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(this.getParameterName(i));
                buffer.append('=');
                buffer.append(this.getParameterValue(i));
            }
            buffer.append(") ");
            buffer.append(this.getLocation());
            buffer.append(']');
            return buffer.toString();
        }

        public int getSerialNumber() {
            return this.serialNumber;
        }
    }
}

