/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;

public class UnaryExpr
extends Expr {
    private boolean isNegative;

    public UnaryExpr(boolean bl, Expr expr) {
        super(expr);
        this.isNegative = bl;
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)UnaryExpr.getDoc().createElement("UnaryExpr");
        String string = this.isNegative ? "-" : "+";
        xMLElement.setAttribute("signe", string);
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLItem oXMLItem;
        OXMLSequence oXMLSequence = this.kids[0].Evaluate(queryState);
        boolean bl = this.kids[0].needAtomization();
        if (bl) {
            oXMLSequence = oXMLSequence.atomize();
        }
        if (!oXMLSequence.next()) {
            return bl ? queryState.createSequence(oXMLSequence) : queryState.createSequence();
        }
        OXMLItem oXMLItem2 = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
        }
        if (this.kids[0].needCast() && FNUtil.isUntypedAtomic((OXMLItem)oXMLItem2)) {
            oXMLItem2 = XQueryUtils.convert(oXMLItem2, OXMLSequenceType.TDOUBLE, queryState);
        }
        if (this.isNegative) {
            oXMLItem = queryState.createItem();
            oXMLItem.copyItem(oXMLItem2);
            oXMLItem.negate();
            oXMLItem2 = oXMLItem;
        }
        if (bl) {
            queryState.returnSequence(oXMLSequence);
        }
        oXMLItem = queryState.createSequence();
        oXMLItem.appendItem(oXMLItem2);
        return oXMLItem;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitUnaryExpr(this);
    }
}

