/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.NodeSourceIterator;
import oracle.xquery.exec.NodeSourceVisitor;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.StaticTypingVisitor;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Node;

public class Scan
extends NodeSource {
    Expr sourceExpr;
    private VarExpr posVar;

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)Scan.getDoc().createElement("Scan");
        xMLElement.appendChild((Node)this.sourceExpr.toXML());
        this.toXMLDefault(xMLElement);
        this.toXMLOutput(xMLElement);
        return xMLElement;
    }

    public ConvertXML fromXML(XMLElement xMLElement) {
        this.sourceExpr = (Expr)ConvertXMLUtils.createFromXML((XMLElement)xMLElement.getFirstChild(), false);
        super.fromXML(xMLElement);
        return this;
    }

    public void toSql(XQXGen xQXGen) {
        boolean bl;
        boolean bl2 = bl = this.getFilter() == null && this.getLetExprs() == null;
        if (bl) {
            this.sourceExpr.toSqlQuery(xQXGen, this.getOutVariable().var.getCanonicalName());
        } else {
            xQXGen.startElement("simpleQuery");
            xQXGen.startElement("selectList");
            xQXGen.startElement("selectItem");
            this.getOutVariable().var.toSqlDefn(xQXGen);
            this.getOutVariable().var.toSqlAlias(xQXGen);
            xQXGen.endElement("selectItem");
            xQXGen.endElement("selectList");
            xQXGen.startElement("fromList");
            xQXGen.startElement("fromItem");
            xQXGen.startElement("fromSubquery");
            this.sourceExpr.toSqlQuery(xQXGen, this.getOutVariable().getName());
            xQXGen.endElement("fromSubquery");
            xQXGen.endElement("fromItem");
            xQXGen.endElement("fromList");
            this.toSqlFilter(xQXGen);
            xQXGen.endElement("simpleQuery");
        }
    }

    private ExprResultIterator GetIterState() {
        return (ExprResultIterator)this.iterState;
    }

    public Scan(Expr expr, VarExpr varExpr) {
        super(varExpr);
        this.sourceExpr = expr;
    }

    public Scan(Expr expr, VarExpr varExpr, VarExpr varExpr2) {
        this(expr, varExpr);
        this.posVar = varExpr2;
    }

    public Scan() {
    }

    public NodeSource normalize() {
        this.sourceExpr = this.sourceExpr.normalize();
        return super.normalize();
    }

    public NodeSource optimize(OptimizeContext optimizeContext) {
        this.sourceExpr = this.sourceExpr.optimize(optimizeContext);
        return super.optimize(optimizeContext);
    }

    public NodeSourceIterator getNSIterator(QueryState queryState) {
        return new ScanNSIterator(this, queryState);
    }

    FSType staticTypeChecking(StaticTypingVisitor staticTypingVisitor) {
        return staticTypingVisitor.visitScan(this);
    }

    void acceptVisitor(NodeSourceVisitor nodeSourceVisitor) {
        nodeSourceVisitor.visitScan(this);
    }

    public static class ScanNSIterator
    extends NodeSourceIterator {
        private ExprResultIterator sourceExprIter = null;
        private int position = 0;
        private boolean unknownStaticType;

        public ScanNSIterator(Scan scan, QueryState queryState) {
            super(scan, queryState);
            this.unknownStaticType = scan.sourceExpr.unknownStaticType();
        }

        public void Start() {
            this.sourceExprIter = ((Scan)this.nodeSrc).sourceExpr.getIterator(this.qryState);
            this.sourceExprIter.Restart();
            this.position = 0;
        }

        public void Close() {
            Trace.trace(1, this, "Entering Close");
            if (this.sourceExprIter != null) {
                this.sourceExprIter.Close();
            }
        }

        public boolean Fetch() {
            OXMLItem oXMLItem = null;
            do {
                Trace.trace(1, this, "Scan Fetch\n");
                oXMLItem = this.sourceExprIter.Fetch();
                if (oXMLItem == null) {
                    return false;
                }
                ++this.position;
                this.nodeSrc.getOutVariable().setValue(this.unknownStaticType, this.qryState.createSequence(oXMLItem), this.qryState);
                if (((Scan)this.nodeSrc).posVar == null) continue;
                OXMLSequence oXMLSequence = this.qryState.createSequence();
                OXMLItem oXMLItem2 = this.qryState.createItem();
                oXMLItem2.setInt(OXMLSequenceType.TINTEGER, this.position);
                oXMLSequence.appendItem(oXMLItem2);
                ((Scan)this.nodeSrc).posVar.setValue(false, oXMLSequence, this.qryState);
            } while (!this.nodeSrc.EvaluateFilter(this.qryState));
            return true;
        }

        public boolean Started() {
            return this.sourceExprIter != null;
        }
    }
}

